/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.util.logging.OutputController;

public abstract class AbstractLaunchHandler
implements LaunchHandler {
    protected final OutputController logger;

    public AbstractLaunchHandler(OutputController logger) {
        this.logger = logger;
    }

    protected void printMessage(LaunchException ex) {
        StringBuilder result = new StringBuilder();
        result.append("netx: ");
        result.append(ex.getCategory());
        if (ex.getSummary() != null) {
            result.append(": ");
            result.append(ex.getSummary());
        }
        if (ex.getCause() != null) {
            result.append(this.recursiveDescription(ex.getCause()));
        }
        this.logger.log(OutputController.Level.MESSAGE_ALL, result.toString());
        this.logger.log(ex);
    }

    private String recursiveDescription(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        builder.append(throwable.getMessage() == null ? "" : throwable.getMessage());
        if (throwable.getCause() != null) {
            builder.append(this.recursiveDescription(throwable.getCause()));
        }
        builder.append(")");
        return builder.toString();
    }
}

