/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class InputMapUtils {
    private InputMapUtils() {
    }

    public static void unassignCtrlShiftUpDown(JComponent cmp, int condition) {
        InputMap inputMap = SwingUtilities.getUIInputMap(cmp, condition);
        inputMap.remove(KeyStroke.getKeyStroke(38, 192));
        inputMap.remove(KeyStroke.getKeyStroke(40, 192));
        inputMap.remove(KeyStroke.getKeyStroke(38, 576));
        inputMap.remove(KeyStroke.getKeyStroke(40, 576));
        SwingUtilities.replaceUIInputMap(cmp, 1, inputMap);
    }

    public static void unassignPageUpDown(JComponent cmp, int condition) {
        InputMap inputMap = SwingUtilities.getUIInputMap(cmp, condition);
        inputMap.remove(KeyStroke.getKeyStroke(33, 0));
        inputMap.remove(KeyStroke.getKeyStroke(34, 0));
        SwingUtilities.replaceUIInputMap(cmp, 1, inputMap);
    }

    public static void enableEnter(JButton b) {
        b.setFocusable(true);
        InputMapUtils.addEnterAction(b, b.getAction());
    }

    public static void addEnterAction(JComponent c, Action a) {
        InputMapUtils.addEnterAction(c, a, 0);
    }

    public static void addEnterActionWhenAncestor(JComponent c, Action a) {
        InputMapUtils.addEnterAction(c, a, 1);
    }

    private static void addEnterAction(JComponent c, Action a, int condition) {
        c.getActionMap().put("enter", a);
        c.getInputMap(condition).put(KeyStroke.getKeyStroke(10, 0), "enter");
    }

    public static void addSpacebarAction(JComponent c, Action a) {
        c.getActionMap().put("spacebar", a);
        c.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "spacebar");
    }

    public static void addEscapeAction(JComponent c, Action a) {
        c.getActionMap().put("escape", a);
        c.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
    }

    public static void addCtrlEnterAction(JComponent c, Action a) {
        KeyStroke stroke = KeyStroke.getKeyStroke(10, 128);
        c.getActionMap().put("ctrl_enter", a);
        c.getInputMap(2).put(stroke, "ctrl_enter");
    }
}

