/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.chunked.ChunkedDataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.extractor.scroll.ScrollDataExtractorFactory;

public interface DataExtractorFactory {
    public DataExtractor newExtractor(long var1, long var3);

    public static void create(Client client, DatafeedConfig datafeed, Job job, ActionListener<DataExtractorFactory> listener) {
        boolean isScrollSearch;
        ActionListener factoryHandler = ActionListener.wrap(factory -> listener.onResponse((Object)(datafeed.getChunkingConfig().isEnabled() ? new ChunkedDataExtractorFactory(client, datafeed, job, (DataExtractorFactory)factory) : factory)), arg_0 -> listener.onFailure(arg_0));
        boolean bl = isScrollSearch = !datafeed.hasAggregations();
        if (isScrollSearch) {
            ScrollDataExtractorFactory.create(client, datafeed, job, (ActionListener<DataExtractorFactory>)factoryHandler);
        } else {
            factoryHandler.onResponse((Object)new AggregationDataExtractorFactory(client, datafeed, job));
        }
    }
}

