/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public class TextFieldMapper
extends FieldMapper {
    private static final Logger logger = LogManager.getLogger(TextFieldMapper.class);
    public static final String CONTENT_TYPE = "text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    public static final String FAST_PHRASE_SUFFIX = "._index_phrase";
    private Boolean includeInAll;
    private int positionIncrementGap;
    private PrefixFieldMapper prefixFieldMapper;
    private PhraseFieldMapper phraseFieldMapper;

    protected TextFieldMapper(String simpleName, TextFieldType fieldType, MappedFieldType defaultFieldType, int positionIncrementGap, Boolean includeInAll, PrefixFieldMapper prefixFieldMapper, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.tokenized());
        assert (!fieldType.hasDocValues());
        if (this.fieldType().indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.name() + "]");
        }
        this.positionIncrementGap = positionIncrementGap;
        this.includeInAll = includeInAll;
        this.prefixFieldMapper = prefixFieldMapper;
        this.phraseFieldMapper = fieldType.indexPhrases ? new PhraseFieldMapper(new PhraseFieldType(fieldType), indexSettings) : null;
    }

    @Override
    protected TextFieldMapper clone() {
        return (TextFieldMapper)super.clone();
    }

    Boolean includeInAll() {
        return this.includeInAll;
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), value, this.fieldType().boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType());
            fields.add(field);
            if (this.fieldType().omitNorms()) {
                this.createFieldNamesField(context, fields);
            }
            if (this.prefixFieldMapper != null) {
                this.prefixFieldMapper.addField(value, fields);
            }
            if (this.phraseFieldMapper != null) {
                fields.add(new Field(this.phraseFieldMapper.fieldType.name(), value, (IndexableFieldType)this.phraseFieldMapper.fieldType));
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.prefixFieldMapper != null) {
            subIterators.add(this.prefixFieldMapper);
        }
        if (this.phraseFieldMapper != null) {
            subIterators.add(this.phraseFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        return Iterators.concat(super.iterator(), subIterators.iterator());
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((TextFieldMapper)mergeWith).includeInAll;
        TextFieldMapper mw = (TextFieldMapper)mergeWith;
        if (this.prefixFieldMapper != null && mw.prefixFieldMapper != null) {
            this.prefixFieldMapper = (PrefixFieldMapper)this.prefixFieldMapper.merge(mw.prefixFieldMapper, updateAllTypes);
        } else {
            if (this.prefixFieldMapper != null || mw.prefixFieldMapper != null) {
                throw new IllegalArgumentException("mapper [" + this.name() + "] has different index_prefix settings, current [" + this.prefixFieldMapper + "], merged [" + mw.prefixFieldMapper + "]");
            }
            if (this.fieldType().indexPhrases != mw.fieldType().indexPhrases) {
                throw new IllegalArgumentException("mapper [" + this.name() + "] has different index_phrases settings, current [" + this.fieldType().indexPhrases + "], merged [" + mw.fieldType().indexPhrases + "]");
            }
        }
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", true);
        }
        if (includeDefaults || this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
        if (includeDefaults || this.fieldType().fielddata() != ((TextFieldType)this.defaultFieldType).fielddata()) {
            builder.field("fielddata", this.fieldType().fielddata());
        }
        if (this.fieldType().fielddata() && (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0 || this.fieldType().fielddataMaxFrequency() != 2.147483647E9 || this.fieldType().fielddataMinSegmentSize() != 0)) {
            builder.startObject("fielddata_frequency_filter");
            if (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0) {
                builder.field("min", this.fieldType().fielddataMinFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMaxFrequency() != 2.147483647E9) {
                builder.field("max", this.fieldType().fielddataMaxFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMinSegmentSize() != 0) {
                builder.field("min_segment_size", this.fieldType().fielddataMinSegmentSize());
            }
            builder.endObject();
        }
        if (this.fieldType().prefixFieldType != null) {
            this.fieldType().prefixFieldType.doXContent(builder);
        }
        if (this.fieldType().indexPhrases) {
            builder.field("index_phrases", this.fieldType().indexPhrases);
        }
    }

    public static final class TextFieldType
    extends StringFieldType {
        private boolean fielddata;
        private double fielddataMinFrequency;
        private double fielddataMaxFrequency;
        private int fielddataMinSegmentSize;
        private PrefixFieldType prefixFieldType;
        private boolean indexPhrases = false;

        public TextFieldType() {
            this.setTokenized(true);
            this.fielddata = false;
            this.fielddataMinFrequency = 0.0;
            this.fielddataMaxFrequency = 2.147483647E9;
            this.fielddataMinSegmentSize = 0;
        }

        protected TextFieldType(TextFieldType ref) {
            super(ref);
            this.fielddata = ref.fielddata;
            this.fielddataMinFrequency = ref.fielddataMinFrequency;
            this.fielddataMaxFrequency = ref.fielddataMaxFrequency;
            this.fielddataMinSegmentSize = ref.fielddataMinSegmentSize;
            this.indexPhrases = ref.indexPhrases;
            if (ref.prefixFieldType != null) {
                this.prefixFieldType = ref.prefixFieldType.clone();
            }
        }

        @Override
        public TextFieldType clone() {
            return new TextFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            TextFieldType that = (TextFieldType)o;
            return this.fielddata == that.fielddata && this.indexPhrases == that.indexPhrases && Objects.equals(this.prefixFieldType, that.prefixFieldType) && this.fielddataMinFrequency == that.fielddataMinFrequency && this.fielddataMaxFrequency == that.fielddataMaxFrequency && this.fielddataMinSegmentSize == that.fielddataMinSegmentSize;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fielddata, this.indexPhrases, this.prefixFieldType, this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            TextFieldType otherType = (TextFieldType)other;
            if (!Objects.equals(this.prefixFieldType, otherType.prefixFieldType)) {
                if (this.prefixFieldType == null) {
                    conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings, cannot change from disabled to enabled");
                } else if (otherType.prefixFieldType == null) {
                    conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings, cannot change from enabled to disabled");
                } else {
                    conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings");
                }
            }
            if (this.indexPhrases != otherType.indexPhrases) {
                conflicts.add("mapper [" + this.name() + "] has different [index_phrases] settings");
            }
            if (strict) {
                if (this.fielddata() != otherType.fielddata()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
                }
                if (this.fielddataMinFrequency() != otherType.fielddataMinFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min] across all types.");
                }
                if (this.fielddataMaxFrequency() != otherType.fielddataMaxFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.max] across all types.");
                }
                if (this.fielddataMinSegmentSize() != otherType.fielddataMinSegmentSize()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min_segment_size] across all types.");
                }
            }
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.checkIfFrozen();
            this.fielddata = fielddata;
        }

        public double fielddataMinFrequency() {
            return this.fielddataMinFrequency;
        }

        public void setFielddataMinFrequency(double fielddataMinFrequency) {
            this.checkIfFrozen();
            this.fielddataMinFrequency = fielddataMinFrequency;
        }

        public double fielddataMaxFrequency() {
            return this.fielddataMaxFrequency;
        }

        public void setFielddataMaxFrequency(double fielddataMaxFrequency) {
            this.checkIfFrozen();
            this.fielddataMaxFrequency = fielddataMaxFrequency;
        }

        public int fielddataMinSegmentSize() {
            return this.fielddataMinSegmentSize;
        }

        public void setFielddataMinSegmentSize(int fielddataMinSegmentSize) {
            this.checkIfFrozen();
            this.fielddataMinSegmentSize = fielddataMinSegmentSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.checkIfFrozen();
            this.prefixFieldType = prefixFieldType;
        }

        void setIndexPhrases(boolean indexPhrases) {
            this.checkIfFrozen();
            this.indexPhrases = indexPhrases;
        }

        public PrefixFieldType getPrefixFieldType() {
            return this.prefixFieldType;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.accept(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query tq = this.prefixFieldType.termQuery(value, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(tq);
            }
            return tq;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }

        @Override
        public Query phraseQuery(String field, TokenStream stream, int slop, boolean enablePosIncrements) throws IOException {
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(TextFieldType.cache(stream))) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return super.phraseQuery(field, stream, slop, enablePosIncrements);
        }

        @Override
        public Query multiPhraseQuery(String field, TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(TextFieldType.cache(stream))) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return super.multiPhraseQuery(field, stream, slop, enablePositionIncrements);
        }

        private static CachingTokenFilter cache(TokenStream in) {
            if (in instanceof CachingTokenFilter) {
                return (CachingTokenFilter)in;
            }
            return new CachingTokenFilter(in);
        }

        private static boolean hasGaps(CachingTokenFilter stream) throws IOException {
            PositionIncrementAttribute posIncAtt = stream.getAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncAtt.getPositionIncrement() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            if (!this.fielddata) {
                throw new IllegalArgumentException("Fielddata is disabled on text fields by default. Set fielddata=true on [" + this.name() + "] in order to load fielddata in memory by uninverting the inverted index. Note that this can however use significant memory. Alternatively use a keyword field instead.");
            }
            return new PagedBytesIndexFieldData.Builder(this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
        }
    }

    private static final class PrefixFieldMapper
    extends FieldMapper {
        protected PrefixFieldMapper(PrefixFieldType fieldType, Settings indexSettings) {
            super(fieldType.name(), fieldType, fieldType, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(String value, List<IndexableField> fields) {
            fields.add(new Field(this.fieldType().name(), value, (IndexableFieldType)this.fieldType()));
        }

        @Override
        protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class PhraseFieldMapper
    extends FieldMapper {
        PhraseFieldMapper(PhraseFieldType fieldType, Settings indexSettings) {
            super(fieldType.name(), fieldType, fieldType, indexSettings, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String contentType() {
            return "phrase";
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;

        PrefixFieldType(String name, int minChars, int maxChars) {
            this.setTokenized(true);
            this.setOmitNorms(true);
            this.setIndexOptions(IndexOptions.DOCS);
            this.setName(name);
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        PrefixFieldType setAnalyzer(NamedAnalyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(delegate.name(), AnalyzerScope.INDEX, new PrefixWrappedAnalyzer(delegate.analyzer(), this.minChars, this.maxChars)));
            return this;
        }

        boolean accept(int length) {
            return length >= this.minChars && length <= this.maxChars;
        }

        void doXContent(XContentBuilder builder) throws IOException {
            builder.startObject("index_prefixes");
            builder.field("min_chars", this.minChars);
            builder.field("max_chars", this.maxChars);
            builder.endObject();
        }

        @Override
        public PrefixFieldType clone() {
            return new PrefixFieldType(this.name(), this.minChars, this.maxChars);
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        @Override
        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PrefixFieldType that = (PrefixFieldType)o;
            return this.minChars == that.minChars && this.maxChars == that.maxChars;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.minChars, this.maxChars);
        }
    }

    private static final class PhraseFieldType
    extends StringFieldType {
        final TextFieldType parent;

        PhraseFieldType(TextFieldType parent) {
            this.setTokenized(true);
            this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            if (parent.indexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                this.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
            }
            if (parent.storeTermVectorOffsets()) {
                this.setStoreTermVectors(true);
                this.setStoreTermVectorPositions(true);
                this.setStoreTermVectorOffsets(true);
            }
            this.setAnalyzer(parent.indexAnalyzer().name(), parent.indexAnalyzer().analyzer());
            this.setName(parent.name() + TextFieldMapper.FAST_PHRASE_SUFFIX);
            this.parent = parent;
        }

        void setAnalyzer(String name, Analyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(name, AnalyzerScope.INDEX, new PhraseWrappedAnalyzer(delegate)));
        }

        @Override
        public MappedFieldType clone() {
            return new PhraseFieldType(this.parent);
        }

        @Override
        public String typeName() {
            return "phrase";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PrefixWrappedAnalyzer
    extends AnalyzerWrapper {
        private final int minChars;
        private final int maxChars;
        private final Analyzer delegate;

        PrefixWrappedAnalyzer(Analyzer delegate, int minChars, int maxChars) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), this.minChars, this.maxChars);
            return new Analyzer.TokenStreamComponents(components.getTokenizer(), (TokenStream)filter);
        }
    }

    private static class PhraseWrappedAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        PhraseWrappedAnalyzer(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        @Override
        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        @Override
        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return new Analyzer.TokenStreamComponents(components.getTokenizer(), (TokenStream)new FixedShingleFilter(components.getTokenStream(), 2));
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(fieldName);
            builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            TypeParsers.parseTextField(builder, fieldName, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("position_increment_gap")) {
                    int newPositionIncrementGap = XContentMapValues.nodeIntegerValue(propNode, -1);
                    builder.positionIncrementGap(newPositionIncrementGap);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata")) {
                    builder.fielddata(XContentMapValues.nodeBooleanValue(propNode, "fielddata"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode, "eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata_frequency_filter")) {
                    Map frequencyFilter = (Map)propNode;
                    double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
                    double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
                    int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
                    builder.fielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
                    DocumentMapperParser.checkNoRemainingFields(propName, frequencyFilter, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("index_prefixes")) {
                    Map indexPrefix = (Map)propNode;
                    int minChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("min_chars"), 2);
                    int maxChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("max_chars"), 5);
                    builder.indexPrefixes(minChars, maxChars);
                    DocumentMapperParser.checkNoRemainingFields(propName, indexPrefix, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("index_phrases")) continue;
                builder.indexPhrases(XContentMapValues.nodeBooleanValue(propNode, "index_phrases"));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, TextFieldMapper> {
        private int positionIncrementGap = -1;
        private PrefixFieldType prefixFieldType;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public TextFieldType fieldType() {
            return (TextFieldType)super.fieldType();
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            if (positionIncrementGap < 0) {
                throw new MapperParsingException("[positions_increment_gap] must be positive, got " + positionIncrementGap);
            }
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldType().setFielddata(fielddata);
            return (Builder)this.builder;
        }

        public Builder indexPhrases(boolean indexPhrases) {
            this.fieldType().setIndexPhrases(indexPhrases);
            return (Builder)this.builder;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("[text] fields do not support doc values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder fielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.fieldType().setFielddataMinFrequency(minFreq);
            this.fieldType().setFielddataMaxFrequency(maxFreq);
            this.fieldType().setFielddataMinSegmentSize(minSegmentSize);
            return (Builder)this.builder;
        }

        public Builder indexPrefixes(int minChars, int maxChars) {
            if (minChars > maxChars) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be less than max_chars [" + maxChars + "]");
            }
            if (minChars < 1) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be greater than zero");
            }
            if (maxChars >= 20) {
                throw new IllegalArgumentException("max_chars [" + maxChars + "] must be less than 20");
            }
            this.prefixFieldType = new PrefixFieldType(this.name() + "._index_prefix", minChars, maxChars);
            this.fieldType().setPrefixFieldType(this.prefixFieldType);
            return this;
        }

        @Override
        public TextFieldMapper build(Mapper.BuilderContext context) {
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), this.positionIncrementGap));
            }
            this.setupFieldType(context);
            PrefixFieldMapper prefixMapper = null;
            if (this.prefixFieldType != null) {
                if (!this.fieldType().isSearchable()) {
                    throw new IllegalArgumentException("Cannot set index_prefixes on unindexed field [" + this.name() + "]");
                }
                if (context.indexCreatedVersion().onOrAfter(Version.V_6_4_0)) {
                    if (this.fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                        this.prefixFieldType.setIndexOptions(IndexOptions.DOCS);
                    } else {
                        this.prefixFieldType.setIndexOptions(this.fieldType.indexOptions());
                    }
                } else if (this.fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                    this.prefixFieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
                }
                if (this.fieldType.storeTermVectorOffsets()) {
                    this.prefixFieldType.setStoreTermVectorOffsets(true);
                }
                this.prefixFieldType.setAnalyzer(this.fieldType.indexAnalyzer());
                prefixMapper = new PrefixFieldMapper(this.prefixFieldType, context.indexSettings());
            }
            if (this.fieldType().indexPhrases) {
                if (!this.fieldType().isSearchable()) {
                    throw new IllegalArgumentException("Cannot set index_phrases on unindexed field [" + this.name() + "]");
                }
                if (this.fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set index_phrases on field [" + this.name() + "] if positions are not enabled");
                }
            }
            return new TextFieldMapper(this.name, this.fieldType(), this.defaultFieldType, this.positionIncrementGap, this.includeInAll, prefixMapper, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static final double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static final int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final int INDEX_PREFIX_MIN_CHARS = 2;
        public static final int INDEX_PREFIX_MAX_CHARS = 5;
        public static final MappedFieldType FIELD_TYPE = new TextFieldType();
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FIELD_TYPE.freeze();
        }
    }
}

