/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.StringUtils;

public class SslConfig {
    public static final String SSL = "ssl";
    private static final String SSL_DEFAULT = "false";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    private static final String SSL_PROTOCOL_DEFAULT = "TLS";
    public static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    private static final String SSL_KEYSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_KEYSTORE_PASS = "ssl.keystore.pass";
    private static final String SSL_KEYSTORE_PASS_DEFAULT = "";
    public static final String SSL_KEYSTORE_TYPE = "ssl.keystore.type";
    private static final String SSL_KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    private static final String SSL_TRUSTSTORE_LOCATION_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_PASS = "ssl.truststore.pass";
    private static final String SSL_TRUSTSTORE_PASS_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_TYPE = "ssl.truststore.type";
    private static final String SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    static final Set<String> OPTION_NAMES = new LinkedHashSet<String>(Arrays.asList("ssl", "ssl.protocol", "ssl.keystore.location", "ssl.keystore.pass", "ssl.keystore.type", "ssl.truststore.location", "ssl.truststore.pass", "ssl.truststore.type"));
    private final boolean enabled;
    private final String protocol;
    private final String keystoreLocation;
    private final String keystorePass;
    private final String keystoreType;
    private final String truststoreLocation;
    private final String truststorePass;
    private final String truststoreType;
    private final SSLContext sslContext;

    SslConfig(Properties settings, URI baseURI) {
        boolean isSchemaPresent = baseURI.getScheme() != null;
        boolean isSSLPropertyPresent = settings.getProperty(SSL) != null;
        boolean isHttpsScheme = "https".equals(baseURI.getScheme());
        if (!isSSLPropertyPresent && !isSchemaPresent) {
            this.enabled = StringUtils.parseBoolean(SSL_DEFAULT);
        } else {
            if (isSSLPropertyPresent && isHttpsScheme && !StringUtils.parseBoolean(settings.getProperty(SSL))) {
                throw new ClientException("Cannot enable SSL: HTTPS protocol being used in the URL and SSL disabled in properties");
            }
            this.enabled = isHttpsScheme || StringUtils.parseBoolean(settings.getProperty(SSL, SSL_DEFAULT));
        }
        this.protocol = settings.getProperty(SSL_PROTOCOL, SSL_PROTOCOL_DEFAULT);
        this.keystoreLocation = settings.getProperty(SSL_KEYSTORE_LOCATION, "");
        this.keystorePass = settings.getProperty(SSL_KEYSTORE_PASS, "");
        this.keystoreType = settings.getProperty(SSL_KEYSTORE_TYPE, "JKS");
        this.truststoreLocation = settings.getProperty(SSL_TRUSTSTORE_LOCATION, "");
        this.truststorePass = settings.getProperty(SSL_TRUSTSTORE_PASS, "");
        this.truststoreType = settings.getProperty(SSL_TRUSTSTORE_TYPE, "JKS");
        this.sslContext = this.enabled ? this.createSSLContext() : null;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    SSLSocketFactory sslSocketFactory() {
        return this.sslContext.getSocketFactory();
    }

    private SSLContext createSSLContext() {
        SSLContext ctx;
        try {
            ctx = SSLContext.getInstance(this.protocol);
            ctx.init(this.loadKeyManagers(), this.loadTrustManagers(), null);
        }
        catch (Exception ex) {
            throw new ClientException("Failed to initialize SSL - " + ex.getMessage(), ex);
        }
        return ctx;
    }

    private KeyManager[] loadKeyManagers() throws GeneralSecurityException, IOException {
        if (!StringUtils.hasText(this.keystoreLocation)) {
            return null;
        }
        char[] pass = StringUtils.hasText(this.keystorePass) ? this.keystorePass.trim().toCharArray() : null;
        KeyStore keyStore = this.loadKeyStore(this.keystoreLocation, pass, this.keystoreType);
        KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmFactory.init(keyStore, pass);
        return kmFactory.getKeyManagers();
    }

    private KeyStore loadKeyStore(String location, char[] pass, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        Path path = Paths.get(location, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ClientException("Expected to find keystore file at [" + location + "] but was unable to. Make sure you have specified a valid URI.");
        }
        try (InputStream in = Files.newInputStream(Paths.get(location, new String[0]), StandardOpenOption.READ);){
            keyStore.load(in, pass);
        }
        catch (Exception ex) {
            throw new ClientException("Cannot open keystore [" + location + "] - " + ex.getMessage(), ex);
        }
        return keyStore;
    }

    private TrustManager[] loadTrustManagers() throws GeneralSecurityException, IOException {
        KeyStore keyStore = null;
        if (StringUtils.hasText(this.truststoreLocation)) {
            char[] pass = StringUtils.hasText(this.truststorePass) ? this.truststorePass.trim().toCharArray() : null;
            keyStore = this.loadKeyStore(this.truststoreLocation, pass, this.truststoreType);
        }
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmFactory.init(keyStore);
        return tmFactory.getTrustManagers();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SslConfig other = (SslConfig)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.keystoreLocation, other.keystoreLocation) && Objects.equals(this.keystorePass, other.keystorePass) && Objects.equals(this.keystoreType, other.keystoreType) && Objects.equals(this.truststoreLocation, other.truststoreLocation) && Objects.equals(this.truststorePass, other.truststorePass) && Objects.equals(this.truststoreType, other.truststoreType);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

