/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum DataType {
    NULL(JDBCType.NULL, null, 0, 0, 0),
    UNSUPPORTED(JDBCType.OTHER, null, 0, 0, 0),
    BOOLEAN(JDBCType.BOOLEAN, Boolean.class, 1, 1, 1),
    BYTE(JDBCType.TINYINT, Byte.class, 1, 3, 5, true, false, true),
    SHORT(JDBCType.SMALLINT, Short.class, 2, 5, 6, true, false, true),
    INTEGER(JDBCType.INTEGER, Integer.class, 4, 10, 11, true, false, true),
    LONG(JDBCType.BIGINT, Long.class, 8, 19, 20, true, false, true),
    DOUBLE(JDBCType.DOUBLE, Double.class, 8, 15, 25, false, true, true),
    FLOAT(JDBCType.REAL, Float.class, 4, 7, 15, false, true, true),
    HALF_FLOAT(JDBCType.FLOAT, Double.class, 8, 16, 25, false, true, true),
    SCALED_FLOAT(JDBCType.FLOAT, Double.class, 8, 19, 25, false, true, true),
    KEYWORD(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, 256, 0),
    TEXT(JDBCType.VARCHAR, String.class, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false, false, false),
    OBJECT(JDBCType.STRUCT, null, -1, 0, 0, false, false, false),
    NESTED(JDBCType.STRUCT, null, -1, 0, 0, false, false, false),
    BINARY(JDBCType.VARBINARY, byte[].class, -1, Integer.MAX_VALUE, 0),
    DATE(JDBCType.TIMESTAMP, Timestamp.class, 8, 24, 24),
    IP(JDBCType.VARCHAR, String.class, 39, 39, 0, false, false, true);

    public static final String ODBC_DATATYPE_PREFIX = "SQL_";
    private static final Map<SQLType, DataType> jdbcToEs;
    private static final Map<String, DataType> odbcToEs;
    public final String esType = this.name().toLowerCase(Locale.ROOT);
    public final SQLType jdbcType;
    public final int size;
    public final int defaultPrecision;
    public final int displaySize;
    public final boolean isInteger;
    public final boolean isRational;
    public final boolean defaultDocValues;
    private final Class<?> javaClass;

    private DataType(SQLType jdbcType, Class<?> javaClass, int size, int defaultPrecision, int displaySize, boolean isInteger, boolean isRational, boolean defaultDocValues) {
        this.javaClass = javaClass;
        this.jdbcType = jdbcType;
        this.size = size;
        this.defaultPrecision = defaultPrecision;
        this.displaySize = displaySize;
        this.isInteger = isInteger;
        this.isRational = isRational;
        this.defaultDocValues = defaultDocValues;
    }

    private DataType(SQLType jdbcType, Class<?> javaClass, int size, int defaultPrecision, int displaySize) {
        this(jdbcType, javaClass, size, defaultPrecision, displaySize, false, false, true);
    }

    public String sqlName() {
        return this.jdbcType.getName();
    }

    public Class<?> javaClass() {
        return this.javaClass;
    }

    public boolean isNumeric() {
        return this.isInteger || this.isRational;
    }

    public boolean isSigned() {
        return this.isNumeric();
    }

    public boolean isString() {
        return this == KEYWORD || this == TEXT;
    }

    public boolean isPrimitive() {
        return this != OBJECT && this != NESTED;
    }

    public static DataType fromJdbcType(SQLType jdbcType) {
        if (!jdbcToEs.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type [" + jdbcType + "]");
        }
        return jdbcToEs.get(jdbcType);
    }

    public static Class<?> fromJdbcTypeToJava(SQLType jdbcType) {
        if (!jdbcToEs.containsKey(jdbcType)) {
            throw new IllegalArgumentException("Unsupported JDBC type [" + jdbcType + "]");
        }
        return jdbcToEs.get(jdbcType).javaClass();
    }

    public static DataType fromODBCType(String odbcType) {
        return odbcToEs.get(odbcType);
    }

    public static DataType fromEsType(String esType) {
        try {
            return DataType.valueOf(esType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            return UNSUPPORTED;
        }
    }

    public boolean isCompatibleWith(DataType other) {
        if (this == other) {
            return true;
        }
        return this == NULL || other == NULL || this.isString() && other.isString() || this.isNumeric() && other.isNumeric();
    }

    static {
        jdbcToEs = Arrays.stream(DataType.values()).filter(type -> type != TEXT && type != NESTED && type != SCALED_FLOAT && type != IP).collect(Collectors.toMap(dataType -> dataType.jdbcType, dataType -> dataType));
        odbcToEs = new HashMap<String, DataType>(36);
        odbcToEs.put("SQL_BIT", BOOLEAN);
        odbcToEs.put("SQL_TINYINT", BYTE);
        odbcToEs.put("SQL_SMALLINT", SHORT);
        odbcToEs.put("SQL_INTEGER", INTEGER);
        odbcToEs.put("SQL_BIGINT", LONG);
        odbcToEs.put("SQL_FLOAT", FLOAT);
        odbcToEs.put("SQL_REAL", FLOAT);
        odbcToEs.put("SQL_DOUBLE", DOUBLE);
        odbcToEs.put("SQL_DECIMAL", DOUBLE);
        odbcToEs.put("SQL_NUMERIC", DOUBLE);
        odbcToEs.put("SQL_GUID", KEYWORD);
        odbcToEs.put("SQL_CHAR", KEYWORD);
        odbcToEs.put("SQL_WCHAR", KEYWORD);
        odbcToEs.put("SQL_VARCHAR", TEXT);
        odbcToEs.put("SQL_WVARCHAR", TEXT);
        odbcToEs.put("SQL_LONGVARCHAR", TEXT);
        odbcToEs.put("SQL_WLONGVARCHAR", TEXT);
        odbcToEs.put("SQL_BINARY", BINARY);
        odbcToEs.put("SQL_VARBINARY", BINARY);
        odbcToEs.put("SQL_LONGVARBINARY", BINARY);
        odbcToEs.put("SQL_DATE", DATE);
        odbcToEs.put("SQL_TIME", DATE);
        odbcToEs.put("SQL_TIMESTAMP", DATE);
        odbcToEs.put("SQL_INTERVAL_HOUR_TO_MINUTE", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_HOUR_TO_SECOND", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_MINUTE_TO_SECOND", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_MONTH", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_YEAR", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_YEAR_TO_MONTH", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_DAY", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_HOUR", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_MINUTE", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_SECOND", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_HOUR", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_MINUTE", UNSUPPORTED);
        odbcToEs.put("SQL_INTERVAL_DAY_TO_SECOND", UNSUPPORTED);
    }
}

