/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexing;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.indexing.IterationResult;

public abstract class AsyncTwoPhaseIndexer<JobPosition, JobStats extends IndexerJobStats> {
    private static final Logger logger = Logger.getLogger((String)AsyncTwoPhaseIndexer.class.getName());
    private final JobStats stats;
    private final AtomicReference<IndexerState> state;
    private final AtomicReference<JobPosition> position;
    private final Executor executor;

    protected AsyncTwoPhaseIndexer(Executor executor, AtomicReference<IndexerState> initialState, JobPosition initialPosition, JobStats jobStats) {
        this.executor = executor;
        this.state = initialState;
        this.position = new AtomicReference<JobPosition>(initialPosition);
        this.stats = jobStats;
    }

    public IndexerState getState() {
        return this.state.get();
    }

    public JobPosition getPosition() {
        return this.position.get();
    }

    public JobStats getStats() {
        return this.stats;
    }

    public synchronized IndexerState start() {
        this.state.compareAndSet(IndexerState.STOPPED, IndexerState.STARTED);
        return this.state.get();
    }

    public synchronized IndexerState stop() {
        IndexerState currentState = this.state.updateAndGet(previousState -> {
            if (previousState == IndexerState.INDEXING) {
                return IndexerState.STOPPING;
            }
            if (previousState == IndexerState.STARTED) {
                return IndexerState.STOPPED;
            }
            return previousState;
        });
        return currentState;
    }

    public synchronized boolean abort() {
        IndexerState prevState = this.state.getAndUpdate(prev -> IndexerState.ABORTING);
        return prevState == IndexerState.STOPPED || prevState == IndexerState.STARTED;
    }

    public synchronized boolean maybeTriggerAsyncJob(long now) {
        IndexerState currentState = this.state.get();
        switch (currentState) {
            case INDEXING: 
            case STOPPING: 
            case ABORTING: {
                logger.warn((Object)("Schedule was triggered for job [" + this.getJobId() + "], but prior indexer is still running."));
                return false;
            }
            case STOPPED: {
                logger.debug((Object)("Schedule was triggered for job [" + this.getJobId() + "] but job is stopped.  Ignoring trigger."));
                return false;
            }
            case STARTED: {
                logger.debug((Object)("Schedule was triggered for job [" + this.getJobId() + "], state: [" + (Object)((Object)currentState) + "]"));
                ((IndexerJobStats)this.stats).incrementNumInvocations(1L);
                this.onStartJob(now);
                if (this.state.compareAndSet(IndexerState.STARTED, IndexerState.INDEXING)) {
                    this.executor.execute(() -> this.doNextSearch(this.buildSearchRequest(), (ActionListener<SearchResponse>)ActionListener.wrap(this::onSearchResponse, exc -> this.finishWithFailure((Exception)exc))));
                    logger.debug((Object)("Beginning to index [" + this.getJobId() + "], state: [" + (Object)((Object)currentState) + "]"));
                    return true;
                }
                logger.debug((Object)("Could not move from STARTED to INDEXING state because current state is [" + (Object)((Object)this.state.get()) + "]"));
                return false;
            }
        }
        logger.warn((Object)("Encountered unexpected state [" + (Object)((Object)currentState) + "] while indexing"));
        throw new IllegalStateException("Job encountered an illegal state [" + (Object)((Object)currentState) + "]");
    }

    protected abstract String getJobId();

    protected abstract IterationResult<JobPosition> doProcess(SearchResponse var1);

    protected abstract SearchRequest buildSearchRequest();

    protected abstract void onStartJob(long var1);

    protected abstract void doNextSearch(SearchRequest var1, ActionListener<SearchResponse> var2);

    protected abstract void doNextBulk(BulkRequest var1, ActionListener<BulkResponse> var2);

    protected abstract void doSaveState(IndexerState var1, JobPosition var2, Runnable var3);

    protected abstract void onFailure(Exception var1);

    protected abstract void onFinish();

    protected abstract void onAbort();

    private void finishWithFailure(Exception exc) {
        this.doSaveState(this.finishAndSetState(), this.position.get(), () -> this.onFailure(exc));
    }

    private IndexerState finishAndSetState() {
        return this.state.updateAndGet(prev -> {
            switch (prev) {
                case INDEXING: {
                    return IndexerState.STARTED;
                }
                case STOPPING: {
                    return IndexerState.STOPPED;
                }
                case ABORTING: {
                    this.onAbort();
                    return IndexerState.ABORTING;
                }
                case STOPPED: {
                    return IndexerState.STOPPED;
                }
            }
            throw new IllegalStateException("Indexer job encountered an illegal state [" + (Object)prev + "]");
        });
    }

    private void onSearchResponse(SearchResponse searchResponse) {
        try {
            if (!this.checkState(this.getState())) {
                return;
            }
            if (searchResponse.getShardFailures().length != 0) {
                throw new RuntimeException("Shard failures encountered while running indexer for job [" + this.getJobId() + "]: " + Arrays.toString(searchResponse.getShardFailures()));
            }
            ((IndexerJobStats)this.stats).incrementNumPages(1L);
            IterationResult<JobPosition> iterationResult = this.doProcess(searchResponse);
            if (iterationResult.isDone()) {
                logger.debug((Object)("Finished indexing for job [" + this.getJobId() + "], saving state and shutting down."));
                this.doSaveState(this.finishAndSetState(), this.position.get(), this::onFinish);
                return;
            }
            List<IndexRequest> docs = iterationResult.getToIndex();
            BulkRequest bulkRequest = new BulkRequest();
            docs.forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
            assert (bulkRequest.requests().size() > 0);
            this.doNextBulk(bulkRequest, (ActionListener<BulkResponse>)ActionListener.wrap(bulkResponse -> {
                if (bulkResponse.hasFailures()) {
                    logger.warn((Object)("Error while attempting to bulk index documents: " + bulkResponse.buildFailureMessage()));
                }
                ((IndexerJobStats)this.stats).incrementNumOutputDocuments(bulkResponse.getItems().length);
                if (!this.checkState(this.getState())) {
                    return;
                }
                Object newPosition = iterationResult.getPosition();
                this.position.set(newPosition);
                this.onBulkResponse((BulkResponse)bulkResponse, newPosition);
            }, exc -> this.finishWithFailure((Exception)exc)));
        }
        catch (Exception e) {
            this.finishWithFailure(e);
        }
    }

    private void onBulkResponse(BulkResponse response, JobPosition position) {
        try {
            ActionListener listener = ActionListener.wrap(this::onSearchResponse, this::finishWithFailure);
            if (((IndexerJobStats)this.stats).getNumPages() > 0L && ((IndexerJobStats)this.stats).getNumPages() % 50L == 0L) {
                this.doSaveState(IndexerState.INDEXING, position, () -> this.doNextSearch(this.buildSearchRequest(), (ActionListener<SearchResponse>)listener));
            } else {
                this.doNextSearch(this.buildSearchRequest(), (ActionListener<SearchResponse>)listener);
            }
        }
        catch (Exception e) {
            this.finishWithFailure(e);
        }
    }

    private boolean checkState(IndexerState currentState) {
        switch (currentState) {
            case INDEXING: {
                return true;
            }
            case STOPPING: {
                logger.info((Object)("Indexer job encountered [" + (Object)((Object)IndexerState.STOPPING) + "] state, halting indexer."));
                this.doSaveState(this.finishAndSetState(), this.getPosition(), () -> {});
                return false;
            }
            case STOPPED: {
                return false;
            }
            case ABORTING: {
                logger.info((Object)("Requested shutdown of indexer for job [" + this.getJobId() + "]"));
                this.onAbort();
                return false;
            }
        }
        logger.warn((Object)("Encountered unexpected state [" + (Object)((Object)currentState) + "] while indexing"));
        throw new IllegalStateException("Indexer job encountered an illegal state [" + (Object)((Object)currentState) + "]");
    }
}

