/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexing;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContentObject;

public abstract class IndexerJobStats
implements ToXContentObject,
Writeable {
    public static final ParseField NAME = new ParseField("job_stats", new String[0]);
    protected long numPages = 0L;
    protected long numInputDocuments = 0L;
    protected long numOuputDocuments = 0L;
    protected long numInvocations = 0L;

    public IndexerJobStats() {
    }

    public IndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations) {
        this.numPages = numPages;
        this.numInputDocuments = numInputDocuments;
        this.numOuputDocuments = numOuputDocuments;
        this.numInvocations = numInvocations;
    }

    public IndexerJobStats(StreamInput in) throws IOException {
        this.numPages = in.readVLong();
        this.numInputDocuments = in.readVLong();
        this.numOuputDocuments = in.readVLong();
        this.numInvocations = in.readVLong();
    }

    public long getNumPages() {
        return this.numPages;
    }

    public long getNumDocuments() {
        return this.numInputDocuments;
    }

    public long getNumInvocations() {
        return this.numInvocations;
    }

    public long getOutputDocuments() {
        return this.numOuputDocuments;
    }

    public void incrementNumPages(long n) {
        assert (n >= 0L);
        this.numPages += n;
    }

    public void incrementNumDocuments(long n) {
        assert (n >= 0L);
        this.numInputDocuments += n;
    }

    public void incrementNumInvocations(long n) {
        assert (n >= 0L);
        this.numInvocations += n;
    }

    public void incrementNumOutputDocuments(long n) {
        assert (n >= 0L);
        this.numOuputDocuments += n;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.numPages);
        out.writeVLong(this.numInputDocuments);
        out.writeVLong(this.numOuputDocuments);
        out.writeVLong(this.numInvocations);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IndexerJobStats that = (IndexerJobStats)other;
        return Objects.equals(this.numPages, that.numPages) && Objects.equals(this.numInputDocuments, that.numInputDocuments) && Objects.equals(this.numOuputDocuments, that.numOuputDocuments) && Objects.equals(this.numInvocations, that.numInvocations);
    }

    public int hashCode() {
        return Objects.hash(this.numPages, this.numInputDocuments, this.numOuputDocuments, this.numInvocations);
    }
}

