/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class OpenJobAction
extends Action<Request, AcknowledgedResponse, RequestBuilder> {
    public static final OpenJobAction INSTANCE = new OpenJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/open";
    public static final String TASK_NAME = "xpack/ml/job";

    private OpenJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public static interface JobTaskMatcher {
        public static boolean match(Task task, String expectedJobId) {
            if (task instanceof JobTaskMatcher) {
                if ("_all".equals(expectedJobId)) {
                    return true;
                }
                String expectedDescription = "job-" + expectedJobId;
                return expectedDescription.equals(task.getDescription());
            }
            return false;
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, OpenJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class JobParams
    implements XPackPlugin.XPackPersistentTaskParams {
        public static final ParseField IGNORE_DOWNTIME = new ParseField("ignore_downtime", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static ObjectParser<JobParams, Void> PARSER = new ObjectParser("xpack/ml/job", true, JobParams::new);
        private String jobId;
        private TimeValue timeout = MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT;

        public static JobParams fromXContent(XContentParser parser) {
            return JobParams.parseRequest(null, parser);
        }

        public static JobParams parseRequest(String jobId, XContentParser parser) {
            JobParams params = (JobParams)PARSER.apply(parser, null);
            if (jobId != null) {
                params.jobId = jobId;
            }
            return params;
        }

        JobParams() {
        }

        public JobParams(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public JobParams(StreamInput in) throws IOException {
            this.jobId = in.readString();
            if (in.getVersion().onOrBefore(Version.V_5_5_0)) {
                in.readBoolean();
            }
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getWriteableName() {
            return OpenJobAction.TASK_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            if (out.getVersion().onOrBefore(Version.V_5_5_0)) {
                out.writeBoolean(true);
            }
            out.writeVLong(this.timeout.millis());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JobParams other = (JobParams)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public Version getMinimalSupportedVersion() {
            return Version.CURRENT.minimumCompatibilityVersion();
        }

        static {
            PARSER.declareString(JobParams::setJobId, Job.ID);
            PARSER.declareBoolean((p, v) -> {}, IGNORE_DOWNTIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        private JobParams jobParams;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobParams jobParams = (JobParams)JobParams.PARSER.apply(parser, null);
            if (jobId != null) {
                jobParams.jobId = jobId;
            }
            return new Request(jobParams);
        }

        public Request(JobParams jobParams) {
            this.jobParams = jobParams;
        }

        public Request(String jobId) {
            this.jobParams = new JobParams(jobId);
        }

        public Request(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        public Request() {
        }

        public JobParams getJobParams() {
            return this.jobParams;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobParams = new JobParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobParams.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobParams.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobParams);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobParams, other.jobParams);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

