/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.index;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.analysis.index.EsIndex;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolution;
import org.elasticsearch.xpack.sql.analysis.index.MappingException;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DateEsField;
import org.elasticsearch.xpack.sql.type.EsField;
import org.elasticsearch.xpack.sql.type.KeywordEsField;
import org.elasticsearch.xpack.sql.type.TextEsField;
import org.elasticsearch.xpack.sql.type.Types;
import org.elasticsearch.xpack.sql.type.UnsupportedEsField;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class IndexResolver {
    private static final IndicesOptions INDICES_ONLY_OPTIONS = new IndicesOptions(EnumSet.of(IndicesOptions.Option.ALLOW_NO_INDICES, IndicesOptions.Option.IGNORE_UNAVAILABLE, IndicesOptions.Option.IGNORE_ALIASES), EnumSet.of(IndicesOptions.WildcardStates.OPEN));
    private final Client client;
    private final String clusterName;

    public IndexResolver(Client client, String clusterName) {
        this.client = client;
        this.clusterName = clusterName;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public void resolveNames(String indexWildcard, String javaRegex, EnumSet<IndexType> types, ActionListener<Set<IndexInfo>> listener) {
        boolean retrieveAliases = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.ALIAS);
        boolean retrieveIndices = CollectionUtils.isEmpty(types) || types.contains((Object)IndexType.INDEX);
        String[] indices = Strings.commaDelimitedListToStringArray((String)indexWildcard);
        if (retrieveAliases) {
            GetAliasesRequest aliasRequest = ((GetAliasesRequest)new GetAliasesRequest().local(true)).aliases(indices).indicesOptions(IndicesOptions.lenientExpandOpen());
            this.client.admin().indices().getAliases(aliasRequest, ActionListener.wrap(aliases -> this.resolveIndices(indices, javaRegex, (GetAliasesResponse)aliases, retrieveIndices, listener), ex -> {
                if (ex instanceof IndexNotFoundException || ex instanceof ElasticsearchSecurityException) {
                    this.resolveIndices(indices, javaRegex, null, retrieveIndices, listener);
                } else {
                    listener.onFailure(ex);
                }
            }));
        } else {
            this.resolveIndices(indices, javaRegex, null, retrieveIndices, listener);
        }
    }

    private void resolveIndices(String[] indices, String javaRegex, GetAliasesResponse aliases, boolean retrieveIndices, ActionListener<Set<IndexInfo>> listener) {
        if (retrieveIndices) {
            GetIndexRequest indexRequest = (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(indices)).features(new GetIndexRequest.Feature[]{GetIndexRequest.Feature.SETTINGS}).includeDefaults(false).indicesOptions(INDICES_ONLY_OPTIONS);
            this.client.admin().indices().getIndex(indexRequest, ActionListener.wrap(response -> this.filterResults(javaRegex, aliases, (GetIndexResponse)response, listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.filterResults(javaRegex, aliases, null, listener);
        }
    }

    private void filterResults(String javaRegex, GetAliasesResponse aliases, GetIndexResponse indices, ActionListener<Set<IndexInfo>> listener) {
        String[] indicesNames;
        Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
        TreeSet<IndexInfo> result = new TreeSet<IndexInfo>(Comparator.comparing(IndexInfo::name));
        if (aliases != null) {
            for (ObjectCursor cursor : aliases.getAliases().values()) {
                for (AliasMetaData amd : (List)cursor.value) {
                    String alias = amd.alias();
                    if (alias == null || pattern != null && !pattern.matcher(alias).matches()) continue;
                    result.add(new IndexInfo(alias, IndexType.ALIAS));
                }
            }
        }
        String[] stringArray = indicesNames = indices != null ? indices.indices() : null;
        if (indicesNames != null) {
            for (String indexName : indicesNames) {
                if (pattern != null && !pattern.matcher(indexName).matches()) continue;
                result.add(new IndexInfo(indexName, IndexType.INDEX));
            }
        }
        listener.onResponse(result);
    }

    public void resolveAsMergedMapping(String indexWildcard, String javaRegex, ActionListener<IndexResolution> listener) {
        FieldCapabilitiesRequest fieldRequest = IndexResolver.createFieldCapsRequest(indexWildcard);
        this.client.fieldCaps(fieldRequest, ActionListener.wrap(response -> listener.onResponse((Object)IndexResolver.mergedMapping(indexWildcard, response.get())), arg_0 -> listener.onFailure(arg_0)));
    }

    static IndexResolution mergedMapping(String indexPattern, Map<String, Map<String, FieldCapabilities>> fieldCaps) {
        if (fieldCaps == null || fieldCaps.isEmpty()) {
            return IndexResolution.notFound(indexPattern);
        }
        StringBuilder errorMessage = new StringBuilder();
        TreeSet<Map.Entry> sortedFields = new TreeSet<Map.Entry>(Collections.reverseOrder(Comparator.comparing(Map.Entry::getKey)));
        sortedFields.addAll(fieldCaps.entrySet());
        TreeMap<String, EsField> hierarchicalMapping = new TreeMap<String, EsField>();
        LinkedHashMap<String, EsField> flattedMapping = new LinkedHashMap<String, EsField>();
        for (Map.Entry entry : sortedFields) {
            String name = (String)entry.getKey();
            if (name.startsWith("_")) continue;
            Map types = (Map)entry.getValue();
            if (types.size() > 1) {
                for (Map.Entry type : types.entrySet()) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append("[");
                    errorMessage.append((String)type.getKey());
                    errorMessage.append("] in ");
                    errorMessage.append(Arrays.toString(((FieldCapabilities)type.getValue()).indices()));
                }
                errorMessage.insert(0, "[" + indexPattern + "] points to indices with incompatible mappings; field [" + name + "] is mapped in [" + types.size() + "] different ways: ");
            }
            if (errorMessage.length() > 0) {
                return IndexResolution.invalid(errorMessage.toString());
            }
            FieldCapabilities fieldCap = (FieldCapabilities)types.values().iterator().next();
            if (fieldCap.isAggregatable() && fieldCap.nonAggregatableIndices() != null) {
                errorMessage.append("[" + indexPattern + "] points to indices with incompatible mappings: ");
                errorMessage.append("field [" + name + "] is aggregateable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonAggregatableIndices()));
            }
            if (fieldCap.isSearchable() && fieldCap.nonSearchableIndices() != null) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(",");
                }
                errorMessage.append("[" + indexPattern + "] points to indices with incompatible mappings: ");
                errorMessage.append("field [" + name + "] is searchable except in ");
                errorMessage.append(Arrays.toString(fieldCap.nonSearchableIndices()));
            }
            if (errorMessage.length() > 0) {
                return IndexResolution.invalid(errorMessage.toString());
            }
            if (flattedMapping.containsKey(name)) continue;
            IndexResolver.createField(name, fieldCap, fieldCaps, hierarchicalMapping, flattedMapping, false);
        }
        return IndexResolution.valid(new EsIndex(indexPattern, hierarchicalMapping));
    }

    private static EsField createField(String fieldName, FieldCapabilities caps, Map<String, Map<String, FieldCapabilities>> globalCaps, Map<String, EsField> hierarchicalMapping, Map<String, EsField> flattedMapping, boolean hasChildren) {
        Map<String, EsField> parentProps = hierarchicalMapping;
        int dot = fieldName.lastIndexOf(46);
        String fullFieldName = fieldName;
        if (dot >= 0) {
            String parentName = fieldName.substring(0, dot);
            fieldName = fieldName.substring(dot + 1);
            EsField parent = flattedMapping.get(parentName);
            if (parent == null) {
                Map<String, FieldCapabilities> map = globalCaps.get(parentName);
                if (map == null) {
                    throw new SqlIllegalArgumentException("Cannot find field {}; this is likely a bug", parentName);
                }
                FieldCapabilities parentCap = map.values().iterator().next();
                parent = IndexResolver.createField(parentName, parentCap, globalCaps, hierarchicalMapping, flattedMapping, true);
            }
            parentProps = parent.getProperties();
        }
        EsField field = null;
        TreeMap<String, EsField> props = hasChildren ? new TreeMap<String, EsField>() : Collections.emptyMap();
        DataType esType = DataType.fromEsType((String)caps.getType());
        switch (esType) {
            case TEXT: {
                field = new TextEsField(fieldName, props, false);
                break;
            }
            case KEYWORD: {
                int length = DataType.KEYWORD.defaultPrecision;
                boolean normalized = false;
                field = new KeywordEsField(fieldName, props, caps.isAggregatable(), length, normalized);
                break;
            }
            case DATE: {
                field = new DateEsField(fieldName, props, caps.isAggregatable(), new String[0]);
                break;
            }
            case UNSUPPORTED: {
                field = new UnsupportedEsField(fieldName, caps.getType());
                break;
            }
            default: {
                field = new EsField(fieldName, esType, props, caps.isAggregatable());
            }
        }
        parentProps.put(fieldName, field);
        flattedMapping.put(fullFieldName, field);
        return field;
    }

    private static FieldCapabilitiesRequest createFieldCapsRequest(String index) {
        return new FieldCapabilitiesRequest().indices(Strings.commaDelimitedListToStringArray((String)index)).fields(new String[]{"*"}).indicesOptions(IndicesOptions.lenientExpandOpen());
    }

    public void resolveAsSeparateMappings(String indexWildcard, String javaRegex, ActionListener<List<EsIndex>> listener) {
        GetIndexRequest getIndexRequest = IndexResolver.createGetIndexRequest(indexWildcard);
        this.client.admin().indices().getIndex(getIndexRequest, ActionListener.wrap(getIndexResponse -> {
            ImmutableOpenMap mappings = getIndexResponse.getMappings();
            ArrayList<EsIndex> results = new ArrayList<EsIndex>(mappings.size());
            Pattern pattern = javaRegex != null ? Pattern.compile(javaRegex) : null;
            for (ObjectObjectCursor indexMappings : mappings) {
                IndexResolution getIndexResult;
                String concreteIndex = (String)indexMappings.key;
                if (pattern != null && !pattern.matcher(concreteIndex).matches() || !(getIndexResult = IndexResolver.buildGetIndexResult(concreteIndex, concreteIndex, (ImmutableOpenMap<String, MappingMetaData>)((ImmutableOpenMap)indexMappings.value))).isValid()) continue;
                results.add(getIndexResult.get());
            }
            results.sort(Comparator.comparing(EsIndex::name));
            listener.onResponse(results);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static GetIndexRequest createGetIndexRequest(String index) {
        return (GetIndexRequest)((GetIndexRequest)((GetIndexRequest)new GetIndexRequest().local(true)).indices(Strings.commaDelimitedListToStringArray((String)index))).indicesOptions(IndicesOptions.lenientExpandOpen());
    }

    private static IndexResolution buildGetIndexResult(String concreteIndex, String indexOrAlias, ImmutableOpenMap<String, MappingMetaData> mappings) {
        MappingMetaData singleType = null;
        ArrayList<String> typeNames = null;
        for (ObjectObjectCursor type : mappings) {
            if ("_default_".equals(type.key)) continue;
            if (singleType != null) {
                if (typeNames == null) {
                    typeNames = new ArrayList<String>();
                    typeNames.add(singleType.type());
                }
                typeNames.add((String)type.key);
            }
            singleType = (MappingMetaData)type.value;
        }
        if (singleType == null) {
            return IndexResolution.invalid("[" + indexOrAlias + "] doesn't have any types so it is incompatible with sql");
        }
        if (typeNames != null) {
            Collections.sort(typeNames);
            return IndexResolution.invalid("[" + indexOrAlias + "] contains more than one type " + typeNames + " so it is incompatible with sql");
        }
        try {
            Map<String, EsField> mapping = Types.fromEs(singleType.sourceAsMap());
            return IndexResolution.valid(new EsIndex(indexOrAlias, mapping));
        }
        catch (MappingException ex) {
            return IndexResolution.invalid(ex.getMessage());
        }
    }

    public static class IndexInfo {
        private final String name;
        private final IndexType type;

        public IndexInfo(String name, IndexType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public IndexType type() {
            return this.type;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IndexInfo other = (IndexInfo)obj;
            return Objects.equals(this.name, other.name) && Objects.equals((Object)this.type, (Object)other.type);
        }
    }

    public static enum IndexType {
        INDEX("BASE TABLE"),
        ALIAS("ALIAS"),
        UNKNOWN("UKNOWN");

        public static final EnumSet<IndexType> VALID;
        private final String toSql;

        private IndexType(String sql) {
            this.toSql = sql;
        }

        public String toSql() {
            return this.toSql;
        }

        public static IndexType from(String name) {
            if (name != null) {
                name = name.toUpperCase(Locale.ROOT);
                for (IndexType type : VALID) {
                    if (!type.toSql.equals(name)) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }

        static {
            VALID = EnumSet.of(INDEX, ALIAS);
        }
    }
}

