/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.UnaryPipe;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class UnaryScalarFunction
extends ScalarFunction {
    private final Expression field;

    protected UnaryScalarFunction(Location location) {
        super(location);
        this.field = null;
    }

    protected UnaryScalarFunction(Location location, Expression field) {
        super(location, Collections.singletonList(field));
        this.field = field;
    }

    @Override
    public final UnaryScalarFunction replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract UnaryScalarFunction replaceChild(Expression var1);

    public Expression field() {
        return this.field;
    }

    @Override
    public final Pipe makePipe() {
        return new UnaryPipe(this.location(), this, Expressions.pipe(this.field()), this.makeProcessor());
    }

    protected abstract Processor makeProcessor();

    @Override
    public boolean foldable() {
        return this.field.foldable();
    }

    @Override
    public ScriptTemplate asScript() {
        return this.asScript(this.field);
    }
}

