/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class InPipe
extends Pipe {
    private List<Pipe> pipes;

    public InPipe(Location location, Expression expression, List<Pipe> pipes) {
        super(location, expression, pipes);
        this.pipes = pipes;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() < 2) {
            throw new IllegalArgumentException("expected at least [2] children but received [" + newChildren.size() + "]");
        }
        return new InPipe(this.location(), this.expression(), newChildren);
    }

    @Override
    protected NodeInfo<InPipe> info() {
        return NodeInfo.create(this, InPipe::new, this.expression(), this.pipes);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.pipes.stream().allMatch(FieldExtraction::supportedByAggsOnlyQuery);
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        ArrayList<Pipe> newPipes = new ArrayList<Pipe>(this.pipes.size());
        for (Pipe p : this.pipes) {
            newPipes.add(p.resolveAttributes(resolver));
        }
        return this.replaceChildren(newPipes);
    }

    @Override
    public boolean resolved() {
        return Resolvables.resolved(this.pipes);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.pipes.forEach(p -> p.collectFields(sourceBuilder));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pipes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InPipe other = (InPipe)obj;
        return Objects.equals(this.pipes, other.pipes);
    }

    @Override
    public InProcessor asProcessor() {
        return new InProcessor(this.pipes.stream().map(Pipe::asProcessor).collect(Collectors.toList()));
    }
}

