/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class OrderBy
extends UnaryPlan {
    private final List<Order> order;

    public OrderBy(Location location, LogicalPlan child, List<Order> order) {
        super(location, child);
        this.order = order;
    }

    @Override
    protected NodeInfo<OrderBy> info() {
        return NodeInfo.create(this, OrderBy::new, this.child(), this.order);
    }

    @Override
    protected OrderBy replaceChild(LogicalPlan newChild) {
        return new OrderBy(this.location(), newChild, this.order);
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.order, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.child(), other.child());
    }
}

