/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageBundle;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Utils;
import java.text.BreakIterator;
import java.util.Locale;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

class Tokenizer {
    private final Document doc;
    private final SpellCheckerOptions options;
    private final LanguageBundle bundle;
    private int paragraphOffset;
    private int endOffset;
    private String phrase;
    private final Dictionary dictionary;
    private BreakIterator sentences;
    private int startSentence;
    private int endSentence;
    private int startWord;
    private int endWord;
    private String sentence;
    private BreakIterator words;
    private int wordOffset;
    private boolean isFirstWordInSentence;

    Tokenizer(JTextComponent jTextComponent, Dictionary dictionary, Locale locale, SpellCheckerOptions spellCheckerOptions) {
        this(jTextComponent, dictionary, locale, 0, jTextComponent.getDocument().getLength(), spellCheckerOptions);
    }

    Tokenizer(JTextComponent jTextComponent, Dictionary dictionary, Locale locale, int n, SpellCheckerOptions spellCheckerOptions) {
        this(jTextComponent, dictionary, locale, Utilities.getParagraphElement(jTextComponent, n).getStartOffset(), Utilities.getParagraphElement(jTextComponent, n).getEndOffset(), spellCheckerOptions);
    }

    Tokenizer(JTextComponent jTextComponent, Dictionary dictionary, Locale locale, int n, int n2, SpellCheckerOptions spellCheckerOptions) {
        this.dictionary = dictionary;
        this.doc = jTextComponent.getDocument();
        this.bundle = LanguageBundle.get(locale);
        this.options = spellCheckerOptions == null ? SpellChecker.getOptions() : spellCheckerOptions;
        this.sentences = BreakIterator.getSentenceInstance(locale);
        this.words = BreakIterator.getWordInstance(locale);
        this.paragraphOffset = n;
        this.endOffset = n2;
        this.setSentencesText();
        this.endSentence = this.sentences.first();
        this.endWord = -1;
    }

    String nextInvalidWord() {
        this.isFirstWordInSentence = false;
        block3: while (true) {
            if (this.endWord == -1) {
                this.startSentence = this.endSentence;
                this.endSentence = this.sentences.next();
                if (this.endSentence == -1) {
                    if (!this.nextParagraph()) {
                        return null;
                    }
                } else {
                    this.nextSentence();
                }
            }
            while (true) {
                if (this.endWord == -1) continue block3;
                String string = this.sentence.substring(this.startWord, this.endWord).trim();
                this.wordOffset = this.startSentence + this.startWord;
                this.startWord = this.endWord;
                this.endWord = this.words.next();
                if (string.length() > 1 && Character.isLetter(string.charAt(0))) {
                    boolean bl = this.bundle.existInDictionary(string, this.dictionary, this.options, this.isFirstWordInSentence);
                    if (!bl && this.options.isIgnoreAllCapsWords() && Utils.isAllCapitalized(string)) {
                        bl = true;
                    }
                    if (!bl && this.options.isIgnoreWordsWithNumbers() && Utils.isIncludeNumbers(string)) {
                        bl = true;
                    }
                    if (!bl && this.startWord + 1 == this.endWord) {
                        char c = this.sentence.charAt(this.startWord);
                        switch (c) {
                            case '\'': 
                            case '.': {
                                bl = this.bundle.existInDictionary(string + c, this.dictionary, this.options, this.isFirstWordInSentence);
                            }
                        }
                    }
                    if (!bl && !this.isWebAddress(string)) {
                        return string;
                    }
                    this.isFirstWordInSentence = false;
                    continue;
                }
                if (!":".equals(string) && !"(".equals(string)) continue;
                this.isFirstWordInSentence = true;
            }
            break;
        }
    }

    private boolean isWebAddress(String string) {
        if (this.startWord >= this.sentence.length()) {
            return false;
        }
        if (this.sentence.charAt(this.startWord) == '@') {
            string = string + '@';
            this.startWord = this.endWord;
            this.endWord = this.words.next();
            String string2 = this.sentence.substring(this.startWord, this.endWord).trim();
            if (string2.length() > 3 && string2.indexOf(46) > 0) {
                this.startWord = this.endWord;
                this.endWord = this.words.next();
                return true;
            }
            return false;
        }
        if (this.startWord + 3 < this.sentence.length() && this.sentence.charAt(this.startWord) == ':' && this.sentence.charAt(this.startWord + 1) == '/' && this.sentence.charAt(this.startWord + 2) == '/') {
            String string3;
            while (this.startWord < this.endWord && (string3 = this.sentence.substring(this.startWord, this.endWord).trim()).length() > 0) {
                string = string + string3;
                this.startWord = this.endWord;
                this.endWord = this.words.next();
            }
            return true;
        }
        return false;
    }

    boolean isFirstWordInSentence() {
        return this.isFirstWordInSentence;
    }

    private boolean nextParagraph() {
        if (this.doc instanceof AbstractDocument) {
            this.paragraphOffset = ((AbstractDocument)this.doc).getParagraphElement(this.paragraphOffset).getEndOffset();
            if (this.paragraphOffset >= this.endOffset) {
                return false;
            }
        } else {
            return false;
        }
        this.loadSentences();
        return true;
    }

    private void loadSentences() {
        this.setSentencesText();
        this.startSentence = this.sentences.first();
        this.endSentence = this.sentences.next();
        this.nextSentence();
    }

    private void setSentencesText() {
        int n = this.endOffset;
        if (this.doc instanceof AbstractDocument) {
            n = ((AbstractDocument)this.doc).getParagraphElement(this.paragraphOffset).getEndOffset();
        }
        try {
            this.phrase = this.doc.getText(this.paragraphOffset, n - this.paragraphOffset);
            this.phrase = Utils.replaceUnicodeQuotation(this.phrase);
        }
        catch (BadLocationException badLocationException) {
            SpellChecker.getMessageHandler().handleException(badLocationException);
        }
        this.sentences.setText(this.phrase);
    }

    private void nextSentence() {
        this.sentence = this.phrase.substring(this.startSentence, this.endSentence);
        this.words.setText(this.sentence);
        this.startWord = this.words.first();
        this.endWord = this.words.next();
        this.isFirstWordInSentence = true;
    }

    int getWordOffset() {
        return this.paragraphOffset + this.wordOffset;
    }

    void updatePhrase() {
        this.endOffset = this.doc.getLength();
        this.setSentencesText();
        this.endSentence = this.sentences.following(this.startSentence);
        this.sentence = this.phrase.substring(this.startSentence, this.endSentence);
        this.words.setText(this.sentence);
        this.startWord = this.words.following(this.wordOffset - this.startSentence);
        this.endWord = this.words.next();
    }
}

