/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.kotlin.com.google.common.base.Objects;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.CollectPreconditions;
import org.jetbrains.kotlin.com.google.common.collect.Collections2;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.Iterators;
import org.jetbrains.kotlin.com.google.common.primitives.Ints;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class Lists {
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @SafeVarargs
    @CanIgnoreReturnValue
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Preconditions.checkNotNull(elements);
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list2 = new ArrayList(capacity);
        Collections.addAll(list2, elements);
        return list2;
    }

    static int computeArrayListCapacity(int arraySize) {
        CollectPreconditions.checkNonnegative(arraySize, "arraySize");
        return Ints.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    @CanIgnoreReturnValue
    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        return elements instanceof Collection ? new ArrayList<E>(Collections2.cast(elements)) : Lists.newArrayList(elements.iterator());
    }

    @CanIgnoreReturnValue
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        ArrayList<E> list2 = Lists.newArrayList();
        Iterators.addAll(list2, elements);
        return list2;
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return new ArrayList(Lists.computeArrayListCapacity(estimatedSize));
    }

    public static <T> List<T> reverse(List<T> list2) {
        if (list2 instanceof ImmutableList) {
            return ((ImmutableList)list2).reverse();
        }
        if (list2 instanceof ReverseList) {
            return ((ReverseList)list2).getForwardList();
        }
        if (list2 instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list2);
        }
        return new ReverseList<T>(list2);
    }

    static boolean equalsImpl(List<?> thisList, Object other) {
        if (other == Preconditions.checkNotNull(thisList)) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        int size = thisList.size();
        if (size != otherList.size()) {
            return false;
        }
        if (thisList instanceof RandomAccess && otherList instanceof RandomAccess) {
            for (int i = 0; i < size; ++i) {
                if (Objects.equal(thisList.get(i), otherList.get(i))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(thisList.iterator(), otherList.iterator());
    }

    static int indexOfImpl(List<?> list2, Object element) {
        if (list2 instanceof RandomAccess) {
            return Lists.indexOfRandomAccess(list2, element);
        }
        ListIterator<?> listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(element, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    private static int indexOfRandomAccess(List<?> list2, Object element) {
        int size = list2.size();
        if (element == null) {
            for (int i = 0; i < size; ++i) {
                if (list2.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!element.equals(list2.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list2, Object element) {
        if (list2 instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess(list2, element);
        }
        ListIterator<?> listIterator = list2.listIterator(list2.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(element, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    private static int lastIndexOfRandomAccess(List<?> list2, Object element) {
        if (element == null) {
            for (int i = list2.size() - 1; i >= 0; --i) {
                if (list2.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = list2.size() - 1; i >= 0; --i) {
                if (!element.equals(list2.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> forwardList) {
            super(forwardList);
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> forwardList) {
            this.forwardList = Preconditions.checkNotNull(forwardList);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int index2) {
            int size = this.size();
            Preconditions.checkElementIndex(index2, size);
            return size - 1 - index2;
        }

        private int reversePosition(int index2) {
            int size = this.size();
            Preconditions.checkPositionIndex(index2, size);
            return size - index2;
        }

        @Override
        public void add(int index2, T element) {
            this.forwardList.add(this.reversePosition(index2), element);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int index2) {
            return this.forwardList.remove(this.reverseIndex(index2));
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.subList(fromIndex, toIndex).clear();
        }

        @Override
        public T set(int index2, T element) {
            return this.forwardList.set(this.reverseIndex(index2), element);
        }

        @Override
        public T get(int index2) {
            return this.forwardList.get(this.reverseIndex(index2));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index2) {
            int start = this.reversePosition(index2);
            final ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
            return new ListIterator<T>(){
                boolean canRemoveOrSet;

                @Override
                public void add(T e) {
                    forwardIterator.add(e);
                    forwardIterator.previous();
                    this.canRemoveOrSet = false;
                }

                @Override
                public boolean hasNext() {
                    return forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return this.reversePosition(forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    CollectPreconditions.checkRemove(this.canRemoveOrSet);
                    forwardIterator.remove();
                    this.canRemoveOrSet = false;
                }

                @Override
                public void set(T e) {
                    Preconditions.checkState(this.canRemoveOrSet);
                    forwardIterator.set(e);
                }
            };
        }
    }
}

