/*
 * Decompiled with CFR 0.152.
 */
package org.testng.asserts;

import java.util.Map;
import org.testng.asserts.Assertion;
import org.testng.asserts.IAssert;
import org.testng.collections.Maps;

public class SoftAssert
extends Assertion {
    private final Map<AssertionError, IAssert<?>> m_errors = Maps.newLinkedHashMap();

    @Override
    protected void doAssert(IAssert<?> iAssert) {
        this.onBeforeAssert(iAssert);
        try {
            iAssert.doAssert();
            this.onAssertSuccess(iAssert);
        }
        catch (AssertionError assertionError) {
            this.onAssertFailure(iAssert, assertionError);
            this.m_errors.put(assertionError, iAssert);
        }
        finally {
            this.onAfterAssert(iAssert);
        }
    }

    public void assertAll() {
        if (!this.m_errors.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("The following asserts failed:");
            boolean bl = true;
            for (Map.Entry<AssertionError, IAssert<?>> entry : this.m_errors.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append("\n\t");
                stringBuilder.append(((Throwable)((Object)entry.getKey())).getMessage());
            }
            throw new AssertionError((Object)stringBuilder.toString());
        }
    }
}

