/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.jvm;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen;
import org.jetbrains.kotlinx.serialization.compiler.backend.jvm.JVMCodegenUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.jvm.JVMSerialTypeInfo;
import org.jetbrains.kotlinx.serialization.compiler.backend.jvm.SerializerCodegenImpl;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\rH\u0014J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u001c\u0010\u0018\u001a\u00020\b*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0011\u0010\u001d\u001a\u00020\r*\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001eJ8\u0010\u001f\u001a\u00020\r*\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0%H\u0002J0\u0010&\u001a\u00020\r*\u00020!2\u0006\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0)H\u0002J\u0014\u0010-\u001a\u00020\r*\u00020\u00192\u0006\u0010.\u001a\u00020\u001bH\u0002J\u0014\u0010/\u001a\u00020\r*\u00020\u00192\u0006\u00100\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializerCodegenImpl;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializerCodegen;", "codegen", "Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;", "serializableClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "serialDescField", "", "serializableAsmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "serializerAsmType", "generateGenericFieldsAndConstructor", "", "typedConstructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "generateLoad", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "generateSave", "generateSerialDesc", "generateSerializableClassProperty", "property", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "buildExternalConstructorDesc", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "propsStartVar", "", "bitMaskBase", "genArrayOfTypeParametersSerializers", "genArrayOfTypeParametersSerializers$kotlinx_serialization_compiler_plugin", "genSetSerializableStandaloneProperties", "expressionCodegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "propVarStart", "resultVar", "bitMaskPos", "Lkotlin/Function1;", "generateSyntheticAnnotationOnStack", "annotationClass", "args", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "ctorParams", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "serialCLassDescToLocalVar", "classDescVar", "stackValueDefault", "type", "Companion", "kotlinx-serialization-compiler-plugin"})
public final class SerializerCodegenImpl
extends SerializerCodegen {
    private final String serialDescField = "$$serialDesc";
    private final Type serializerAsmType;
    private final Type serializableAsmType;
    private final ImplementationBodyCodegen codegen;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void generateGenericFieldsAndConstructor(@NotNull ConstructorDescriptor typedConstructorDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)typedConstructorDescriptor, (String)"typedConstructorDescriptor");
        List list = this.getSerializableDescriptor().getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"serializableDescriptor.declaredTypeParameters");
        Iterable $receiver$iv = list;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv;
            int i = n2;
            ClassBuilder classBuilder = this.codegen.v;
            KtPureClassOrObject ktPureClassOrObject = this.codegen.myClass;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktPureClassOrObject, (String)"codegen.myClass");
            JvmDeclarationOrigin jvmDeclarationOrigin = JvmDeclarationOriginKt.OtherOrigin$default((PsiElement)((PsiElement)ktPureClassOrObject.getPsiOrParent()), null, (int)2, null);
            String string = "typeSerial" + i;
            Type type = JVMCodegenUtilKt.getKSerializerType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"kSerializerType");
            classBuilder.newField(jvmDeclarationOrigin, 4098, string, type.getDescriptor(), null, null);
        }
        JVMCodegenUtilKt.generateMethod(this.codegen, (FunctionDescriptor)typedConstructorDescriptor, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)new Function3<InstructionAdapter, JvmMethodSignature, ExpressionCodegen, Unit>(this){
            final /* synthetic */ SerializerCodegenImpl this$0;

            public final void invoke(@NotNull InstructionAdapter $receiver, @NotNull JvmMethodSignature $noName_1, @NotNull ExpressionCodegen $noName_2) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 1>");
                $receiver.load(0, SerializerCodegenImpl.access$getSerializerAsmType$p(this.this$0));
                $receiver.invokespecial("java/lang/Object", "<init>", "()V", false);
                List list = SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0).getDeclaredTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"serializableDescriptor.declaredTypeParameters");
                Iterable $receiver$iv = list;
                int index$iv = 0;
                for (T item$iv : $receiver$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv;
                    int i = n2;
                    $receiver.load(0, SerializerCodegenImpl.access$getSerializerAsmType$p(this.this$0));
                    $receiver.load(i + 1, JVMCodegenUtilKt.getKSerializerType());
                    String string = SerializerCodegenImpl.access$getSerializerAsmType$p(this.this$0).getInternalName();
                    String string2 = "typeSerial" + i;
                    Type type = JVMCodegenUtilKt.getKSerializerType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"kSerializerType");
                    $receiver.putfield(string, string2, type.getDescriptor());
                }
                $receiver.areturn(Type.VOID_TYPE);
            }
            {
                this.this$0 = serializerCodegenImpl;
                super(3);
            }
        }));
    }

    @Override
    protected void generateSerialDesc() {
        InstructionAdapter instructionAdapter;
        ClassBuilder classBuilder = this.codegen.v;
        KtPureClassOrObject ktPureClassOrObject = this.codegen.myClass;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktPureClassOrObject, (String)"codegen.myClass");
        JvmDeclarationOrigin jvmDeclarationOrigin = JvmDeclarationOriginKt.OtherOrigin$default((PsiElement)((PsiElement)ktPureClassOrObject.getPsiOrParent()), null, (int)2, null);
        Type type = JVMCodegenUtilKt.getDescType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"descType");
        classBuilder.newField(jvmDeclarationOrigin, 4122, this.serialDescField, type.getDescriptor(), null, null);
        ExpressionCodegen expressionCodegen = this.codegen.createOrGetClInitCodegen();
        Intrinsics.checkExpressionValueIsNotNull((Object)expressionCodegen, (String)"codegen.createOrGetClInitCodegen()");
        ExpressionCodegen expr = expressionCodegen;
        InstructionAdapter $receiver = instructionAdapter = expr.v;
        int classDescVar = 0;
        $receiver.anew(JVMCodegenUtilKt.getDescImplType());
        $receiver.dup();
        $receiver.aconst((Object)this.getSerialName());
        Type type2 = JVMCodegenUtilKt.getDescImplType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"descImplType");
        $receiver.invokespecial(type2.getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
        $receiver.store(classDescVar, JVMCodegenUtilKt.getDescImplType());
        for (SerializableProperty triple : this.getOrderedProperties()) {
            if (triple.getTransient()) continue;
            $receiver.load(classDescVar, JVMCodegenUtilKt.getDescImplType());
            $receiver.aconst((Object)triple.getName());
            Type type3 = JVMCodegenUtilKt.getDescImplType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"descImplType");
            $receiver.invokevirtual(type3.getInternalName(), "addElement", "(Ljava/lang/String;)V", false);
            for (Triple<ClassDescriptor, List<ValueArgument>, List<ValueParameterDescriptor>> triple2 : triple.getAnnotationsWithArguments()) {
                ClassDescriptor annotationClass = (ClassDescriptor)triple2.component1();
                List args = (List)triple2.component2();
                List consParams = (List)triple2.component3();
                if (args.size() != consParams.size()) {
                    throw (Throwable)new IllegalArgumentException("Can't use arguments with defaults for serializable annotations yet");
                }
                $receiver.load(classDescVar, JVMCodegenUtilKt.getDescImplType());
                this.generateSyntheticAnnotationOnStack(expr, annotationClass, args, consParams);
                Type type4 = JVMCodegenUtilKt.getDescImplType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"descImplType");
                $receiver.invokevirtual(type4.getInternalName(), "pushAnnotation", "(Ljava/lang/annotation/Annotation;)V", false);
            }
        }
        for (Triple triple : KSerializationUtilKt.annotationsWithArguments((Annotated)this.getSerializableDescriptor())) {
            ClassDescriptor annotationClass = (ClassDescriptor)triple.component1();
            List args = (List)triple.component2();
            List consParams = (List)triple.component3();
            if (args.size() != consParams.size()) {
                throw (Throwable)new IllegalArgumentException("Can't use arguments with defaults for serializable annotations yet");
            }
            $receiver.load(classDescVar, JVMCodegenUtilKt.getDescImplType());
            this.generateSyntheticAnnotationOnStack(expr, annotationClass, args, consParams);
            Type type5 = JVMCodegenUtilKt.getDescImplType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"descImplType");
            $receiver.invokevirtual(type5.getInternalName(), "pushClassAnnotation", "(Ljava/lang/annotation/Annotation;)V", false);
        }
        $receiver.load(classDescVar, JVMCodegenUtilKt.getDescImplType());
        String string = this.serializerAsmType.getInternalName();
        Type type6 = JVMCodegenUtilKt.getDescType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"descType");
        $receiver.putstatic(string, this.serialDescField, type6.getDescriptor());
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSyntheticAnnotationOnStack(@NotNull ExpressionCodegen $receiver, ClassDescriptor annotationClass, List<? extends ValueArgument> args, List<? extends ValueParameterDescriptor> ctorParams) {
        InstructionAdapter instructionAdapter;
        StringBuilder stringBuilder = new StringBuilder();
        Type type = this.codegen.typeMapper.mapType((ClassifierDescriptor)annotationClass);
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"codegen.typeMapper.mapType(annotationClass)");
        String implType = stringBuilder.append(type.getInternalName()).append("$").append(SerialEntityNames.INSTANCE.getIMPL_NAME().getIdentifier()).toString();
        InstructionAdapter $receiver2 = instructionAdapter = $receiver.v;
        $receiver2.anew(Type.getObjectType((String)implType));
        $receiver2.dup();
        StringBuilder sb = new StringBuilder("(");
        int n = 0;
        int n2 = ((Collection)ctorParams).size();
        while (n < n2) {
            Type valAsmType;
            void i;
            ValueArgument decl = args.get((int)i);
            ValueParameterDescriptor desc = ctorParams.get((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)this.codegen.typeMapper.mapType(desc.getType()), (String)"codegen.typeMapper.mapType(desc.type)");
            $receiver.gen((KtElement)decl.getArgumentExpression(), valAsmType);
            sb.append(valAsmType.getDescriptor());
            ++i;
        }
        sb.append(")V");
        $receiver2.invokespecial(implType, "<init>", sb.toString(), false);
    }

    private final void serialCLassDescToLocalVar(@NotNull InstructionAdapter $receiver, int classDescVar) {
        String string = this.serializerAsmType.getInternalName();
        Type type = JVMCodegenUtilKt.getDescType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"descType");
        $receiver.getstatic(string, this.serialDescField, type.getDescriptor());
        $receiver.store(classDescVar, JVMCodegenUtilKt.getDescType());
    }

    @Override
    protected void generateSerializableClassProperty(@NotNull PropertyDescriptor property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        PropertyGetterDescriptor propertyGetterDescriptor = property.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"property.getter!!");
        JVMCodegenUtilKt.generateMethod(this.codegen, (FunctionDescriptor)propertyGetterDescriptor, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)new Function3<InstructionAdapter, JvmMethodSignature, ExpressionCodegen, Unit>(this){
            final /* synthetic */ SerializerCodegenImpl this$0;

            public final void invoke(@NotNull InstructionAdapter $receiver, @NotNull JvmMethodSignature $noName_1, @NotNull ExpressionCodegen $noName_2) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)$noName_2, (String)"<anonymous parameter 1>");
                String string = SerializerCodegenImpl.access$getSerializerAsmType$p(this.this$0).getInternalName();
                String string2 = SerializerCodegenImpl.access$getSerialDescField$p(this.this$0);
                Type type = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"descType");
                $receiver.getstatic(string, string2, type.getDescriptor());
                $receiver.areturn(JVMCodegenUtilKt.getDescType());
            }
            {
                this.this$0 = serializerCodegenImpl;
                super(3);
            }
        }));
    }

    @Override
    protected void generateSave(@NotNull FunctionDescriptor function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        JVMCodegenUtilKt.generateMethod(this.codegen, function2, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)new Function3<InstructionAdapter, JvmMethodSignature, ExpressionCodegen, Unit>(this){
            final /* synthetic */ SerializerCodegenImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull InstructionAdapter $receiver, @NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen expressionCodegen) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)signature, (String)"signature");
                Intrinsics.checkParameterIsNotNull((Object)expressionCodegen, (String)"expressionCodegen");
                int outputVar = 1;
                int objVar = 2;
                int descVar = 3;
                SerializerCodegenImpl.access$serialCLassDescToLocalVar(this.this$0, $receiver, descVar);
                E e = signature.getValueParameters().get(1);
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"signature.valueParameters[1]");
                Type type = ((JvmMethodParameterSignature)e).getAsmType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"signature.valueParameters[1].asmType");
                Type objType = type;
                $receiver.load(outputVar, JVMCodegenUtilKt.getEncoderType());
                $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                this.this$0.genArrayOfTypeParametersSerializers$kotlinx_serialization_compiler_plugin($receiver);
                Type type2 = JVMCodegenUtilKt.getEncoderType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"encoderType");
                String string = type2.getInternalName();
                StringBuilder stringBuilder = new StringBuilder().append("(");
                Type type3 = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"descType");
                StringBuilder stringBuilder2 = stringBuilder.append(type3.getDescriptor());
                Type type4 = JVMCodegenUtilKt.getKSerializerArrayType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"kSerializerArrayType");
                StringBuilder stringBuilder3 = stringBuilder2.append(type4.getDescriptor()).append(")");
                Type type5 = JVMCodegenUtilKt.getKOutputType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"kOutputType");
                $receiver.invokeinterface(string, "beginStructure", stringBuilder3.append(type5.getDescriptor()).toString());
                $receiver.store(outputVar, JVMCodegenUtilKt.getKOutputType());
                if (KSerializationUtilKt.isInternalSerializable(SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0))) {
                    StringBuilder stringBuilder4 = new StringBuilder().append('(');
                    Type type6 = JVMCodegenUtilKt.getKOutputType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"kOutputType");
                    StringBuilder stringBuilder5 = stringBuilder4.append(type6.getDescriptor());
                    Type type7 = JVMCodegenUtilKt.getDescType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"descType");
                    StringBuilder sig = new StringBuilder(stringBuilder5.append(type7.getDescriptor()).toString());
                    $receiver.load(objVar, objType);
                    $receiver.load(outputVar, JVMCodegenUtilKt.getKOutputType());
                    $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                    List list = SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0).getDeclaredTypeParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"serializableDescriptor.declaredTypeParameters");
                    Iterable $receiver$iv = list;
                    int index$iv = 0;
                    for (T item$iv : $receiver$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        int n2 = n;
                        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv;
                        int i = n2;
                        $receiver.load(0, JVMCodegenUtilKt.getKSerializerType());
                        Type type8 = SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).typeMapper.mapClass((ClassifierDescriptor)SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).descriptor);
                        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"codegen.typeMapper.mapClass(codegen.descriptor)");
                        String string2 = type8.getInternalName();
                        String string3 = "typeSerial" + i;
                        Type type9 = JVMCodegenUtilKt.getKSerializerType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"kSerializerType");
                        $receiver.getfield(string2, string3, type9.getDescriptor());
                        Type type10 = JVMCodegenUtilKt.getKSerializerType();
                        Intrinsics.checkExpressionValueIsNotNull((Object)type10, (String)"kSerializerType");
                        sig.append(type10.getDescriptor());
                    }
                    sig.append(")V");
                    $receiver.invokevirtual(objType.getInternalName(), SerialEntityNames.INSTANCE.getWRITE_SELF_NAME().asString(), sig.toString(), false);
                } else {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv22;
                    Iterable index$iv = $receiver$iv22 = (Iterable)SerializerCodegenImpl.access$getOrderedProperties$p(this.this$0);
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        SerializableProperty it = (SerializableProperty)element$iv$iv;
                        if (!(!it.getTransient())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List labeledProperties = (List)destination$iv$iv;
                    int $receiver$iv22 = 0;
                    int n = ((Collection)labeledProperties).size();
                    while ($receiver$iv22 < n) {
                        void index;
                        SerializableProperty property = (SerializableProperty)labeledProperties.get((int)index);
                        if (!property.getTransient()) {
                            $receiver.load(outputVar, JVMCodegenUtilKt.getKOutputType());
                            $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                            $receiver.iconst((int)index);
                            JVMCodegenUtilKt.genKOutputMethodCall$default($receiver, property, SerializerCodegenImpl.access$getCodegen$p(this.this$0), expressionCodegen, objType, objVar, null, 32, null);
                        }
                        ++index;
                    }
                }
                $receiver.load(outputVar, JVMCodegenUtilKt.getKOutputType());
                $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                Type type11 = JVMCodegenUtilKt.getKOutputType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type11, (String)"kOutputType");
                String string4 = type11.getInternalName();
                StringBuilder stringBuilder6 = new StringBuilder().append("(");
                Type type12 = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type12, (String)"descType");
                $receiver.invokeinterface(string4, "endStructure", stringBuilder6.append(type12.getDescriptor()).append(")V").toString());
                $receiver.areturn(Type.VOID_TYPE);
            }
            {
                this.this$0 = serializerCodegenImpl;
                super(3);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void genArrayOfTypeParametersSerializers$kotlinx_serialization_compiler_plugin(@NotNull InstructionAdapter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        int size = this.getSerializableDescriptor().getDeclaredTypeParameters().size();
        $receiver.iconst(size);
        $receiver.newarray(JVMCodegenUtilKt.getKSerializerType());
        int n = 0;
        int n2 = size;
        while (n < n2) {
            void i;
            $receiver.dup();
            $receiver.iconst((int)i);
            $receiver.load(0, JVMCodegenUtilKt.getKSerializerType());
            Type type = this.codegen.typeMapper.mapClass((ClassifierDescriptor)this.codegen.descriptor);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"codegen.typeMapper.mapClass(codegen.descriptor)");
            String string = type.getInternalName();
            String string2 = "typeSerial" + (int)i;
            Type type2 = JVMCodegenUtilKt.getKSerializerType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"kSerializerType");
            $receiver.getfield(string, string2, type2.getDescriptor());
            $receiver.astore(JVMCodegenUtilKt.getKSerializerType());
            ++i;
        }
    }

    @Override
    protected void generateLoad(@NotNull FunctionDescriptor function2) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        JVMCodegenUtilKt.generateMethod(this.codegen, function2, (Function3<? super InstructionAdapter, ? super JvmMethodSignature, ? super ExpressionCodegen, Unit>)((Function3)new Function3<InstructionAdapter, JvmMethodSignature, ExpressionCodegen, Unit>(this){
            final /* synthetic */ SerializerCodegenImpl this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull InstructionAdapter $receiver, @NotNull JvmMethodSignature $noName_1, @NotNull ExpressionCodegen expressionCodegen) {
                Object throwLabel;
                Object produceCall$;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull((Object)expressionCodegen, (String)"expressionCodegen");
                int inputVar = 1;
                int descVar = 2;
                int indexVar = 3;
                int readAllVar = 4;
                int bitMaskBase = 5;
                int blocksCnt = SerializerCodegenImpl.access$getOrderedProperties$p(this.this$0).size() / JVMCodegenUtilKt.getOPT_MASK_BITS() + 1;
                Function1<Integer, Integer> bitMaskOff$ = new Function1<Integer, Integer>(bitMaskBase){
                    final /* synthetic */ int $bitMaskBase;

                    public final int invoke(int i) {
                        return this.$bitMaskBase + i / JVMCodegenUtilKt.getOPT_MASK_BITS() * JVMCodegenUtilKt.getOPT_MASK_TYPE().getSize();
                    }
                    {
                        this.$bitMaskBase = n;
                        super(1);
                    }
                };
                int propsStartVar = bitMaskBase + JVMCodegenUtilKt.getOPT_MASK_TYPE().getSize() * blocksCnt;
                SerializerCodegenImpl.access$serialCLassDescToLocalVar(this.this$0, $receiver, descVar);
                $receiver.iconst(0);
                $receiver.store(readAllVar, Type.BOOLEAN_TYPE);
                int n = 0;
                int n2 = blocksCnt;
                while (n < n2) {
                    void i;
                    $receiver.iconst(0);
                    $receiver.store(bitMaskBase + i * JVMCodegenUtilKt.getOPT_MASK_TYPE().getSize(), JVMCodegenUtilKt.getOPT_MASK_TYPE());
                    ++i;
                }
                int propVar = propsStartVar;
                for (SerializableProperty property : SerializerCodegenImpl.access$getOrderedProperties$p(this.this$0)) {
                    Type propertyType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).typeMapper.mapType(property.getType()), (String)"codegen.typeMapper.mapType(property.type)");
                    SerializerCodegenImpl.access$stackValueDefault(this.this$0, $receiver, propertyType);
                    $receiver.store(propVar, propertyType);
                    propVar += propertyType.getSize();
                }
                $receiver.load(inputVar, JVMCodegenUtilKt.getDecoderType());
                $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                this.this$0.genArrayOfTypeParametersSerializers$kotlinx_serialization_compiler_plugin($receiver);
                Type type = JVMCodegenUtilKt.getDecoderType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"decoderType");
                String string = type.getInternalName();
                StringBuilder stringBuilder = new StringBuilder().append("(");
                Type type2 = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"descType");
                StringBuilder stringBuilder2 = stringBuilder.append(type2.getDescriptor());
                Type type3 = JVMCodegenUtilKt.getKSerializerArrayType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"kSerializerArrayType");
                StringBuilder stringBuilder3 = stringBuilder2.append(type3.getDescriptor()).append(")");
                Type type4 = JVMCodegenUtilKt.getKInputType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"kInputType");
                $receiver.invokeinterface(string, "beginStructure", stringBuilder3.append(type4.getDescriptor()).toString());
                $receiver.store(inputVar, JVMCodegenUtilKt.getKInputType());
                Label readElementLabel = new Label();
                $receiver.visitLabel(readElementLabel);
                $receiver.load(inputVar, JVMCodegenUtilKt.getKInputType());
                $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                Type type5 = JVMCodegenUtilKt.getKInputType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"kInputType");
                String string2 = type5.getInternalName();
                StringBuilder stringBuilder4 = new StringBuilder().append("(");
                Type type6 = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"descType");
                $receiver.invokeinterface(string2, "decodeElementIndex", stringBuilder4.append(type6.getDescriptor()).append(")I").toString());
                $receiver.store(indexVar, Type.INT_TYPE);
                Iterable iterable = $receiver$iv = (Iterable)SerializerCodegenImpl.access$getOrderedProperties$p(this.this$0);
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    SerializableProperty it = (SerializableProperty)element$iv$iv;
                    if (!(!it.getTransient())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List labeledProperties = (List)destination$iv$iv;
                Label readAllLabel = new Label();
                Label readEndLabel = new Label();
                Label incorrectIndLabel = new Label();
                Label[] labels = new Label[labeledProperties.size() + 2];
                labels[0] = readAllLabel;
                labels[1] = readEndLabel;
                int element$iv$iv = 0;
                int it = ((Collection)labeledProperties).size();
                while (element$iv$iv < it) {
                    void i;
                    labels[i + 2] = new Label();
                    ++i;
                }
                $receiver.load(indexVar, Type.INT_TYPE);
                $receiver.tableswitch(-2, labeledProperties.size() - 1, incorrectIndLabel, Arrays.copyOf(labels, labels.length));
                $receiver.visitLabel(readAllLabel);
                $receiver.iconst(1);
                $receiver.store(readAllVar, Type.BOOLEAN_TYPE);
                propVar = propsStartVar;
                int labelNum = 0;
                it = 0;
                for (SerializableProperty property : (Iterable)SerializerCodegenImpl.access$getOrderedProperties$p(this.this$0)) {
                    void index;
                    Type propertyType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).typeMapper.mapType(property.getType()), (String)"codegen.typeMapper.mapType(property.type)");
                    if (!property.getTransient()) {
                        boolean unknownSer;
                        CharSequence charSequence;
                        $receiver.visitLabel(labels[labelNum + 2]);
                        $receiver.load(inputVar, JVMCodegenUtilKt.getKInputType());
                        $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                        $receiver.iconst(labelNum);
                        JVMSerialTypeInfo sti = JVMCodegenUtilKt.getSerialTypeInfo(property, propertyType);
                        boolean useSerializer = JVMCodegenUtilKt.stackValueSerializerInstanceFromSerializer($receiver, (ClassBodyCodegen)SerializerCodegenImpl.access$getCodegen$p(this.this$0), sti);
                        boolean bl = !useSerializer && (charSequence = (CharSequence)sti.getElementMethodPrefix()).length() == 0 ? true : (unknownSer = false);
                        if (unknownSer) {
                            $receiver.aconst((Object)SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).typeMapper.mapType(property.getType()));
                            AsmUtil.wrapJavaClassIntoKClass((InstructionAdapter)$receiver);
                        }
                        produceCall$ = new Function1<Boolean, Unit>($receiver, sti, useSerializer, unknownSer){
                            final /* synthetic */ InstructionAdapter $this_generateMethod;
                            final /* synthetic */ JVMSerialTypeInfo $sti;
                            final /* synthetic */ boolean $useSerializer;
                            final /* synthetic */ boolean $unknownSer;

                            public final void invoke(boolean update) {
                                String string;
                                String string2;
                                Type type = JVMCodegenUtilKt.getKInputType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"kInputType");
                                String string3 = type.getInternalName();
                                String string4 = (update ? "update" : "decode") + this.$sti.getElementMethodPrefix() + (this.$useSerializer ? "Serializable" : "") + "Element";
                                StringBuilder stringBuilder = new StringBuilder().append("(");
                                Type type2 = JVMCodegenUtilKt.getDescType();
                                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"descType");
                                StringBuilder stringBuilder2 = stringBuilder.append(type2.getDescriptor()).append("I");
                                if (this.$useSerializer) {
                                    Type type3 = JVMCodegenUtilKt.getKSerialLoaderType();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"kSerialLoaderType");
                                    string2 = type3.getDescriptor();
                                } else {
                                    string2 = "";
                                }
                                StringBuilder stringBuilder3 = stringBuilder2.append(string2);
                                if (this.$unknownSer) {
                                    Type type4 = AsmTypes.K_CLASS_TYPE;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"AsmTypes.K_CLASS_TYPE");
                                    string = type4.getDescriptor();
                                } else {
                                    string = "";
                                }
                                this.$this_generateMethod.invokeinterface(string3, string4, stringBuilder3.append(string).append(update ? this.$sti.getType().getDescriptor() : "").append(")").append(this.$sti.getUnit() ? "V" : this.$sti.getType().getDescriptor()).toString());
                            }
                            {
                                this.$this_generateMethod = instructionAdapter;
                                this.$sti = jVMSerialTypeInfo;
                                this.$useSerializer = bl;
                                this.$unknownSer = bl2;
                                super(1);
                            }
                        };
                        if (useSerializer) {
                            Label readLabel = new Label();
                            Label endL = new Label();
                            JVMCodegenUtilKt.genValidateProperty($receiver, (int)index, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(bitMaskOff$){
                                final /* synthetic */ generateLoad.1 $bitMaskOff$1;

                                public final int invoke(int p1) {
                                    return this.$bitMaskOff$1.invoke(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return null;
                                }

                                public final String getName() {
                                    return "bitMaskOff";
                                }

                                public final String getSignature() {
                                    return "invoke(I)I";
                                }
                                {
                                    this.$bitMaskOff$1 = var1_1;
                                    super(1);
                                }
                            }));
                            $receiver.ificmpeq(readLabel);
                            $receiver.load(propVar, propertyType);
                            produceCall$.invoke(true);
                            $receiver.goTo(endL);
                            $receiver.visitLabel(readLabel);
                            produceCall$.invoke(false);
                            $receiver.visitLabel(endL);
                        } else {
                            produceCall$.invoke(false);
                        }
                        if (sti.getUnit()) {
                            StackValue.putUnitInstance((InstructionAdapter)$receiver);
                        } else {
                            StackValue.coerce((Type)sti.getType(), (Type)propertyType, (InstructionAdapter)$receiver);
                        }
                        $receiver.store(propVar, propertyType);
                        int addr = bitMaskOff$.invoke((int)index);
                        $receiver.load(addr, JVMCodegenUtilKt.getOPT_MASK_TYPE());
                        $receiver.iconst(1 << index % JVMCodegenUtilKt.getOPT_MASK_BITS());
                        $receiver.or(JVMCodegenUtilKt.getOPT_MASK_TYPE());
                        $receiver.store(addr, JVMCodegenUtilKt.getOPT_MASK_TYPE());
                        $receiver.load(readAllVar, Type.BOOLEAN_TYPE);
                        $receiver.iconst(0);
                        $receiver.ificmpeq(readElementLabel);
                        ++labelNum;
                    }
                    propVar += propertyType.getSize();
                    ++index;
                }
                int resultVar = propVar;
                $receiver.visitLabel(readEndLabel);
                $receiver.load(inputVar, JVMCodegenUtilKt.getKInputType());
                $receiver.load(descVar, JVMCodegenUtilKt.getDescType());
                Type type7 = JVMCodegenUtilKt.getKInputType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"kInputType");
                String string3 = type7.getInternalName();
                StringBuilder stringBuilder5 = new StringBuilder().append("(");
                Type type8 = JVMCodegenUtilKt.getDescType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"descType");
                $receiver.invokeinterface(string3, "endStructure", stringBuilder5.append(type8.getDescriptor()).append(")V").toString());
                if (!KSerializationUtilKt.isInternalSerializable(SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0))) {
                    Label nonThrowLabel = new Label();
                    throwLabel = new Label();
                    boolean propertyType = false;
                    for (SerializableProperty property : (Iterable)SerializerCodegenImpl.access$getProperties$p(this.this$0).getSerializableConstructorProperties()) {
                        void i;
                        if (property.getOptional() || property.getTransient()) {
                            if (!property.isConstructorParameterWithDefault()) {
                                throw (Throwable)new CompilationException("Property " + property.getName() + " was declared as optional/transient but has no default value", null, null);
                            }
                        } else {
                            JVMCodegenUtilKt.genValidateProperty($receiver, (int)i, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(bitMaskOff$){
                                final /* synthetic */ generateLoad.1 $bitMaskOff$1;

                                public final int invoke(int p1) {
                                    return this.$bitMaskOff$1.invoke(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return null;
                                }

                                public final String getName() {
                                    return "bitMaskOff";
                                }

                                public final String getSignature() {
                                    return "invoke(I)I";
                                }
                                {
                                    this.$bitMaskOff$1 = var1_1;
                                    super(1);
                                }
                            }));
                            $receiver.ificmpeq(throwLabel);
                        }
                        ++i;
                    }
                    $receiver.goTo(nonThrowLabel);
                    $receiver.visitLabel(throwLabel);
                    JVMCodegenUtilKt.genExceptionThrow($receiver, JVMCodegenUtilKt.getSerializationExceptionName(), "Not all required constructor fields were specified");
                    $receiver.visitLabel(nonThrowLabel);
                }
                $receiver.anew(SerializerCodegenImpl.access$getSerializableAsmType$p(this.this$0));
                $receiver.dup();
                String constructorDesc = KSerializationUtilKt.isInternalSerializable(SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0)) ? JVMCodegenUtilKt.buildInternalConstructorDesc($receiver, propsStartVar, bitMaskBase, (ClassBodyCodegen)SerializerCodegenImpl.access$getCodegen$p(this.this$0), SerializerCodegenImpl.access$getProperties$p(this.this$0).getSerializableProperties()) : SerializerCodegenImpl.access$buildExternalConstructorDesc(this.this$0, $receiver, propsStartVar, bitMaskBase);
                $receiver.invokespecial(SerializerCodegenImpl.access$getSerializableAsmType$p(this.this$0).getInternalName(), "<init>", constructorDesc, false);
                if (!KSerializationUtilKt.isInternalSerializable(SerializerCodegenImpl.access$getSerializableDescriptor$p(this.this$0)) && !SerializerCodegenImpl.access$getProperties$p(this.this$0).getSerializableStandaloneProperties().isEmpty()) {
                    Collection<Integer> collection;
                    void $receiver$iv$iv2;
                    void $receiver$iv2;
                    $receiver.store(resultVar, SerializerCodegenImpl.access$getSerializableAsmType$p(this.this$0));
                    throwLabel = SerializerCodegenImpl.access$getProperties$p(this.this$0).getSerializableConstructorProperties();
                    int n3 = propsStartVar;
                    void i = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv2) {
                        void it2;
                        produceCall$ = (SerializableProperty)item$iv$iv;
                        collection = destination$iv$iv2;
                        Type type9 = SerializerCodegenImpl.access$getCodegen$p((SerializerCodegenImpl)this.this$0).typeMapper.mapType(it2.getType());
                        Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"codegen.typeMapper.mapType(it.type)");
                        Integer n4 = type9.getSize();
                        collection.add(n4);
                    }
                    collection = (List)destination$iv$iv2;
                    propVar = n3 + CollectionsKt.sumOfInt((Iterable)collection);
                    SerializerCodegenImpl.access$genSetSerializableStandaloneProperties(this.this$0, $receiver, expressionCodegen, propVar, resultVar, (Function1)new Function1<Integer, Integer>(bitMaskOff$){
                        final /* synthetic */ generateLoad.1 $bitMaskOff$1;

                        public final int invoke(int p1) {
                            return this.$bitMaskOff$1.invoke(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return null;
                        }

                        public final String getName() {
                            return "bitMaskOff";
                        }

                        public final String getSignature() {
                            return "invoke(I)I";
                        }
                        {
                            this.$bitMaskOff$1 = var1_1;
                            super(1);
                        }
                    });
                    $receiver.load(resultVar, SerializerCodegenImpl.access$getSerializableAsmType$p(this.this$0));
                }
                $receiver.areturn(SerializerCodegenImpl.access$getSerializableAsmType$p(this.this$0));
                $receiver.visitLabel(incorrectIndLabel);
                $receiver.anew(Type.getObjectType((String)JVMCodegenUtilKt.getSerializationExceptionUnknownIndexName()));
                $receiver.dup();
                $receiver.load(indexVar, Type.INT_TYPE);
                $receiver.invokespecial(JVMCodegenUtilKt.getSerializationExceptionUnknownIndexName(), "<init>", "(I)V", false);
                $receiver.checkcast(Type.getObjectType((String)"java/lang/Throwable"));
                $receiver.athrow();
            }
            {
                this.this$0 = serializerCodegenImpl;
                super(3);
            }
        }));
    }

    private final String buildExternalConstructorDesc(@NotNull InstructionAdapter $receiver, int propsStartVar, int bitMaskBase) {
        StringBuilder constructorDesc = new StringBuilder("(");
        int propVar = propsStartVar;
        for (SerializableProperty property : this.getProperties().getSerializableConstructorProperties()) {
            Type propertyType;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.codegen.typeMapper.mapType(property.getType()), (String)"codegen.typeMapper.mapType(property.type)");
            constructorDesc.append(propertyType.getDescriptor());
            $receiver.load(propVar, propertyType);
            propVar += propertyType.getSize();
        }
        if (!this.getProperties().getPrimaryConstructorWithDefaults()) {
            constructorDesc.append(")V");
        } else {
            int cnt = RangesKt.coerceAtMost((int)this.getProperties().getSerializableConstructorProperties().size(), (int)32);
            int mask = cnt == 32 ? -1 : (1 << cnt) - 1;
            $receiver.load(bitMaskBase, JVMCodegenUtilKt.getOPT_MASK_TYPE());
            $receiver.iconst(mask);
            $receiver.xor(Type.INT_TYPE);
            $receiver.aconst(null);
            constructorDesc.append("ILkotlin/jvm/internal/DefaultConstructorMarker;)V");
        }
        String string = constructorDesc.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"constructorDesc.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void genSetSerializableStandaloneProperties(@NotNull InstructionAdapter $receiver, ExpressionCodegen expressionCodegen, int propVarStart, int resultVar, Function1<? super Integer, Integer> bitMaskPos) {
        int propVar = propVarStart;
        int offset = this.getProperties().getSerializableConstructorProperties().size();
        boolean bl = false;
        for (SerializableProperty property : (Iterable)this.getProperties().getSerializableStandaloneProperties()) {
            Type propertyType;
            void index;
            void i = index + offset;
            Label nextLabel = new Label();
            JVMCodegenUtilKt.genValidateProperty($receiver, (int)i, bitMaskPos);
            if (property.getOptional()) {
                $receiver.ificmpeq(nextLabel);
            } else {
                $receiver.ificmpne(nextLabel);
                JVMCodegenUtilKt.genExceptionThrow($receiver, JVMCodegenUtilKt.getSerializationExceptionMissingFieldName(), property.getName());
                $receiver.visitLabel(nextLabel);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)this.codegen.typeMapper.mapType(property.getType()), (String)"codegen.typeMapper.mapType(property.type)");
            expressionCodegen.intermediateValueForProperty(property.getDescriptor(), false, null, (StackValue)StackValue.local((int)resultVar, (Type)this.serializableAsmType)).store((StackValue)StackValue.local((int)propVar, (Type)propertyType), $receiver);
            propVar += propertyType.getSize();
            if (property.getOptional()) {
                $receiver.visitLabel(nextLabel);
            }
            ++index;
        }
    }

    private final void stackValueDefault(@NotNull InstructionAdapter $receiver, Type type) {
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                $receiver.iconst(0);
                break;
            }
            case 7: {
                $receiver.lconst(0L);
                break;
            }
            case 6: {
                $receiver.fconst(0.0f);
                break;
            }
            case 8: {
                $receiver.dconst(0.0);
                break;
            }
            default: {
                $receiver.aconst(null);
            }
        }
    }

    public SerializerCodegenImpl(@NotNull ImplementationBodyCodegen codegen, @NotNull ClassDescriptor serializableClass) {
        Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
        Intrinsics.checkParameterIsNotNull((Object)serializableClass, (String)"serializableClass");
        ClassDescriptor classDescriptor = codegen.descriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"codegen.descriptor");
        BindingContext bindingContext = codegen.bindingContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"codegen.bindingContext");
        super(classDescriptor, bindingContext);
        this.codegen = codegen;
        this.serialDescField = "$$serialDesc";
        Type type = this.codegen.typeMapper.mapClass((ClassifierDescriptor)this.codegen.descriptor);
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"codegen.typeMapper.mapClass(codegen.descriptor)");
        this.serializerAsmType = type;
        Type type2 = this.codegen.typeMapper.mapClass((ClassifierDescriptor)serializableClass);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"codegen.typeMapper.mapClass(serializableClass)");
        this.serializableAsmType = type2;
    }

    @NotNull
    public static final /* synthetic */ Type access$getSerializerAsmType$p(SerializerCodegenImpl $this) {
        return $this.serializerAsmType;
    }

    @NotNull
    public static final /* synthetic */ ClassDescriptor access$getSerializableDescriptor$p(SerializerCodegenImpl $this) {
        return $this.getSerializableDescriptor();
    }

    @NotNull
    public static final /* synthetic */ String access$getSerialDescField$p(SerializerCodegenImpl $this) {
        return $this.serialDescField;
    }

    public static final /* synthetic */ void access$serialCLassDescToLocalVar(SerializerCodegenImpl $this, @NotNull InstructionAdapter $receiver, int classDescVar) {
        $this.serialCLassDescToLocalVar($receiver, classDescVar);
    }

    @NotNull
    public static final /* synthetic */ ImplementationBodyCodegen access$getCodegen$p(SerializerCodegenImpl $this) {
        return $this.codegen;
    }

    @NotNull
    public static final /* synthetic */ List access$getOrderedProperties$p(SerializerCodegenImpl $this) {
        return $this.getOrderedProperties();
    }

    public static final /* synthetic */ void access$stackValueDefault(SerializerCodegenImpl $this, @NotNull InstructionAdapter $receiver, @NotNull Type type) {
        $this.stackValueDefault($receiver, type);
    }

    @NotNull
    public static final /* synthetic */ SerializableProperties access$getProperties$p(SerializerCodegenImpl $this) {
        return $this.getProperties();
    }

    @NotNull
    public static final /* synthetic */ Type access$getSerializableAsmType$p(SerializerCodegenImpl $this) {
        return $this.serializableAsmType;
    }

    @NotNull
    public static final /* synthetic */ String access$buildExternalConstructorDesc(SerializerCodegenImpl $this, @NotNull InstructionAdapter $receiver, int propsStartVar, int bitMaskBase) {
        return $this.buildExternalConstructorDesc($receiver, propsStartVar, bitMaskBase);
    }

    public static final /* synthetic */ void access$genSetSerializableStandaloneProperties(SerializerCodegenImpl $this, @NotNull InstructionAdapter $receiver, @NotNull ExpressionCodegen expressionCodegen, int propVarStart, int resultVar, @NotNull Function1 bitMaskPos) {
        $this.genSetSerializableStandaloneProperties($receiver, expressionCodegen, propVarStart, resultVar, (Function1<? super Integer, Integer>)bitMaskPos);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/jvm/SerializerCodegenImpl$Companion;", "", "()V", "generateSerializerExtensions", "", "codegen", "Lorg/jetbrains/kotlin/codegen/ImplementationBodyCodegen;", "kotlinx-serialization-compiler-plugin"})
    public static final class Companion {
        public final void generateSerializerExtensions(@NotNull ImplementationBodyCodegen codegen) {
            Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
            ClassDescriptor classDescriptor = codegen.descriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"codegen.descriptor");
            ClassDescriptor classDescriptor2 = KSerializationUtilKt.getSerializableClassDescriptorBySerializer(classDescriptor);
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor serializableClass = classDescriptor2;
            new SerializerCodegenImpl(codegen, serializableClass).generate();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

