/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.FileASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.BooleanRunnable;
import com.intellij.psi.impl.ChangedPsiRangeUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentCommitThread
implements Disposable,
DocumentCommitProcessor,
Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.DocumentCommitThread");
    private final ExecutorService executor;
    private final Object lock;
    private final HashSetQueue<CommitTask> documentsToCommit;
    private final HashSetQueue<CommitTask> documentsToApplyInEDT;
    private final ApplicationEx myApplication;
    private volatile boolean isDisposed;
    private CommitTask currentTask;
    private boolean myEnabled;
    private static final Key<Object> CANCEL_REASON = Key.create("CANCEL_REASON");
    private static final Key<Lock> DOCUMENT_LOCK = Key.create("DOCUMENT_LOCK");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.isDisposed = true;
        Object object = this.lock;
        synchronized (object) {
            this.documentsToCommit.clear();
        }
        this.cancel("Stop thread", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(0);
        }
        Object object = this.lock;
        synchronized (object) {
            this.cancel(reason, true);
            this.myEnabled = false;
        }
        this.log(null, "disabled", null, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(@NonNls @NotNull Object reason) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(1);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myEnabled = true;
            this.wakeUpQueue();
        }
        this.log(null, "enabled", null, reason);
    }

    private void wakeUpQueue() {
        if (!this.isDisposed && !this.documentsToCommit.isEmpty()) {
            this.executor.execute(this);
        }
    }

    private void cancel(@NonNls @NotNull Object reason, boolean canReQueue) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(2);
        }
        this.startNewTask(null, reason, canReQueue);
    }

    @Override
    public void commitAsynchronously(@NotNull Project project, @NotNull Document document, @NonNls @NotNull Object reason, @Nullable TransactionId context) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(3);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(4);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(5);
        }
        assert (!this.isDisposed) : "already disposed";
        if (!project.isInitialized()) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        PsiFile psiFile = documentManager.getCachedPsiFile(document);
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            return;
        }
        this.doQueue(project, document, DocumentCommitThread.getAllFileNodes(psiFile), reason, context, documentManager.getLastCommittedText(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @Nullable TransactionId context, @NotNull CharSequence lastCommittedText) {
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(6);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(7);
        }
        if (oldFileNodes == null) {
            DocumentCommitThread.$$$reportNull$$$0(8);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(9);
        }
        if (lastCommittedText == null) {
            DocumentCommitThread.$$$reportNull$$$0(10);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!project.isInitialized()) {
                return;
            }
            CommitTask newTask = this.createNewTaskAndCancelSimilar(project, document, oldFileNodes, reason, context, lastCommittedText, false);
            this.documentsToCommit.offer(newTask);
            this.log(project, "Queued", newTask, reason);
            this.wakeUpQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CommitTask createNewTaskAndCancelSimilar(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull Object reason, @Nullable TransactionId context, @NotNull CharSequence lastCommittedText, boolean canReQueue) {
        Pair<PsiFileImpl, FileASTNode> pair;
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(11);
        }
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(12);
        }
        if (oldFileNodes == null) {
            DocumentCommitThread.$$$reportNull$$$0(13);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(14);
        }
        if (lastCommittedText == null) {
            DocumentCommitThread.$$$reportNull$$$0(15);
        }
        Object object = this.lock;
        // MONITORENTER : object
        Iterator<Pair<PsiFileImpl, FileASTNode>> iterator2 = oldFileNodes.iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                CommitTask newTask = new CommitTask(project, document, oldFileNodes, DocumentCommitThread.createProgressIndicator(), reason, context, lastCommittedText);
                this.cancelAndRemoveFromDocsToCommit(newTask, reason, canReQueue);
                this.cancelAndRemoveCurrentTask(newTask, reason, canReQueue);
                this.cancelAndRemoveFromDocsToApplyInEDT(newTask, reason, canReQueue);
                CommitTask commitTask = newTask;
                // MONITOREXIT : object
                if (commitTask != null) return commitTask;
                DocumentCommitThread.$$$reportNull$$$0(16);
                return commitTask;
            }
            pair = iterator2.next();
            assert (((PsiFileImpl)pair.first).getProject() == project);
        }
    }

    private void log(Project project, @NonNls String msg, @Nullable CommitTask task, Object ... args) {
    }

    private void cancelAndRemoveCurrentTask(@NotNull CommitTask newTask, @NotNull Object reason, boolean canReQueue) {
        CommitTask currentTask;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(17);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(18);
        }
        if (newTask.equals(currentTask = this.currentTask)) {
            this.cancelAndRemoveFromDocsToCommit(currentTask, reason, canReQueue);
            this.cancel(reason, canReQueue);
        }
    }

    private void cancelAndRemoveFromDocsToApplyInEDT(@NotNull CommitTask newTask, @NotNull Object reason, boolean canReQueue) {
        boolean removed2;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(19);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(20);
        }
        if (removed2 = this.cancelAndRemoveFromQueue(newTask, this.documentsToApplyInEDT, reason, canReQueue)) {
            this.log(newTask.project, "Removed from EDT apply queue", newTask, new Object[0]);
        }
    }

    private void cancelAndRemoveFromDocsToCommit(@NotNull CommitTask newTask, @NotNull Object reason, boolean canReQueue) {
        boolean removed2;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(21);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(22);
        }
        if (removed2 = this.cancelAndRemoveFromQueue(newTask, this.documentsToCommit, reason, canReQueue)) {
            this.log(newTask.project, "Removed from background queue", newTask, new Object[0]);
        }
    }

    private boolean cancelAndRemoveFromQueue(@NotNull CommitTask newTask, @NotNull HashSetQueue<CommitTask> queue, @NotNull Object reason, boolean canReQueue) {
        CommitTask queuedTask;
        if (newTask == null) {
            DocumentCommitThread.$$$reportNull$$$0(23);
        }
        if (queue == null) {
            DocumentCommitThread.$$$reportNull$$$0(24);
        }
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(25);
        }
        if ((queuedTask = queue.find(newTask)) != null) {
            assert (queuedTask != newTask);
            queuedTask.cancel(reason, canReQueue);
        }
        return queue.remove(newTask);
    }

    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                if (this.pollQueue()) continue;
                break;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollQueue() {
        Project project;
        CommitTask task;
        assert (!this.myApplication.isDispatchThread()) : Thread.currentThread();
        Object object = this.lock;
        synchronized (object) {
            if (!this.myEnabled || (task = this.documentsToCommit.poll()) == null) {
                return false;
            }
            Document document = task.getDocument();
            project = task.project;
            if (project.isDisposed() || !((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project)).isInUncommittedSet(document)) {
                this.log(project, "Abandon and proceed to next", task, new Object[0]);
                return true;
            }
            if (task.isCanceled() || task.dead) {
                return true;
            }
            this.startNewTask(task, "Pulled new task", true);
            this.documentsToApplyInEDT.add(task);
        }
        boolean success = false;
        Object failureReason = null;
        try {
            if (!task.isCanceled()) {
                CommitTask commitTask = task;
                Ref result2 = new Ref();
                ProgressManager.getInstance().executeProcessUnderProgress(() -> result2.set(this.commitUnderProgress(commitTask, false)), task.indicator);
                Runnable finishRunnable = (Runnable)((Pair)result2.get()).first;
                success = finishRunnable != null;
                failureReason = ((Pair)result2.get()).second;
                if (success) {
                    assert (!this.myApplication.isDispatchThread());
                    TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                    guard.submitTransaction(task.project, task.myCreationContext, finishRunnable);
                }
            }
        }
        catch (ProcessCanceledException e) {
            this.cancel(e + " (indicator cancel reason: " + ((UserDataHolder)((Object)task.indicator)).getUserData(CANCEL_REASON) + ")", true);
            success = false;
            failureReason = e;
        }
        catch (Throwable e) {
            LOG.error(e);
            this.cancel(e, false);
            failureReason = ExceptionUtil.getThrowableText(e);
        }
        if (!success) {
            project = task.project;
            Document document = task.document;
            String reQueuedReason = "re-added on failure: " + failureReason;
            ReadAction.run(() -> {
                List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes;
                if (project.isDisposed()) {
                    return;
                }
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
                if (documentManager.isCommitted(document)) {
                    return;
                }
                CharSequence lastCommittedText = documentManager.getLastCommittedText(document);
                PsiFile file2 = documentManager.getPsiFile(document);
                List<Pair<PsiFileImpl, FileASTNode>> list2 = oldFileNodes = file2 == null ? null : DocumentCommitThread.getAllFileNodes(file2);
                if (oldFileNodes != null) {
                    if (task.dead) {
                        return;
                    }
                    this.doQueue(project, document, oldFileNodes, reQueuedReason, task.myCreationContext, lastCommittedText);
                }
            });
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.currentTask = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile) {
        CommitTask task;
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(26);
        }
        if (project == null) {
            DocumentCommitThread.$$$reportNull$$$0(27);
        }
        if (psiFile == null) {
            DocumentCommitThread.$$$reportNull$$$0(28);
        }
        assert (!this.isDisposed);
        if (!project.isInitialized() && !project.isDefault()) {
            String s = project + "; Disposed: " + project.isDisposed() + "; Open: " + project.isOpen();
            try {
                Disposer.dispose(project);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new RuntimeException(s);
        }
        List<Pair<PsiFileImpl, FileASTNode>> allFileNodes = DocumentCommitThread.getAllFileNodes(psiFile);
        Lock documentLock = DocumentCommitThread.getDocumentLock(document);
        Object object = this.lock;
        synchronized (object) {
            task = this.createNewTaskAndCancelSimilar(project, document, allFileNodes, "Sync commit", TransactionGuard.getInstance().getContextTransaction(), PsiDocumentManager.getInstance(project).getLastCommittedText(document), true);
        }
        documentLock.lock();
        try {
            assert (!task.isCanceled());
            Pair<Runnable, Object> result2 = this.commitUnderProgress(task, true);
            Runnable finish = (Runnable)result2.first;
            this.log(project, "Committed sync", task, finish, task.indicator);
            assert (finish != null);
            finish.run();
        }
        finally {
            documentLock.unlock();
        }
    }

    @NotNull
    private static List<Pair<PsiFileImpl, FileASTNode>> getAllFileNodes(@NotNull PsiFile file2) {
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(29);
        }
        if (!file2.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)file2, "File " + file2 + " is invalid, can't commit");
        }
        if (file2 instanceof PsiCompiledFile) {
            throw new IllegalArgumentException("Can't commit ClsFile: " + file2);
        }
        List<Pair<PsiFileImpl, FileASTNode>> list2 = ContainerUtil.map(file2.getViewProvider().getAllFiles(), root2 -> Pair.create((PsiFileImpl)root2, root2.getNode()));
        if (list2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        StandardProgressIndicatorBase standardProgressIndicatorBase = new StandardProgressIndicatorBase();
        if (standardProgressIndicatorBase == null) {
            DocumentCommitThread.$$$reportNull$$$0(31);
        }
        return standardProgressIndicatorBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewTask(@Nullable CommitTask task, @NotNull Object reason, boolean canReQueue) {
        if (reason == null) {
            DocumentCommitThread.$$$reportNull$$$0(32);
        }
        Object object = this.lock;
        synchronized (object) {
            CommitTask cur = this.currentTask;
            if (cur != null) {
                cur.cancel(reason, canReQueue);
            }
            this.currentTask = task;
        }
    }

    @NotNull
    private Pair<Runnable, Object> commitUnderProgress(@NotNull CommitTask task, boolean synchronously) {
        SmartList<BooleanRunnable> reparseInjectedProcessors;
        SmartList<BooleanRunnable> finishProcessors;
        PsiDocumentManagerBase documentManager;
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(33);
        }
        if (synchronously) assert (!task.isCanceled());
        Project project = task.project;
        Document document = task.getDocument();
        Runnable runnable = () -> this.lambda$commitUnderProgress$4(project, document, task, documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project), finishProcessors = new SmartList<BooleanRunnable>(), reparseInjectedProcessors = new SmartList<BooleanRunnable>());
        if (!this.myApplication.tryRunReadAction(runnable)) {
            this.log(project, "Could not start read action", task, this.myApplication.isReadAccessAllowed(), Thread.currentThread());
            Pair<Object, String> pair = new Pair<Object, String>(null, "Could not start read action");
            if (pair == null) {
                DocumentCommitThread.$$$reportNull$$$0(34);
            }
            return pair;
        }
        boolean canceled = task.isCanceled();
        assert (!synchronously || !canceled);
        if (canceled) {
            Pair<Object, String> pair = new Pair<Object, String>(null, "Indicator was canceled");
            if (pair == null) {
                DocumentCommitThread.$$$reportNull$$$0(35);
            }
            return pair;
        }
        Runnable result2 = this.createFinishCommitInEDTRunnable(task, synchronously, finishProcessors, reparseInjectedProcessors);
        Pair<Runnable, Object> pair = Pair.create(result2, null);
        if (pair == null) {
            DocumentCommitThread.$$$reportNull$$$0(36);
        }
        return pair;
    }

    @NotNull
    private Runnable createFinishCommitInEDTRunnable(@NotNull CommitTask task, boolean synchronously, @NotNull List<BooleanRunnable> finishProcessors, @NotNull List<BooleanRunnable> reparseInjectedProcessors) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(37);
        }
        if (finishProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(38);
        }
        if (reparseInjectedProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(39);
        }
        Runnable runnable = () -> {
            boolean success;
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(61);
            }
            if (finishProcessors == null) {
                DocumentCommitThread.$$$reportNull$$$0(62);
            }
            if (reparseInjectedProcessors == null) {
                DocumentCommitThread.$$$reportNull$$$0(63);
            }
            this.myApplication.assertIsDispatchThread();
            Document document = task.getDocument();
            Project project = task.project;
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(project);
            boolean committed = project.isDisposed() || documentManager.isCommitted(document);
            Object object = this.lock;
            synchronized (object) {
                this.documentsToApplyInEDT.remove(task);
                if (committed) {
                    this.log(project, "Marked as already committed in EDT apply queue, return", task, new Object[0]);
                    return;
                }
            }
            boolean changeStillValid = task.isStillValid();
            boolean bl = success = changeStillValid && documentManager.finishCommit(document, finishProcessors, reparseInjectedProcessors, synchronously, task.reason);
            if (synchronously) assert (success);
            if (!changeStillValid) {
                this.log(project, "document changed; ignore", task, new Object[0]);
                return;
            }
            if (synchronously || success) assert (!documentManager.isInUncommittedSet(document));
            if (success) {
                this.log(project, "Commit finished", task, new Object[0]);
            } else {
                this.commitAsynchronously(project, document, "Re-added back", task.myCreationContext);
            }
        };
        if (runnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(40);
        }
        return runnable;
    }

    @NotNull
    private BooleanRunnable handleCommitWithoutPsi(@NotNull PsiDocumentManagerBase documentManager, @NotNull CommitTask task) {
        if (documentManager == null) {
            DocumentCommitThread.$$$reportNull$$$0(41);
        }
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(42);
        }
        BooleanRunnable booleanRunnable = () -> {
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(59);
            }
            if (documentManager == null) {
                DocumentCommitThread.$$$reportNull$$$0(60);
            }
            this.log(task.project, "Finishing without PSI", task, new Object[0]);
            Document document = task.getDocument();
            if (!task.isStillValid() || documentManager.getCachedViewProvider(document) != null) {
                return false;
            }
            documentManager.handleCommitWithoutPsi(document);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(43);
        }
        return booleanRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        Object object = this.lock;
        synchronized (object) {
            return this.myEnabled;
        }
    }

    public String toString() {
        return "Document commit thread; application: " + this.myApplication + "; isDisposed: " + this.isDisposed + "; myEnabled: " + this.isEnabled();
    }

    @NotNull
    private static BooleanRunnable doCommit(@NotNull CommitTask task, @NotNull PsiFile file2, @NotNull FileASTNode oldFileNode, @NotNull ProperTextRange changedPsiRange, @NotNull List<? super BooleanRunnable> outReparseInjectedProcessors) {
        DiffLog diffLog;
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(45);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(46);
        }
        if (changedPsiRange == null) {
            DocumentCommitThread.$$$reportNull$$$0(47);
        }
        if (outReparseInjectedProcessors == null) {
            DocumentCommitThread.$$$reportNull$$$0(48);
        }
        Document document = task.getDocument();
        CharSequence newDocumentText = document.getImmutableCharSequence();
        Boolean data = document.getUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            document.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, data);
        }
        try (BlockSupportImpl.ReparseResult result2 = BlockSupportImpl.reparse(file2, oldFileNode, changedPsiRange, newDocumentText, task.indicator, task.myLastCommittedText);){
            diffLog = result2.log;
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(task.project);
            List<BooleanRunnable> injectedRunnables = documentManager.reparseChangedInjectedFragments(document, file2, changedPsiRange, task.indicator, result2.oldRoot, result2.newRoot);
            outReparseInjectedProcessors.addAll(injectedRunnables);
        }
        BooleanRunnable booleanRunnable = () -> {
            if (file2 == null) {
                DocumentCommitThread.$$$reportNull$$$0(56);
            }
            if (task == null) {
                DocumentCommitThread.$$$reportNull$$$0(57);
            }
            if (oldFileNode == null) {
                DocumentCommitThread.$$$reportNull$$$0(58);
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            Document document1 = task.getDocument();
            if (!task.isStillValid() || ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file2.getProject())).getCachedViewProvider(document1) != viewProvider) {
                return false;
            }
            if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                VirtualFile vFile = viewProvider.getVirtualFile();
                LOG.error("Write action expected; document=" + document1 + "; file=" + file2 + " of " + file2.getClass() + "; file.valid=" + file2.isValid() + "; file.eventSystemEnabled=" + viewProvider.isEventSystemEnabled() + "; viewProvider=" + viewProvider + " of " + viewProvider.getClass() + "; language=" + file2.getLanguage() + "; vFile=" + vFile + " of " + vFile.getClass() + "; free-threaded=" + AbstractFileViewProvider.isFreeThreaded(viewProvider));
            }
            diffLog.doActualPsiChange(file2);
            DocumentCommitThread.assertAfterCommit(document1, file2, (FileElement)oldFileNode);
            return true;
        };
        if (booleanRunnable == null) {
            DocumentCommitThread.$$$reportNull$$$0(49);
        }
        return booleanRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertAfterCommit(@NotNull Document document, @NotNull PsiFile file2, @NotNull FileElement oldFileNode) {
        if (document == null) {
            DocumentCommitThread.$$$reportNull$$$0(50);
        }
        if (file2 == null) {
            DocumentCommitThread.$$$reportNull$$$0(51);
        }
        if (oldFileNode == null) {
            DocumentCommitThread.$$$reportNull$$$0(52);
        }
        if (oldFileNode.getTextLength() != document.getTextLength()) {
            String documentText = document.getText();
            String fileText = file2.getText();
            boolean sameText = Comparing.equal(fileText, documentText);
            LOG.error("commitDocument() left PSI inconsistent: " + DebugUtil.diagnosePsiDocumentInconsistency(file2, document) + "; node.length=" + oldFileNode.getTextLength() + "; doc.text" + (sameText ? "==" : "!=") + "file.text; file name:" + file2.getName() + "; type:" + file2.getFileType() + "; lang:" + file2.getLanguage());
            file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            try {
                BlockSupport blockSupport = BlockSupport.getInstance(file2.getProject());
                DiffLog diffLog = blockSupport.reparseRange(file2, file2.getNode(), new TextRange(0, documentText.length()), documentText, DocumentCommitThread.createProgressIndicator(), oldFileNode.getText());
                diffLog.doActualPsiChange(file2);
                if (oldFileNode.getTextLength() != document.getTextLength()) {
                    LOG.error("PSI is broken beyond repair in: " + file2);
                }
            }
            finally {
                file2.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, null);
            }
        }
    }

    private static Lock getDocumentLock(Document document) {
        Lock lock = document.getUserData(DOCUMENT_LOCK);
        return lock != null ? lock : (Lock)((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(DOCUMENT_LOCK, new ReentrantLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$commitUnderProgress$4(Project project, Document document, @NotNull CommitTask task, PsiDocumentManagerBase documentManager, List finishProcessors, List reparseInjectedProcessors) {
        if (task == null) {
            DocumentCommitThread.$$$reportNull$$$0(64);
        }
        this.myApplication.assertReadAccessAllowed();
        if (project.isDisposed()) {
            return;
        }
        Lock lock = DocumentCommitThread.getDocumentLock(document);
        if (!lock.tryLock()) {
            task.cancel("Can't obtain document lock", true);
            return;
        }
        boolean canceled = false;
        try {
            if (documentManager.isCommitted(document)) {
                return;
            }
            if (!task.isStillValid()) {
                canceled = true;
                return;
            }
            FileViewProvider viewProvider = documentManager.getCachedViewProvider(document);
            if (viewProvider == null) {
                finishProcessors.add(this.handleCommitWithoutPsi(documentManager, task));
                return;
            }
            for (Pair<PsiFileImpl, FileASTNode> pair : task.myOldFileNodes) {
                PsiFileImpl file2 = (PsiFileImpl)pair.first;
                if (file2.isValid()) {
                    FileASTNode oldFileNode = (FileASTNode)pair.second;
                    ProperTextRange changedPsiRange = ChangedPsiRangeUtil.getChangedPsiRange(file2, task.document, task.myLastCommittedText, document.getImmutableCharSequence());
                    if (changedPsiRange == null) continue;
                    BooleanRunnable finishProcessor = DocumentCommitThread.doCommit(task, file2, oldFileNode, changedPsiRange, reparseInjectedProcessors);
                    finishProcessors.add(finishProcessor);
                    continue;
                }
                if (task.reason.equals("Sync commit")) {
                    throw new PsiInvalidElementAccessException((PsiElement)file2, "File " + file2 + " invalidated during sync commit");
                }
                this.commitAsynchronously(project, document, "File " + file2 + " invalidated during background commit; task: " + task, task.myCreationContext);
            }
        }
        finally {
            lock.unlock();
            if (canceled) {
                task.cancel("Task invalidated", false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 27: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 26: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNodes";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTask";
                break;
            }
            case 24: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 29: 
            case 45: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 33: 
            case 37: 
            case 42: 
            case 44: 
            case 57: 
            case 59: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 38: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishProcessors";
                break;
            }
            case 39: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseInjectedProcessors";
                break;
            }
            case 41: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 46: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReparseInjectedProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTaskAndCancelSimilar";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNodes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "commitUnderProgress";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createFinishCommitInEDTRunnable";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCommitWithoutPsi";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "doCommit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cancel";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commitAsynchronously";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doQueue";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNewTaskAndCancelSimilar";
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 49: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveCurrentTask";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromDocsToApplyInEDT";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromDocsToCommit";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndRemoveFromQueue";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "commitSynchronously";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllFileNodes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "startNewTask";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "commitUnderProgress";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createFinishCommitInEDTRunnable";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitWithoutPsi";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doCommit";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "assertAfterCommit";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "cancelTasksOnProjectDispose";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCommit$7";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleCommitWithoutPsi$6";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFinishCommitInEDTRunnable$5";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "lambda$commitUnderProgress$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CommitTask {
        @NotNull
        private final Document document;
        @NotNull
        final Project project;
        private final int modificationSequence;
        @NotNull
        final ProgressIndicator indicator;
        @NotNull
        final Object reason;
        @Nullable
        final TransactionId myCreationContext;
        private final CharSequence myLastCommittedText;
        @NotNull
        final List<Pair<PsiFileImpl, FileASTNode>> myOldFileNodes;
        private volatile boolean dead;

        CommitTask(@NotNull Project project, @NotNull Document document, @NotNull List<Pair<PsiFileImpl, FileASTNode>> oldFileNodes, @NotNull ProgressIndicator indicator, @NotNull Object reason, @Nullable TransactionId context, @NotNull CharSequence lastCommittedText) {
            if (project == null) {
                CommitTask.$$$reportNull$$$0(0);
            }
            if (document == null) {
                CommitTask.$$$reportNull$$$0(1);
            }
            if (oldFileNodes == null) {
                CommitTask.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                CommitTask.$$$reportNull$$$0(3);
            }
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(4);
            }
            if (lastCommittedText == null) {
                CommitTask.$$$reportNull$$$0(5);
            }
            this.document = document;
            this.project = project;
            this.indicator = indicator;
            this.reason = reason;
            this.myCreationContext = context;
            this.myLastCommittedText = lastCommittedText;
            this.myOldFileNodes = oldFileNodes;
            this.modificationSequence = ((DocumentEx)document).getModificationSequence();
        }

        @NonNls
        public String toString() {
            Document document = this.getDocument();
            String indicatorInfo = this.isCanceled() ? " (Canceled: " + ((UserDataHolder)((Object)this.indicator)).getUserData(CANCEL_REASON) + ")" : "";
            String removedInfo = this.dead ? " (dead)" : "";
            String reasonInfo = " task reason: " + StringUtil.first(String.valueOf(this.reason), 180, true) + (this.isStillValid() ? "" : "; changed: old seq=" + this.modificationSequence + ", new seq=" + ((DocumentEx)document).getModificationSequence());
            String contextInfo = " Context: " + this.myCreationContext;
            return System.identityHashCode(this) + "; " + indicatorInfo + removedInfo + contextInfo + reasonInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CommitTask)) {
                return false;
            }
            CommitTask task = (CommitTask)o;
            return Comparing.equal(this.getDocument(), task.getDocument()) && this.project.equals(task.project);
        }

        public int hashCode() {
            int result2 = this.getDocument().hashCode();
            result2 = 31 * result2 + this.project.hashCode();
            return result2;
        }

        boolean isStillValid() {
            Document document = this.getDocument();
            return ((DocumentEx)document).getModificationSequence() == this.modificationSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(@NotNull Object reason, boolean canReQueue) {
            if (reason == null) {
                CommitTask.$$$reportNull$$$0(6);
            }
            this.dead |= !canReQueue;
            if (!this.isCanceled()) {
                DocumentCommitThread.this.log(this.project, "cancel", this, new Object[]{reason});
                this.indicator.cancel();
                ((UserDataHolder)((Object)this.indicator)).putUserData(CANCEL_REASON, reason);
                Object object = DocumentCommitThread.this.lock;
                synchronized (object) {
                    DocumentCommitThread.this.documentsToCommit.remove(this);
                    DocumentCommitThread.this.documentsToApplyInEDT.remove(this);
                }
            }
        }

        @NotNull
        Document getDocument() {
            Document document = this.document;
            if (document == null) {
                CommitTask.$$$reportNull$$$0(7);
            }
            return document;
        }

        private boolean isCanceled() {
            return this.indicator.isCanceled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldFileNodes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastCommittedText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/DocumentCommitThread$CommitTask";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "cancel";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

