/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.display;

import java.io.IOException;
import org.sunflow.PluginRegistry;
import org.sunflow.core.Display;
import org.sunflow.image.BitmapWriter;
import org.sunflow.image.Color;
import org.sunflow.system.FileUtils;
import org.sunflow.system.UI;

public class FileDisplay
implements Display {
    private BitmapWriter writer;
    private String filename;

    public FileDisplay(boolean bl) {
        this(bl ? "output.png" : ".none");
    }

    public FileDisplay(String string) {
        this.filename = string == null ? "output.png" : string;
        String string2 = FileUtils.getExtension(string);
        this.writer = PluginRegistry.bitmapWriterPlugins.createObject(string2);
    }

    public void imageBegin(int n, int n2, int n3) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.openFile(this.filename);
            this.writer.writeHeader(n, n2, n3);
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.IMG, "I/O error occured while preparing image for display: %s", iOException.getMessage());
        }
    }

    public void imagePrepare(int n, int n2, int n3, int n4, int n5) {
    }

    public void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.writeTile(n, n2, n3, n4, colorArray, fArray);
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.IMG, "I/O error occured while writing image tile [(%d,%d) %dx%d] image for display: %s", n, n2, n3, n4, iOException.getMessage());
        }
    }

    public void imageFill(int n, int n2, int n3, int n4, Color color, float f) {
        if (this.writer == null) {
            return;
        }
        Color[] colorArray = new Color[n3 * n4];
        float[] fArray = new float[n3 * n4];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = color;
            fArray[i] = f;
        }
        this.imageUpdate(n, n2, n3, n4, colorArray, fArray);
    }

    public void imageEnd() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.closeFile();
        }
        catch (IOException iOException) {
            UI.printError(UI.Module.IMG, "I/O error occured while closing the display: %s", iOException.getMessage());
        }
    }
}

