/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.Log;
import com.sun.media.rtp.util.RTPTimeReporter;
import java.util.Vector;
import javax.media.Time;
import javax.media.TimeBase;

public class RTPTimeBase
implements TimeBase {
    static Vector timeBases = new Vector();
    static int SSRC_UNDEFINED = 0;
    String cname;
    RTPTimeReporter master = null;
    Vector reporters = new Vector();
    long origin = 0L;
    long offset = 0L;
    boolean offsetUpdatable = true;

    public static RTPTimeBase find(RTPTimeReporter r, String cname) {
        Vector vector = timeBases;
        synchronized (vector) {
            RTPTimeBase result = null;
            int i = 0;
            while (i < timeBases.size()) {
                RTPTimeBase tb = (RTPTimeBase)timeBases.elementAt(i);
                if (tb.cname.equals(cname)) {
                    result = tb;
                    break;
                }
                ++i;
            }
            if (result == null) {
                Log.comment("Created RTP time base for session: " + cname + "\n");
                result = new RTPTimeBase(cname);
                timeBases.addElement(result);
            }
            if (r != null) {
                if (result.getMaster() == null) {
                    result.setMaster(r);
                }
                result.reporters.addElement(r);
            }
            RTPTimeBase rTPTimeBase = result;
            return rTPTimeBase;
        }
    }

    public static void remove(RTPTimeReporter r, String cname) {
        Vector vector = timeBases;
        synchronized (vector) {
            int i = 0;
            while (i < timeBases.size()) {
                RTPTimeBase tb = (RTPTimeBase)timeBases.elementAt(i);
                if (tb.cname.equals(cname)) {
                    tb.reporters.removeElement(r);
                    if (tb.reporters.size() == 0) {
                        tb.master = null;
                        timeBases.removeElement(tb);
                        break;
                    }
                    RTPTimeBase rTPTimeBase = tb;
                    synchronized (rTPTimeBase) {
                        if (tb.master == r) {
                            tb.setMaster((RTPTimeReporter)tb.reporters.elementAt(0));
                        }
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public static RTPTimeBase getMapper(String cname) {
        Vector vector = timeBases;
        synchronized (vector) {
            RTPTimeBase rTPTimeBase = RTPTimeBase.find(null, cname);
            return rTPTimeBase;
        }
    }

    public static RTPTimeBase getMapperUpdatable(String cname) {
        Vector vector = timeBases;
        synchronized (vector) {
            RTPTimeBase tb = RTPTimeBase.find(null, cname);
            if (tb.offsetUpdatable) {
                tb.offsetUpdatable = false;
                RTPTimeBase rTPTimeBase = tb;
                return rTPTimeBase;
            }
            RTPTimeBase rTPTimeBase = null;
            return rTPTimeBase;
        }
    }

    public static void returnMapperUpdatable(RTPTimeBase tb) {
        Vector vector = timeBases;
        synchronized (vector) {
            tb.offsetUpdatable = true;
        }
    }

    RTPTimeBase(String cname) {
        this.cname = cname;
    }

    public Time getTime() {
        return new Time(this.getNanoseconds());
    }

    public synchronized long getNanoseconds() {
        return this.master != null ? this.master.getRTPTime() : 0L;
    }

    public synchronized void setMaster(RTPTimeReporter r) {
        this.master = r;
    }

    public synchronized RTPTimeReporter getMaster() {
        return this.master;
    }

    public synchronized void setOrigin(long orig) {
        this.origin = orig;
    }

    public long getOrigin() {
        return this.origin;
    }

    public synchronized void setOffset(long off) {
        this.offset = off;
    }

    public long getOffset() {
        return this.offset;
    }
}

