/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.InputStream;
import IceInternal.EndpointFactory;
import IceInternal.EndpointFactoryWithUnderlying;
import IceInternal.EndpointI;
import IceInternal.ProtocolInstance;
import java.util.ArrayList;

public class UnderlyingEndpointFactory
implements EndpointFactory {
    protected ProtocolInstance _instance;
    private final short _type;
    private final short _underlying;
    private EndpointFactory _factory;

    public UnderlyingEndpointFactory(ProtocolInstance instance, short type, short underlying) {
        this._instance = instance;
        this._type = type;
        this._underlying = underlying;
    }

    @Override
    public void initialize() {
        EndpointFactory factory = this._instance.getEndpointFactory(this._type);
        if (factory != null && factory instanceof EndpointFactoryWithUnderlying) {
            EndpointFactoryWithUnderlying f = (EndpointFactoryWithUnderlying)factory;
            this._factory = f.cloneWithUnderlying(this._instance, this._underlying);
            this._factory.initialize();
        }
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public EndpointI create(ArrayList<String> args, boolean oaEndpoint) {
        if (this._factory == null) {
            return null;
        }
        return this._factory.create(args, oaEndpoint);
    }

    @Override
    public EndpointI read(InputStream s) {
        if (this._factory == null) {
            return null;
        }
        return this._factory.read(s);
    }

    @Override
    public void destroy() {
        if (this._factory != null) {
            this._factory.destroy();
        }
        this._instance = null;
    }

    @Override
    public EndpointFactory clone(ProtocolInstance instance) {
        return new UnderlyingEndpointFactory(instance, this._type, this._underlying);
    }
}

