// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 *
 **/
public interface PermissionsVerifierPrx extends Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param reason The reason why access was denied.
     *
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     **/
    public boolean checkPermissions(String userId, String password, Ice.StringHolder reason)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param reason The reason why access was denied.
     *
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     **/
    public boolean checkPermissions(String userId, String password, Ice.StringHolder reason, java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> context);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, Ice.Callback cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, Callback_PermissionsVerifier_checkPermissions cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId, String password, java.util.Map<String, String> context, Callback_PermissionsVerifier_checkPermissions cb);

    public interface FunctionalCallback_PermissionsVerifier_checkPermissions_Response
    {
        void apply(boolean ret, String reason);
    }

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId,
                                                  String password,
                                                  FunctionalCallback_PermissionsVerifier_checkPermissions_Response responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId,
                                                  String password,
                                                  FunctionalCallback_PermissionsVerifier_checkPermissions_Response responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId,
                                                  String password,
                                                  java.util.Map<String, String> context,
                                                  FunctionalCallback_PermissionsVerifier_checkPermissions_Response responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param userId The user id for which to check permission.
     *
     * @param password The user's password.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_checkPermissions(String userId,
                                                  String password,
                                                  java.util.Map<String, String> context,
                                                  FunctionalCallback_PermissionsVerifier_checkPermissions_Response responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param reason The reason why access was denied.
     *
     * @param result The asynchronous result object.
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     **/
    public boolean end_checkPermissions(Ice.StringHolder reason, Ice.AsyncResult result)
        throws PermissionDeniedException;
}
