/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pen;
import com.sun.glass.ui.View;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.geom.CameraImpl;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismParallelCameraImpl;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.prism.render.ToolkitInterface;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.stage.StageStyle;

public final class PrismPen
extends Pen {
    private static PrismCameraImpl DEFAULT_CAMERA = PrismParallelCameraImpl.getInstance();
    private static PaintCollector collector = PaintCollector.getInstance();
    Future paintRunnableFuture;
    boolean valid;
    PrismCameraImpl camera;
    ViewScene scene;
    HashMap caps = new HashMap();
    AtomicBoolean painting;
    private ViewPainter painter;
    protected PaintRenderJob paintRenderJob;
    private boolean depthBuffer;

    public PrismPen(ViewScene viewScene, boolean bl) {
        this.scene = viewScene;
        this.valid = false;
        this.depthBuffer = bl;
        this.painting = new AtomicBoolean(false);
        viewScene.setFillPaint(Color.WHITE);
    }

    boolean getDepthBuffer() {
        return this.depthBuffer;
    }

    @Override
    public Map getCapabilities() {
        GraphicsPipeline graphicsPipeline;
        Boolean bl = Boolean.TRUE;
        if (PlatformUtil.isMac() && (graphicsPipeline = GraphicsPipeline.getPipeline()) != null && graphicsPipeline.getClass().getName().endsWith("J2DPipeline")) {
            bl = Boolean.FALSE;
        }
        if (!this.caps.containsKey(View.Capability.k3dKey)) {
            this.addCapability(this.caps, View.Capability.k3dKey, bl);
            this.addCapability(this.caps, View.Capability.k3dDepthKey, new Integer(this.depthBuffer ? 16 : 0));
        }
        return this.caps;
    }

    public void repaint() {
        View view = this.scene.getPlatformView();
        if (view == null) {
            return;
        }
        if (!this.painting.getAndSet(true)) {
            Toolkit toolkit = Toolkit.getToolkit();
            ToolkitInterface toolkitInterface = (ToolkitInterface)((Object)toolkit);
            this.paintRunnableFuture = toolkitInterface.addRenderJob(this.paintRenderJob);
        }
    }

    protected Future getFuture() {
        return this.paintRunnableFuture;
    }

    protected AtomicBoolean getPainting() {
        return this.painting;
    }

    protected ViewPainter getPainter() {
        return this.painter;
    }

    protected void setPainter(ViewPainter viewPainter) {
        this.painter = viewPainter;
        this.paintRenderJob = new PaintRenderJob(this.scene, collector.getRendered(), (Runnable)((Object)this.painter));
    }

    protected Color getClearColor() {
        WindowStage windowStage;
        WindowStage windowStage2 = windowStage = this.scene != null ? this.scene.getWindowStage() : null;
        if (windowStage != null && windowStage.getStyle() == StageStyle.TRANSPARENT) {
            return Color.TRANSPARENT;
        }
        if (this.scene.fillPaint == null) {
            return Color.WHITE;
        }
        if (this.scene.fillPaint.isOpaque()) {
            if (this.scene.fillPaint.getType() == Paint.Type.COLOR) {
                return (Color)this.scene.fillPaint;
            }
            if (this.depthBuffer) {
                return Color.TRANSPARENT;
            }
            return null;
        }
        return Color.WHITE;
    }

    protected Paint getCurrentPaint() {
        WindowStage windowStage;
        WindowStage windowStage2 = windowStage = this.scene != null ? this.scene.getWindowStage() : null;
        if (windowStage != null && windowStage.getStyle() == StageStyle.TRANSPARENT) {
            return Color.TRANSPARENT.equals(this.scene.fillPaint) ? null : this.scene.fillPaint;
        }
        if (this.scene.fillPaint == null) {
            return null;
        }
        if (this.scene.fillPaint.isOpaque()) {
            if (this.scene.fillPaint.getType() == Paint.Type.COLOR) {
                return null;
            }
            return this.scene.fillPaint;
        }
        return this.scene.fillPaint;
    }

    @Override
    public void paint(long l, int n, int n2) {
    }

    void setCamera(CameraImpl cameraImpl) {
        this.camera = cameraImpl != null ? (PrismCameraImpl)cameraImpl : DEFAULT_CAMERA;
    }

    protected CameraImpl getCamera() {
        return this.camera;
    }
}

