/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.notes;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.TreeFormatter;
import org.eclipse.jgit.notes.InMemoryNoteBucket;
import org.eclipse.jgit.notes.LeafBucket;
import org.eclipse.jgit.notes.NonNoteEntry;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteBucket;
import org.eclipse.jgit.notes.NoteParser;

class FanoutBucket
extends InMemoryNoteBucket {
    private final NoteBucket[] table = new NoteBucket[256];
    private int cnt;
    private static final byte[] hexchar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    FanoutBucket(int prefixLen) {
        super(prefixLen);
    }

    void setBucket(int cell, ObjectId id) {
        this.table[cell] = new LazyNoteBucket(id);
        ++this.cnt;
    }

    void setBucket(int cell, InMemoryNoteBucket bucket) {
        this.table[cell] = bucket;
        ++this.cnt;
    }

    @Override
    Note getNote(AnyObjectId objId, ObjectReader or2) throws IOException {
        NoteBucket b = this.table[this.cell(objId)];
        return b != null ? b.getNote(objId, or2) : null;
    }

    NoteBucket getBucket(int cell) {
        return this.table[cell];
    }

    static InMemoryNoteBucket loadIfLazy(NoteBucket b, AnyObjectId prefix, ObjectReader or2) throws IOException {
        if (b == null) {
            return null;
        }
        if (b instanceof InMemoryNoteBucket) {
            return (InMemoryNoteBucket)b;
        }
        return ((LazyNoteBucket)b).load(prefix, or2);
    }

    @Override
    Iterator<Note> iterator(AnyObjectId objId, final ObjectReader reader2) throws IOException {
        final MutableObjectId id = new MutableObjectId();
        id.fromObjectId(objId);
        return new Iterator<Note>(){
            private int cell;
            private Iterator<Note> itr;

            @Override
            public boolean hasNext() {
                if (this.itr != null && this.itr.hasNext()) {
                    return true;
                }
                while (this.cell < FanoutBucket.this.table.length) {
                    NoteBucket b = FanoutBucket.this.table[this.cell];
                    if (b != null) {
                        try {
                            id.setByte(FanoutBucket.this.prefixLen >> 1, this.cell);
                            this.itr = b.iterator(id, reader2);
                        }
                        catch (IOException err) {
                            throw new RuntimeException(err);
                        }
                        if (this.itr.hasNext()) {
                            ++this.cell;
                            return true;
                        }
                    }
                    ++this.cell;
                }
                return false;
            }

            @Override
            public Note next() {
                if (this.hasNext()) {
                    return this.itr.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    int estimateSize(AnyObjectId noteOn, ObjectReader or2) throws IOException {
        if (192 <= this.cnt) {
            return 257;
        }
        MutableObjectId id = new MutableObjectId();
        id.fromObjectId(noteOn);
        int sz = 0;
        for (int cell = 0; cell < 256; ++cell) {
            NoteBucket b = this.table[cell];
            if (b == null) continue;
            id.setByte(this.prefixLen >> 1, cell);
            if (256 < (sz += b.estimateSize(id, or2))) break;
        }
        return sz;
    }

    @Override
    InMemoryNoteBucket set(AnyObjectId noteOn, AnyObjectId noteData, ObjectReader or2) throws IOException {
        int cell = this.cell(noteOn);
        NoteBucket b = this.table[cell];
        if (b == null) {
            if (noteData == null) {
                return this;
            }
            LeafBucket n = new LeafBucket(this.prefixLen + 2);
            this.table[cell] = n.set(noteOn, noteData, or2);
            ++this.cnt;
            return this;
        }
        InMemoryNoteBucket n = b.set(noteOn, noteData, or2);
        if (n == null) {
            this.table[cell] = null;
            --this.cnt;
            if (this.cnt == 0) {
                return null;
            }
            return this.contractIfTooSmall(noteOn, or2);
        }
        if (n != b) {
            this.table[cell] = n;
        }
        return this;
    }

    InMemoryNoteBucket contractIfTooSmall(AnyObjectId noteOn, ObjectReader or2) throws IOException {
        if (this.estimateSize(noteOn, or2) < 256) {
            InMemoryNoteBucket r = new LeafBucket(this.prefixLen);
            Iterator<Note> i = this.iterator(noteOn, or2);
            while (i.hasNext()) {
                r = ((InMemoryNoteBucket)r).append(i.next());
            }
            r.nonNotes = this.nonNotes;
            return r;
        }
        return this;
    }

    @Override
    ObjectId writeTree(ObjectInserter inserter) throws IOException {
        return inserter.insert(this.build(true, inserter));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    ObjectId getTreeId() {
        try (ObjectInserter.Formatter f = new ObjectInserter.Formatter();){
            ObjectId objectId = f.idFor(this.build(false, null));
            return objectId;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private TreeFormatter build(boolean insert, ObjectInserter inserter) throws IOException {
        byte[] nameBuf = new byte[2];
        TreeFormatter fmt = new TreeFormatter(this.treeSize());
        NonNoteEntry e2 = this.nonNotes;
        for (int cell = 0; cell < 256; ++cell) {
            NoteBucket b = this.table[cell];
            if (b == null) continue;
            nameBuf[0] = hexchar[cell >>> 4];
            nameBuf[1] = hexchar[cell & 0xF];
            while (e2 != null && e2.pathCompare(nameBuf, 0, 2, FileMode.TREE) < 0) {
                e2.format(fmt);
                e2 = e2.next;
            }
            ObjectId id = insert ? b.writeTree(inserter) : b.getTreeId();
            fmt.append(nameBuf, 0, 2, FileMode.TREE, id);
        }
        while (e2 != null) {
            e2.format(fmt);
            e2 = e2.next;
        }
        return fmt;
    }

    private int treeSize() {
        int sz = this.cnt * TreeFormatter.entrySize(FileMode.TREE, 2);
        NonNoteEntry e2 = this.nonNotes;
        while (e2 != null) {
            sz += e2.treeEntrySize();
            e2 = e2.next;
        }
        return sz;
    }

    @Override
    InMemoryNoteBucket append(Note note) {
        int cell = this.cell(note);
        InMemoryNoteBucket b = (InMemoryNoteBucket)this.table[cell];
        if (b == null) {
            LeafBucket n = new LeafBucket(this.prefixLen + 2);
            this.table[cell] = n.append(note);
            ++this.cnt;
        } else {
            InMemoryNoteBucket n = b.append(note);
            if (n != b) {
                this.table[cell] = n;
            }
        }
        return this;
    }

    private int cell(AnyObjectId id) {
        return id.getByte(this.prefixLen >> 1);
    }

    private class LazyNoteBucket
    extends NoteBucket {
        private final ObjectId treeId;

        LazyNoteBucket(ObjectId treeId) {
            this.treeId = treeId;
        }

        @Override
        Note getNote(AnyObjectId objId, ObjectReader or2) throws IOException {
            return this.load(objId, or2).getNote(objId, or2);
        }

        @Override
        Iterator<Note> iterator(AnyObjectId objId, ObjectReader reader2) throws IOException {
            return this.load(objId, reader2).iterator(objId, reader2);
        }

        @Override
        int estimateSize(AnyObjectId objId, ObjectReader or2) throws IOException {
            return this.load(objId, or2).estimateSize(objId, or2);
        }

        @Override
        InMemoryNoteBucket set(AnyObjectId noteOn, AnyObjectId noteData, ObjectReader or2) throws IOException {
            return this.load(noteOn, or2).set(noteOn, noteData, or2);
        }

        @Override
        ObjectId writeTree(ObjectInserter inserter) {
            return this.treeId;
        }

        @Override
        ObjectId getTreeId() {
            return this.treeId;
        }

        private InMemoryNoteBucket load(AnyObjectId prefix, ObjectReader or2) throws IOException {
            AbbreviatedObjectId p = prefix.abbreviate(FanoutBucket.this.prefixLen + 2);
            InMemoryNoteBucket self = NoteParser.parse(p, this.treeId, or2);
            ((FanoutBucket)FanoutBucket.this).table[((FanoutBucket)FanoutBucket.this).cell((AnyObjectId)prefix)] = self;
            return self;
        }
    }
}

