/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

public class Paths {
    public static String stripTrailingSeparator(String path2) {
        if (path2 == null || path2.isEmpty()) {
            return path2;
        }
        int i = path2.length();
        if (path2.charAt(path2.length() - 1) != '/') {
            return path2;
        }
        while (path2.charAt(--i - 1) == '/') {
        }
        return path2.substring(0, i);
    }

    public static int compare(byte[] aPath, int aPos, int aEnd, int aMode, byte[] bPath, int bPos, int bEnd, int bMode) {
        int cmp = Paths.coreCompare(aPath, aPos, aEnd, aMode, bPath, bPos, bEnd, bMode);
        if (cmp == 0) {
            cmp = Paths.lastPathChar(aMode) - Paths.lastPathChar(bMode);
        }
        return cmp;
    }

    public static int compareSameName(byte[] aPath, int aPos, int aEnd, byte[] bPath, int bPos, int bEnd, int bMode) {
        return Paths.coreCompare(aPath, aPos, aEnd, 16384, bPath, bPos, bEnd, bMode);
    }

    private static int coreCompare(byte[] aPath, int aPos, int aEnd, int aMode, byte[] bPath, int bPos, int bEnd, int bMode) {
        while (aPos < aEnd && bPos < bEnd) {
            int cmp;
            if ((cmp = (aPath[aPos++] & 0xFF) - (bPath[bPos++] & 0xFF)) == 0) continue;
            return cmp;
        }
        if (aPos < aEnd) {
            return (aPath[aPos] & 0xFF) - Paths.lastPathChar(bMode);
        }
        if (bPos < bEnd) {
            return Paths.lastPathChar(aMode) - (bPath[bPos] & 0xFF);
        }
        return 0;
    }

    private static int lastPathChar(int mode) {
        if ((mode & 0xF000) == 16384) {
            return 47;
        }
        return 0;
    }

    private Paths() {
    }
}

