/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeConverterBinding;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type2) {
        TypeConverter converter = this.converterMap.get(type2);
        if (converter == null) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type2)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type2, converter);
                break;
            }
        }
        return converter;
    }
}

