/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteAutoFollowPatternAction
extends Action<Request, AcknowledgedResponse, RequestBuilder> {
    public static final String NAME = "cluster:admin/xpack/ccr/auto_follow_pattern/delete";
    public static final DeleteAutoFollowPatternAction INSTANCE = new DeleteAutoFollowPatternAction();

    private DeleteAutoFollowPatternAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private String name;

        public Request() {
        }

        public Request(String name) {
            this.name = name;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.name == null) {
                validationException = ValidateActions.addValidationError((String)"name is missing", validationException);
            }
            return validationException;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.name = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.name, request.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

