/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ResumeFollowAction
extends Action<Request, AcknowledgedResponse, RequestBuilder> {
    public static final ResumeFollowAction INSTANCE = new ResumeFollowAction();
    public static final String NAME = "cluster:admin/xpack/ccr/resume_follow";
    public static final TimeValue MAX_RETRY_DELAY = TimeValue.timeValueMinutes((long)5L);

    private ResumeFollowAction() {
        super(NAME);
    }

    public AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, Action<Request, AcknowledgedResponse, RequestBuilder> action) {
            super(client, action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContentObject {
        static final ParseField FOLLOWER_INDEX_FIELD = new ParseField("follower_index", new String[0]);
        static final ParseField MAX_READ_REQUEST_OPERATION_COUNT = new ParseField("max_read_request_operation_count", new String[0]);
        static final ParseField MAX_READ_REQUEST_SIZE = new ParseField("max_read_request_size", new String[0]);
        static final ParseField MAX_OUTSTANDING_READ_REQUESTS = new ParseField("max_outstanding_read_requests", new String[0]);
        static final ParseField MAX_WRITE_REQUEST_OPERATION_COUNT = new ParseField("max_write_request_operation_count", new String[0]);
        static final ParseField MAX_WRITE_REQUEST_SIZE = new ParseField("max_write_request_size", new String[0]);
        static final ParseField MAX_OUTSTANDING_WRITE_REQUESTS = new ParseField("max_outstanding_write_requests", new String[0]);
        static final ParseField MAX_WRITE_BUFFER_COUNT = new ParseField("max_write_buffer_count", new String[0]);
        static final ParseField MAX_WRITE_BUFFER_SIZE = new ParseField("max_write_buffer_size", new String[0]);
        static final ParseField MAX_RETRY_DELAY_FIELD = new ParseField("max_retry_delay", new String[0]);
        static final ParseField READ_POLL_TIMEOUT = new ParseField("read_poll_timeout", new String[0]);
        static final ObjectParser<Request, String> PARSER = new ObjectParser("cluster:admin/xpack/ccr/resume_follow", Request::new);
        private String followerIndex;
        private Integer maxReadRequestOperationCount;
        private Integer maxOutstandingReadRequests;
        private ByteSizeValue maxReadRequestSize;
        private Integer maxWriteRequestOperationCount;
        private ByteSizeValue maxWriteRequestSize;
        private Integer maxOutstandingWriteRequests;
        private Integer maxWriteBufferCount;
        private ByteSizeValue maxWriteBufferSize;
        private TimeValue maxRetryDelay;
        private TimeValue readPollTimeout;

        public static Request fromXContent(XContentParser parser, String followerIndex) throws IOException {
            Request request = (Request)((Object)PARSER.parse(parser, (Object)followerIndex));
            if (followerIndex != null) {
                if (request.followerIndex == null) {
                    request.followerIndex = followerIndex;
                } else if (!request.followerIndex.equals(followerIndex)) {
                    throw new IllegalArgumentException("provided follower_index is not equal");
                }
            }
            return request;
        }

        public String getFollowerIndex() {
            return this.followerIndex;
        }

        public void setFollowerIndex(String followerIndex) {
            this.followerIndex = followerIndex;
        }

        public Integer getMaxReadRequestOperationCount() {
            return this.maxReadRequestOperationCount;
        }

        public void setMaxReadRequestOperationCount(Integer maxReadRequestOperationCount) {
            this.maxReadRequestOperationCount = maxReadRequestOperationCount;
        }

        public Integer getMaxOutstandingReadRequests() {
            return this.maxOutstandingReadRequests;
        }

        public void setMaxOutstandingReadRequests(Integer maxOutstandingReadRequests) {
            this.maxOutstandingReadRequests = maxOutstandingReadRequests;
        }

        public ByteSizeValue getMaxReadRequestSize() {
            return this.maxReadRequestSize;
        }

        public void setMaxReadRequestSize(ByteSizeValue maxReadRequestSize) {
            this.maxReadRequestSize = maxReadRequestSize;
        }

        public Integer getMaxWriteRequestOperationCount() {
            return this.maxWriteRequestOperationCount;
        }

        public void setMaxWriteRequestOperationCount(Integer maxWriteRequestOperationCount) {
            this.maxWriteRequestOperationCount = maxWriteRequestOperationCount;
        }

        public ByteSizeValue getMaxWriteRequestSize() {
            return this.maxWriteRequestSize;
        }

        public void setMaxWriteRequestSize(ByteSizeValue maxWriteRequestSize) {
            this.maxWriteRequestSize = maxWriteRequestSize;
        }

        public Integer getMaxOutstandingWriteRequests() {
            return this.maxOutstandingWriteRequests;
        }

        public void setMaxOutstandingWriteRequests(Integer maxOutstandingWriteRequests) {
            this.maxOutstandingWriteRequests = maxOutstandingWriteRequests;
        }

        public Integer getMaxWriteBufferCount() {
            return this.maxWriteBufferCount;
        }

        public void setMaxWriteBufferCount(Integer maxWriteBufferCount) {
            this.maxWriteBufferCount = maxWriteBufferCount;
        }

        public ByteSizeValue getMaxWriteBufferSize() {
            return this.maxWriteBufferSize;
        }

        public void setMaxWriteBufferSize(ByteSizeValue maxWriteBufferSize) {
            this.maxWriteBufferSize = maxWriteBufferSize;
        }

        public void setMaxRetryDelay(TimeValue maxRetryDelay) {
            this.maxRetryDelay = maxRetryDelay;
        }

        public TimeValue getMaxRetryDelay() {
            return this.maxRetryDelay;
        }

        public TimeValue getReadPollTimeout() {
            return this.readPollTimeout;
        }

        public void setReadPollTimeout(TimeValue readPollTimeout) {
            this.readPollTimeout = readPollTimeout;
        }

        public Request() {
        }

        public ActionRequestValidationException validate() {
            String message;
            ActionRequestValidationException e = null;
            if (this.followerIndex == null) {
                e = ValidateActions.addValidationError((String)(FOLLOWER_INDEX_FIELD.getPreferredName() + " is missing"), e);
            }
            if (this.maxReadRequestOperationCount != null && this.maxReadRequestOperationCount < 1) {
                e = ValidateActions.addValidationError((String)(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxReadRequestSize != null && this.maxReadRequestSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                e = ValidateActions.addValidationError((String)(MAX_READ_REQUEST_SIZE.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxOutstandingReadRequests != null && this.maxOutstandingReadRequests < 1) {
                e = ValidateActions.addValidationError((String)(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxWriteRequestOperationCount != null && this.maxWriteRequestOperationCount < 1) {
                e = ValidateActions.addValidationError((String)(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxWriteRequestSize != null && this.maxWriteRequestSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                e = ValidateActions.addValidationError((String)(MAX_WRITE_REQUEST_SIZE.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxOutstandingWriteRequests != null && this.maxOutstandingWriteRequests < 1) {
                e = ValidateActions.addValidationError((String)(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxWriteBufferCount != null && this.maxWriteBufferCount < 1) {
                e = ValidateActions.addValidationError((String)(MAX_WRITE_BUFFER_COUNT.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxWriteBufferSize != null && this.maxWriteBufferSize.compareTo(ByteSizeValue.ZERO) <= 0) {
                e = ValidateActions.addValidationError((String)(MAX_WRITE_BUFFER_SIZE.getPreferredName() + " must be larger than 0"), (ActionRequestValidationException)e);
            }
            if (this.maxRetryDelay != null && this.maxRetryDelay.millis() <= 0L) {
                message = "[" + MAX_RETRY_DELAY_FIELD.getPreferredName() + "] must be positive but was [" + this.maxRetryDelay.getStringRep() + "]";
                e = ValidateActions.addValidationError((String)message, (ActionRequestValidationException)e);
            }
            if (this.maxRetryDelay != null && this.maxRetryDelay.millis() > MAX_RETRY_DELAY.millis()) {
                message = "[" + MAX_RETRY_DELAY_FIELD.getPreferredName() + "] must be less than [" + MAX_RETRY_DELAY + "] but was [" + this.maxRetryDelay.getStringRep() + "]";
                e = ValidateActions.addValidationError((String)message, (ActionRequestValidationException)e);
            }
            return e;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followerIndex = in.readString();
            this.maxReadRequestOperationCount = in.readOptionalVInt();
            this.maxOutstandingReadRequests = in.readOptionalVInt();
            this.maxReadRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxWriteRequestOperationCount = in.readOptionalVInt();
            this.maxWriteRequestSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxOutstandingWriteRequests = in.readOptionalVInt();
            this.maxWriteBufferCount = in.readOptionalVInt();
            this.maxWriteBufferSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.maxRetryDelay = in.readOptionalTimeValue();
            this.readPollTimeout = in.readOptionalTimeValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.followerIndex);
            out.writeOptionalVInt(this.maxReadRequestOperationCount);
            out.writeOptionalVInt(this.maxOutstandingReadRequests);
            out.writeOptionalWriteable((Writeable)this.maxReadRequestSize);
            out.writeOptionalVInt(this.maxWriteRequestOperationCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteRequestSize);
            out.writeOptionalVInt(this.maxOutstandingWriteRequests);
            out.writeOptionalVInt(this.maxWriteBufferCount);
            out.writeOptionalWriteable((Writeable)this.maxWriteBufferSize);
            out.writeOptionalTimeValue(this.maxRetryDelay);
            out.writeOptionalTimeValue(this.readPollTimeout);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentFragment(builder, params);
            builder.endObject();
            return builder;
        }

        void toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FOLLOWER_INDEX_FIELD.getPreferredName(), this.followerIndex);
            if (this.maxReadRequestOperationCount != null) {
                builder.field(MAX_READ_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxReadRequestOperationCount);
            }
            if (this.maxReadRequestSize != null) {
                builder.field(MAX_READ_REQUEST_SIZE.getPreferredName(), this.maxReadRequestSize.getStringRep());
            }
            if (this.maxWriteRequestOperationCount != null) {
                builder.field(MAX_WRITE_REQUEST_OPERATION_COUNT.getPreferredName(), this.maxWriteRequestOperationCount);
            }
            if (this.maxWriteRequestSize != null) {
                builder.field(MAX_WRITE_REQUEST_SIZE.getPreferredName(), this.maxWriteRequestSize.getStringRep());
            }
            if (this.maxWriteBufferCount != null) {
                builder.field(MAX_WRITE_BUFFER_COUNT.getPreferredName(), this.maxWriteBufferCount);
            }
            if (this.maxWriteBufferSize != null) {
                builder.field(MAX_WRITE_BUFFER_SIZE.getPreferredName(), this.maxWriteBufferSize.getStringRep());
            }
            if (this.maxOutstandingReadRequests != null) {
                builder.field(MAX_OUTSTANDING_READ_REQUESTS.getPreferredName(), this.maxOutstandingReadRequests);
            }
            if (this.maxOutstandingWriteRequests != null) {
                builder.field(MAX_OUTSTANDING_WRITE_REQUESTS.getPreferredName(), this.maxOutstandingWriteRequests);
            }
            if (this.maxRetryDelay != null) {
                builder.field(MAX_RETRY_DELAY_FIELD.getPreferredName(), this.maxRetryDelay.getStringRep());
            }
            if (this.readPollTimeout != null) {
                builder.field(READ_POLL_TIMEOUT.getPreferredName(), this.readPollTimeout.getStringRep());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.maxReadRequestOperationCount, request.maxReadRequestOperationCount) && Objects.equals(this.maxReadRequestSize, request.maxReadRequestSize) && Objects.equals(this.maxOutstandingReadRequests, request.maxOutstandingReadRequests) && Objects.equals(this.maxWriteRequestOperationCount, request.maxWriteRequestOperationCount) && Objects.equals(this.maxWriteRequestSize, request.maxWriteRequestSize) && Objects.equals(this.maxOutstandingWriteRequests, request.maxOutstandingWriteRequests) && Objects.equals(this.maxWriteBufferCount, request.maxWriteBufferCount) && Objects.equals(this.maxWriteBufferSize, request.maxWriteBufferSize) && Objects.equals(this.maxRetryDelay, request.maxRetryDelay) && Objects.equals(this.readPollTimeout, request.readPollTimeout) && Objects.equals(this.followerIndex, request.followerIndex);
        }

        public int hashCode() {
            return Objects.hash(this.followerIndex, this.maxReadRequestOperationCount, this.maxReadRequestSize, this.maxOutstandingReadRequests, this.maxWriteRequestOperationCount, this.maxWriteRequestSize, this.maxOutstandingWriteRequests, this.maxWriteBufferCount, this.maxWriteBufferSize, this.maxRetryDelay, this.readPollTimeout);
        }

        static {
            PARSER.declareString(Request::setFollowerIndex, FOLLOWER_INDEX_FIELD);
            PARSER.declareInt(Request::setMaxReadRequestOperationCount, MAX_READ_REQUEST_OPERATION_COUNT);
            PARSER.declareField(Request::setMaxReadRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_READ_REQUEST_SIZE.getPreferredName()), MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(Request::setMaxOutstandingReadRequests, MAX_OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt(Request::setMaxWriteRequestOperationCount, MAX_WRITE_REQUEST_OPERATION_COUNT);
            PARSER.declareField(Request::setMaxWriteRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_REQUEST_SIZE.getPreferredName()), MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(Request::setMaxOutstandingWriteRequests, MAX_OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt(Request::setMaxWriteBufferCount, MAX_WRITE_BUFFER_COUNT);
            PARSER.declareField(Request::setMaxWriteBufferSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)MAX_WRITE_BUFFER_SIZE.getPreferredName()), MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareField(Request::setMaxRetryDelay, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)MAX_RETRY_DELAY_FIELD.getPreferredName()), MAX_RETRY_DELAY_FIELD, ObjectParser.ValueType.STRING);
            PARSER.declareField(Request::setReadPollTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)READ_POLL_TIMEOUT.getPreferredName()), READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        }
    }
}

