/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class DeprecationInfoAction
extends Action<Request, Response, RequestBuilder> {
    public static final DeprecationInfoAction INSTANCE = new DeprecationInfoAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/info";

    private DeprecationInfoAction() {
        super(NAME);
    }

    public static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, DeprecationInfoAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }

        public RequestBuilder setIndices(String ... indices) {
            ((Request)this.request).indices(indices);
            return this;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] indices = Strings.EMPTY_ARRAY;
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);

        public Request() {
        }

        public Request(String ... indices) {
            this.indices = indices;
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.indices = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private List<DeprecationIssue> clusterSettingsIssues;
        private List<DeprecationIssue> nodeSettingsIssues;
        private Map<String, List<DeprecationIssue>> indexSettingsIssues;

        public Response() {
        }

        public Response(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, List<DeprecationIssue>> indexSettingsIssues) {
            this.clusterSettingsIssues = clusterSettingsIssues;
            this.nodeSettingsIssues = nodeSettingsIssues;
            this.indexSettingsIssues = indexSettingsIssues;
        }

        public List<DeprecationIssue> getClusterSettingsIssues() {
            return this.clusterSettingsIssues;
        }

        public List<DeprecationIssue> getNodeSettingsIssues() {
            return this.nodeSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
            return this.indexSettingsIssues;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterSettingsIssues = in.readList(DeprecationIssue::new);
            this.nodeSettingsIssues = in.readList(DeprecationIssue::new);
            this.indexSettingsIssues = in.readMapOfLists(StreamInput::readString, DeprecationIssue::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.clusterSettingsIssues);
            out.writeList(this.nodeSettingsIssues);
            out.writeMapOfLists(this.indexSettingsIssues, StreamOutput::writeString, (o, v) -> v.writeTo(o));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("cluster_settings", this.clusterSettingsIssues.toArray()).array("node_settings", this.nodeSettingsIssues.toArray()).field("index_settings").map(this.indexSettingsIssues).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.clusterSettingsIssues, response.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, response.nodeSettingsIssues) && Objects.equals(this.indexSettingsIssues, response.indexSettingsIssues);
        }

        public int hashCode() {
            return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.indexSettingsIssues);
        }

        public static Response from(List<NodeInfo> nodesInfo, List<NodeStats> nodesStats, ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver, String[] indices, IndicesOptions indicesOptions, List<Function<ClusterState, DeprecationIssue>> clusterSettingsChecks, List<BiFunction<List<NodeInfo>, List<NodeStats>, DeprecationIssue>> nodeSettingsChecks, List<Function<IndexMetaData, DeprecationIssue>> indexSettingsChecks) {
            List<DeprecationIssue> clusterSettingsIssues = DeprecationInfoAction.filterChecks(clusterSettingsChecks, c -> (DeprecationIssue)c.apply(state));
            List<DeprecationIssue> nodeSettingsIssues = DeprecationInfoAction.filterChecks(nodeSettingsChecks, c -> (DeprecationIssue)c.apply(nodesInfo, nodesStats));
            String[] concreteIndexNames = indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, indices);
            HashMap<String, List<DeprecationIssue>> indexSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
            for (String concreteIndex : concreteIndexNames) {
                IndexMetaData indexMetaData = state.getMetaData().index(concreteIndex);
                List<DeprecationIssue> singleIndexIssues = DeprecationInfoAction.filterChecks(indexSettingsChecks, c -> (DeprecationIssue)c.apply(indexMetaData));
                if (singleIndexIssues.size() <= 0) continue;
                indexSettingsIssues.put(concreteIndex, singleIndexIssues);
            }
            return new Response(clusterSettingsIssues, nodeSettingsIssues, indexSettingsIssues);
        }
    }
}

