/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed.extractor;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.joda.time.DateTimeZone;

public final class ExtractorUtils {
    private static final Logger LOGGER = Loggers.getLogger(ExtractorUtils.class);
    private static final String EPOCH_MILLIS = "epoch_millis";

    private ExtractorUtils() {
    }

    public static QueryBuilder wrapInTimeRangeQuery(QueryBuilder userQuery, String timeField, long start, long end) {
        RangeQueryBuilder timeQuery = new RangeQueryBuilder(timeField).gte((Object)start).lt((Object)end).format(EPOCH_MILLIS);
        return new BoolQueryBuilder().filter(userQuery).filter((QueryBuilder)timeQuery);
    }

    public static void checkSearchWasSuccessful(String jobId, SearchResponse searchResponse) throws IOException {
        if (searchResponse.status() != RestStatus.OK) {
            throw new IOException("[" + jobId + "] Search request returned status code: " + searchResponse.status() + ". Response was:\n" + searchResponse.toString());
        }
        Object[] shardFailures = searchResponse.getShardFailures();
        if (shardFailures != null && shardFailures.length > 0) {
            LOGGER.error("[{}] Search request returned shard failures: {}", (Object)jobId, (Object)Arrays.toString(shardFailures));
            throw new IOException(ExceptionsHelper.shardFailuresToErrorMsg(jobId, (ShardSearchFailure[])shardFailures));
        }
        int unavailableShards = searchResponse.getTotalShards() - searchResponse.getSuccessfulShards();
        if (unavailableShards > 0) {
            throw new IOException("[" + jobId + "] Search request encountered [" + unavailableShards + "] unavailable shards");
        }
    }

    public static long getHistogramIntervalMillis(AggregatorFactories.Builder aggFactory) {
        AggregationBuilder histogram = ExtractorUtils.getHistogramAggregation(aggFactory.getAggregatorFactories());
        return ExtractorUtils.getHistogramIntervalMillis(histogram);
    }

    public static AggregationBuilder getHistogramAggregation(Collection<AggregationBuilder> aggregations) {
        if (aggregations.isEmpty()) {
            throw ExceptionsHelper.badRequestException(Messages.getMessage("A date_histogram (or histogram) aggregation is required"), new Object[0]);
        }
        if (aggregations.size() != 1) {
            throw ExceptionsHelper.badRequestException("The date_histogram (or histogram) aggregation cannot have sibling aggregations", new Object[0]);
        }
        AggregationBuilder agg = aggregations.iterator().next();
        if (ExtractorUtils.isHistogram(agg)) {
            return agg;
        }
        return ExtractorUtils.getHistogramAggregation(agg.getSubAggregations());
    }

    public static boolean isHistogram(AggregationBuilder aggregationBuilder) {
        return aggregationBuilder instanceof HistogramAggregationBuilder || aggregationBuilder instanceof DateHistogramAggregationBuilder;
    }

    public static long getHistogramIntervalMillis(AggregationBuilder histogramAggregation) {
        if (histogramAggregation instanceof HistogramAggregationBuilder) {
            return (long)((HistogramAggregationBuilder)histogramAggregation).interval();
        }
        if (histogramAggregation instanceof DateHistogramAggregationBuilder) {
            return ExtractorUtils.validateAndGetDateHistogramInterval((DateHistogramAggregationBuilder)histogramAggregation);
        }
        throw new IllegalStateException("Invalid histogram aggregation [" + histogramAggregation.getName() + "]");
    }

    private static long validateAndGetDateHistogramInterval(DateHistogramAggregationBuilder dateHistogram) {
        if (dateHistogram.timeZone() != null && !dateHistogram.timeZone().equals((Object)DateTimeZone.UTC)) {
            throw ExceptionsHelper.badRequestException("ML requires date_histogram.time_zone to be UTC", new Object[0]);
        }
        if (dateHistogram.dateHistogramInterval() != null) {
            return ExtractorUtils.validateAndGetCalendarInterval(dateHistogram.dateHistogramInterval().toString());
        }
        return dateHistogram.interval();
    }

    static long validateAndGetCalendarInterval(String calendarInterval) {
        TimeValue interval;
        block10: {
            block9: {
                DateTimeUnit dateTimeUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(calendarInterval);
                if (dateTimeUnit == null) break block9;
                switch (dateTimeUnit) {
                    case WEEK_OF_WEEKYEAR: {
                        interval = new TimeValue(7L, TimeUnit.DAYS);
                        break block10;
                    }
                    case DAY_OF_MONTH: {
                        interval = new TimeValue(1L, TimeUnit.DAYS);
                        break block10;
                    }
                    case HOUR_OF_DAY: {
                        interval = new TimeValue(1L, TimeUnit.HOURS);
                        break block10;
                    }
                    case MINUTES_OF_HOUR: {
                        interval = new TimeValue(1L, TimeUnit.MINUTES);
                        break block10;
                    }
                    case SECOND_OF_MINUTE: {
                        interval = new TimeValue(1L, TimeUnit.SECONDS);
                        break block10;
                    }
                    case MONTH_OF_YEAR: 
                    case YEAR_OF_CENTURY: 
                    case QUARTER: {
                        throw ExceptionsHelper.badRequestException(ExtractorUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
                    }
                    default: {
                        throw ExceptionsHelper.badRequestException("Unexpected dateTimeUnit [" + dateTimeUnit + "]", new Object[0]);
                    }
                }
            }
            interval = TimeValue.parseTimeValue((String)calendarInterval, (String)"date_histogram.interval");
        }
        if (interval.days() > 7L) {
            throw ExceptionsHelper.badRequestException(ExtractorUtils.invalidDateHistogramCalendarIntervalMessage(calendarInterval), new Object[0]);
        }
        return interval.millis();
    }

    private static String invalidDateHistogramCalendarIntervalMessage(String interval) {
        throw ExceptionsHelper.badRequestException("When specifying a date_histogram calendar interval [" + interval + "], ML does not accept intervals longer than a week because of variable lengths of periods greater than a week", new Object[0]);
    }
}

