/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;

public class MonitoringService
extends AbstractLifecycleComponent {
    public static final TimeValue MIN_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<Boolean> ELASTICSEARCH_COLLECTION_ENABLED = Setting.boolSetting((String)"xpack.monitoring.elasticsearch.collection.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> ENABLED = Setting.boolSetting((String)"xpack.monitoring.collection.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> INTERVAL = new Setting("xpack.monitoring.collection.interval", "10s", s -> {
        TimeValue value = TimeValue.parseTimeValue((String)s, null, (String)"xpack.monitoring.collection.interval");
        if (TimeValue.MINUS_ONE.equals((Object)value) || value.millis() >= MIN_INTERVAL.millis()) {
            MonitoringService.deprecateMinusOne(value);
            return value;
        }
        throw new IllegalArgumentException("Failed to parse monitoring interval [" + s + "], value must be >= " + MIN_INTERVAL);
    }, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final MonitoringExecution monitor = new MonitoringExecution();
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Set<Collector> collectors;
    private final Exporters exporters;
    private volatile boolean elasticsearchCollectionEnabled;
    private volatile boolean enabled;
    private volatile TimeValue interval;
    private volatile Scheduler.Cancellable scheduler;

    private static void deprecateMinusOne(TimeValue value) {
        if (TimeValue.MINUS_ONE.equals((Object)value)) {
            DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(MonitoringService.class));
            deprecationLogger.deprecated("Setting [xpack.monitoring.collection.interval] to [-1] has been deprecated as the way to disable collection. Use [xpack.monitoring.collection.enabled] set to [false] instead.", new Object[0]);
        }
    }

    MonitoringService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Set<Collector> collectors, Exporters exporters) {
        super(settings);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.collectors = Objects.requireNonNull(collectors);
        this.exporters = Objects.requireNonNull(exporters);
        this.elasticsearchCollectionEnabled = (Boolean)ELASTICSEARCH_COLLECTION_ENABLED.get(settings);
        this.enabled = (Boolean)ENABLED.get(settings);
        this.interval = (TimeValue)INTERVAL.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ELASTICSEARCH_COLLECTION_ENABLED, this::setElasticsearchCollectionEnabled);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLED, this::setMonitoringActive);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(INTERVAL, this::setInterval);
    }

    void setElasticsearchCollectionEnabled(boolean enabled) {
        this.elasticsearchCollectionEnabled = enabled;
        this.scheduleExecution();
    }

    void setMonitoringActive(boolean enabled) {
        this.enabled = enabled;
        this.scheduleExecution();
    }

    void setInterval(TimeValue interval) {
        this.interval = interval;
        this.scheduleExecution();
    }

    public TimeValue getInterval() {
        return this.interval;
    }

    public boolean isMonitoringActive() {
        return this.isStarted() && this.enabled && this.interval != null && this.interval.millis() >= MIN_INTERVAL.millis();
    }

    boolean isElasticsearchCollectionEnabled() {
        return this.elasticsearchCollectionEnabled;
    }

    boolean shouldScheduleExecution() {
        return this.isElasticsearchCollectionEnabled() && this.isMonitoringActive();
    }

    private String threadPoolName() {
        return "generic";
    }

    boolean isStarted() {
        return this.started.get();
    }

    protected void doStart() {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.logger.debug("monitoring service is starting");
                this.scheduleExecution();
                this.logger.debug("monitoring service started");
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to start monitoring service", new Object[0]), (Throwable)e);
                this.started.set(false);
                throw e;
            }
        }
    }

    protected void doStop() {
        if (this.started.getAndSet(false)) {
            this.logger.debug("monitoring service is stopping");
            this.cancelExecution();
            this.logger.debug("monitoring service stopped");
        }
    }

    protected void doClose() {
        this.logger.debug("monitoring service is closing");
        this.monitor.close();
        for (Exporter exporter : this.exporters) {
            try {
                exporter.close();
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to close exporter [{}]", (Object)exporter.name()), (Throwable)e);
            }
        }
        this.logger.debug("monitoring service closed");
    }

    void scheduleExecution() {
        if (this.scheduler != null) {
            this.cancelExecution();
        }
        if (this.shouldScheduleExecution()) {
            this.scheduler = this.threadPool.scheduleWithFixedDelay((Runnable)((Object)this.monitor), this.interval, this.threadPoolName());
        }
    }

    void cancelExecution() {
        if (this.scheduler != null) {
            try {
                this.scheduler.cancel();
            }
            finally {
                this.scheduler = null;
            }
        }
    }

    class MonitoringExecution
    extends AbstractRunnable
    implements Closeable {
        private final Semaphore semaphore = new Semaphore(1);

        MonitoringExecution() {
        }

        public void doRun() {
            if (!MonitoringService.this.shouldScheduleExecution()) {
                MonitoringService.this.logger.debug("monitoring execution is skipped");
                return;
            }
            if (!this.semaphore.tryAcquire()) {
                MonitoringService.this.logger.debug("monitoring execution is skipped until previous execution terminated");
                return;
            }
            MonitoringService.this.threadPool.executor(MonitoringService.this.threadPoolName()).submit((Runnable)new AbstractRunnable(){

                protected void doRun() throws Exception {
                    long timestamp = System.currentTimeMillis();
                    long intervalInMillis = MonitoringService.this.interval.getMillis();
                    ClusterState clusterState = MonitoringService.this.clusterService.state();
                    ArrayList<MonitoringDoc> results = new ArrayList<MonitoringDoc>();
                    for (Collector collector : MonitoringService.this.collectors) {
                        if (!MonitoringService.this.isStarted()) {
                            return;
                        }
                        try {
                            Collection<MonitoringDoc> result = collector.collect(timestamp, intervalInMillis, clusterState);
                            if (result == null) continue;
                            results.addAll(result);
                        }
                        catch (Exception e) {
                            MonitoringService.this.logger.warn(() -> new ParameterizedMessage("monitoring collector [{}] failed to collect data", (Object)collector.name()), (Throwable)e);
                        }
                    }
                    if (MonitoringService.this.shouldScheduleExecution()) {
                        MonitoringService.this.exporters.export(results, (ActionListener<Void>)ActionListener.wrap(r -> MonitoringExecution.this.semaphore.release(), this::onFailure));
                    } else {
                        MonitoringExecution.this.semaphore.release();
                    }
                }

                public void onFailure(Exception e) {
                    MonitoringService.this.logger.warn("monitoring execution failed", (Throwable)e);
                    MonitoringExecution.this.semaphore.release();
                }

                public void onRejection(Exception e) {
                    MonitoringService.this.logger.warn("monitoring execution has been rejected", (Throwable)e);
                    MonitoringExecution.this.semaphore.release();
                }
            });
        }

        public void onFailure(Exception e) {
            MonitoringService.this.logger.warn("monitoring execution failed", (Throwable)e);
        }

        @Override
        public void close() {
            try {
                if (!this.semaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                    MonitoringService.this.logger.warn("monitoring execution did not complete after waiting for 10s");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

