/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.local;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalBulk;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class LocalExporter
extends Exporter
implements ClusterStateListener,
CleanerService.Listener {
    private static final Logger logger = Loggers.getLogger(LocalExporter.class);
    public static final String TYPE = "local";
    private final Client client;
    private final ClusterService clusterService;
    private final XPackLicenseState licenseState;
    private final CleanerService cleanerService;
    private final boolean useIngest;
    private final DateTimeFormatter dateTimeFormatter;
    private final List<String> clusterAlertBlacklist;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final AtomicBoolean installingSomething = new AtomicBoolean(false);
    private final AtomicBoolean waitedForSetup = new AtomicBoolean(false);
    private final AtomicBoolean watcherSetup = new AtomicBoolean(false);

    public LocalExporter(Exporter.Config config, Client client, CleanerService cleanerService) {
        super(config);
        this.client = client;
        this.clusterService = config.clusterService();
        this.licenseState = config.licenseState();
        this.useIngest = (Boolean)USE_INGEST_PIPELINE_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        this.clusterAlertBlacklist = ClusterAlertsUtil.getClusterAlertsBlacklist(config);
        this.cleanerService = cleanerService;
        this.dateTimeFormatter = LocalExporter.dateTimeFormatter(config);
        this.clusterService.addListener((ClusterStateListener)this);
        cleanerService.add(this);
        this.licenseState.addListener(this::licenseChanged);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (this.state.get() == State.INITIALIZED) {
            this.resolveBulk(event.state(), true);
        }
    }

    private void licenseChanged() {
        this.watcherSetup.set(false);
    }

    boolean isExporterReady() {
        boolean running = this.resolveBulk(this.clusterService.state(), false) != null;
        return running && !this.installingSomething.get();
    }

    @Override
    public LocalBulk openBulk() {
        if (this.state.get() != State.RUNNING) {
            return null;
        }
        return this.resolveBulk(this.clusterService.state(), false);
    }

    @Override
    public void doClose() {
        if (this.state.getAndSet(State.TERMINATED) != State.TERMINATED) {
            logger.trace("stopped");
            this.clusterService.removeListener((ClusterStateListener)this);
            this.cleanerService.remove(this);
            this.licenseState.removeListener(this::licenseChanged);
        }
    }

    LocalBulk resolveBulk(ClusterState clusterState, boolean clusterStateChange) {
        if (this.clusterService.localNode() == null || clusterState == null) {
            return null;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("waiting until gateway has recovered from disk");
            return null;
        }
        Map<String, String> templates = Arrays.stream(MonitoringTemplateUtils.TEMPLATE_IDS).collect(Collectors.toMap(MonitoringTemplateUtils::templateName, MonitoringTemplateUtils::loadTemplate));
        boolean setup = true;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            setup = this.setupIfElectedMaster(clusterState, templates, clusterStateChange);
        } else if (!this.setupIfNotElectedMaster(clusterState, templates.keySet())) {
            if (this.waitedForSetup.getAndSet(true)) {
                logger.info("waiting for elected master node [{}] to setup local exporter [{}] (does it have x-pack installed?)", (Object)this.clusterService.state().nodes().getMasterNode(), (Object)this.config.name());
            }
            setup = false;
        }
        if (!setup) {
            return null;
        }
        if (this.state.compareAndSet(State.INITIALIZED, State.RUNNING)) {
            logger.debug("started");
            this.clusterService.removeListener((ClusterStateListener)this);
        }
        return new LocalBulk(this.name(), logger, this.client, this.dateTimeFormatter, this.useIngest);
    }

    private boolean setupIfNotElectedMaster(ClusterState clusterState, Set<String> templates) {
        for (String template : templates) {
            if (this.hasTemplate(clusterState, template)) continue;
            logger.debug("monitoring index template [{}] does not exist, so service cannot start (waiting on master)", (Object)template);
            return false;
        }
        if (this.useIngest) {
            for (String pipelineId : MonitoringTemplateUtils.PIPELINE_IDS) {
                if (this.hasIngestPipeline(clusterState, pipelineId)) continue;
                logger.debug("monitoring ingest pipeline [{}] does not exist, so service cannot start (waiting on master)", (Object)MonitoringTemplateUtils.pipelineName((String)pipelineId));
                return false;
            }
        }
        logger.trace("monitoring index templates and pipelines are installed, service can start");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupIfElectedMaster(ClusterState clusterState, Map<String, String> templates, boolean clusterStateChange) {
        if (clusterState.blocks().hasGlobalBlock(ClusterBlockLevel.METADATA_WRITE)) {
            logger.debug("waiting until metadata writes are unblocked");
            return false;
        }
        if (this.installingSomething.get()) {
            logger.trace("already installing something, waiting for install to complete");
            return false;
        }
        ArrayList<Runnable> asyncActions = new ArrayList<Runnable>();
        AtomicInteger pendingResponses = new AtomicInteger(0);
        List missingTemplates = templates.entrySet().stream().filter(e -> !this.hasTemplate(clusterState, (String)e.getKey())).collect(Collectors.toList());
        if (!missingTemplates.isEmpty()) {
            logger.debug(() -> new ParameterizedMessage("template {} not found", missingTemplates.stream().map(Map.Entry::getKey).collect(Collectors.toList())));
            for (Object template : missingTemplates) {
                asyncActions.add(() -> this.lambda$setupIfElectedMaster$2((Map.Entry)template, pendingResponses));
            }
        }
        if (this.useIngest) {
            List missingPipelines = Arrays.stream(MonitoringTemplateUtils.PIPELINE_IDS).filter(id -> !this.hasIngestPipeline(clusterState, (String)id)).collect(Collectors.toList());
            if (!missingPipelines.isEmpty()) {
                for (String pipelineId : missingPipelines) {
                    String pipelineName = MonitoringTemplateUtils.pipelineName((String)pipelineId);
                    logger.debug("pipeline [{}] not found", (Object)pipelineName);
                    asyncActions.add(() -> this.putIngestPipeline(pipelineId, new ResponseActionListener<AcknowledgedResponse>("pipeline", pipelineName, pendingResponses)));
                }
            } else {
                logger.trace("all pipelines found");
            }
        }
        if (this.state.get() == State.RUNNING && !clusterStateChange && this.canUseWatcher()) {
            boolean indexExists;
            IndexRoutingTable watches = clusterState.routingTable().index(".watches");
            boolean bl = indexExists = watches != null && watches.allPrimaryShardsActive();
            if (watches != null && !watches.allPrimaryShardsActive()) {
                logger.trace("cannot manage cluster alerts because [.watches] index is not allocated");
            } else if ((watches == null || indexExists) && this.watcherSetup.compareAndSet(false, true)) {
                this.getClusterAlertsInstallationAsyncActions(indexExists, asyncActions, pendingResponses);
            }
        }
        if (asyncActions.size() > 0) {
            if (!this.installingSomething.compareAndSet(false, true)) return false;
            pendingResponses.set(asyncActions.size());
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring");){
                asyncActions.forEach(Runnable::run);
                return true;
            }
        } else {
            logger.debug("monitoring index templates and pipelines are installed on master node, service can start");
        }
        return true;
    }

    private void responseReceived(AtomicInteger pendingResponses, boolean success, @Nullable AtomicBoolean setup) {
        if (setup != null && !success) {
            setup.set(false);
        }
        if (pendingResponses.decrementAndGet() <= 0) {
            logger.trace("all installation requests returned a response");
            if (!this.installingSomething.compareAndSet(true, false)) {
                throw new IllegalStateException("could not reset installing flag to false");
            }
        }
    }

    private boolean hasIngestPipeline(ClusterState clusterState, String pipelineId) {
        String pipelineName = MonitoringTemplateUtils.pipelineName((String)pipelineId);
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        if (ingestMetadata != null) {
            PipelineConfiguration pipeline = (PipelineConfiguration)ingestMetadata.getPipelines().get(pipelineName);
            return pipeline != null && this.hasValidVersion(pipeline.getConfigAsMap().get("version"), MonitoringTemplateUtils.LAST_UPDATED_VERSION);
        }
        return false;
    }

    private void putIngestPipeline(String pipelineId, ActionListener<AcknowledgedResponse> listener) {
        String pipelineName = MonitoringTemplateUtils.pipelineName((String)pipelineId);
        BytesReference pipeline = BytesReference.bytes((XContentBuilder)MonitoringTemplateUtils.loadPipeline((String)pipelineId, (XContentType)XContentType.JSON));
        PutPipelineRequest request = new PutPipelineRequest(pipelineName, pipeline, XContentType.JSON);
        logger.debug("installing ingest pipeline [{}]", (Object)pipelineName);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (ActionRequest)request, listener, (arg_0, arg_1) -> ((ClusterAdminClient)this.client.admin().cluster()).putPipeline(arg_0, arg_1));
    }

    private boolean hasTemplate(ClusterState clusterState, String templateName) {
        IndexTemplateMetaData template = (IndexTemplateMetaData)clusterState.getMetaData().getTemplates().get((Object)templateName);
        return template != null && this.hasValidVersion(template.getVersion(), MonitoringTemplateUtils.LAST_UPDATED_VERSION);
    }

    private void putTemplate(String template, String source, ActionListener<AcknowledgedResponse> listener) {
        logger.debug("installing template [{}]", (Object)template);
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(template).source(source, XContentType.JSON);
        assert (!Thread.currentThread().isInterrupted()) : "current thread has been interrupted before putting index template!!!";
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (ActionRequest)request, listener, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
    }

    private boolean hasValidVersion(Object version, long minimumVersion) {
        return version instanceof Number && (long)((Number)version).intValue() >= minimumVersion;
    }

    private void getClusterAlertsInstallationAsyncActions(boolean indexExists, List<Runnable> asyncActions, AtomicInteger pendingResponses) {
        XPackClient xpackClient = new XPackClient(this.client);
        WatcherClient watcher = xpackClient.watcher();
        boolean canAddWatches = this.licenseState.isMonitoringClusterAlertsAllowed();
        for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
            boolean addWatch;
            String uniqueWatchId = ClusterAlertsUtil.createUniqueWatchId(this.clusterService, watchId);
            boolean bl = addWatch = canAddWatches && !this.clusterAlertBlacklist.contains(watchId);
            if (indexExists) {
                if (addWatch) {
                    logger.trace("checking monitoring watch [{}]", (Object)uniqueWatchId);
                    asyncActions.add(() -> watcher.getWatch(new GetWatchRequest(uniqueWatchId), (ActionListener)new GetAndPutWatchResponseActionListener(watcher, watchId, uniqueWatchId, pendingResponses)));
                    continue;
                }
                logger.trace("pruning monitoring watch [{}]", (Object)uniqueWatchId);
                asyncActions.add(() -> watcher.deleteWatch(new DeleteWatchRequest(uniqueWatchId), new ResponseActionListener("watch", uniqueWatchId, pendingResponses)));
                continue;
            }
            if (!addWatch) continue;
            asyncActions.add(() -> this.putWatch(watcher, watchId, uniqueWatchId, pendingResponses));
        }
    }

    private void putWatch(WatcherClient watcher, String watchId, String uniqueWatchId, AtomicInteger pendingResponses) {
        String watch = ClusterAlertsUtil.loadWatch(this.clusterService, watchId);
        logger.trace("adding monitoring watch [{}]", (Object)uniqueWatchId);
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (ActionRequest)new PutWatchRequest(uniqueWatchId, (BytesReference)new BytesArray(watch), XContentType.JSON), new ResponseActionListener("watch", uniqueWatchId, pendingResponses, this.watcherSetup), (arg_0, arg_1) -> ((WatcherClient)watcher).putWatch(arg_0, arg_1));
    }

    private boolean canUseWatcher() {
        return (Boolean)XPackSettings.WATCHER_ENABLED.get(this.config.settings()) != false && (Boolean)CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(this.config.name()).get(this.config.settings()) != false;
    }

    @Override
    public void onCleanUpIndices(TimeValue retention) {
        if (this.state.get() != State.RUNNING) {
            logger.debug("exporter not ready");
            return;
        }
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            DateTime expiration = new DateTime(DateTimeZone.UTC).minus(retention.millis());
            logger.debug("cleaning indices [expiration={}, retention={}]", (Object)expiration, (Object)retention);
            ClusterState clusterState = this.clusterService.state();
            if (clusterState != null) {
                String[] stringArray;
                long expirationTimeMillis = expiration.getMillis();
                long currentTimeMillis = System.currentTimeMillis();
                boolean cleanUpWatcherHistory = (Boolean)this.clusterService.getClusterSettings().get(Monitoring.CLEAN_WATCHER_HISTORY);
                if (cleanUpWatcherHistory) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = ".monitoring-*";
                    stringArray2[1] = ".marvel-*";
                    stringArray = stringArray2;
                    stringArray2[2] = ".watcher-history*";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = ".monitoring-*";
                    stringArray = stringArray3;
                    stringArray3[1] = ".marvel-*";
                }
                String[] indexPatterns = stringArray;
                Set currents = MonitoredSystem.allSystems().map(s -> MonitoringTemplateUtils.indexName((DateTimeFormatter)this.dateTimeFormatter, (MonitoredSystem)s, (long)currentTimeMillis)).collect(Collectors.toSet());
                currents.add(".monitoring-alerts-6");
                HashSet<String> indices = new HashSet<String>();
                for (ObjectObjectCursor index : clusterState.getMetaData().indices()) {
                    long creationDate;
                    String indexName = (String)index.key;
                    if (!Regex.simpleMatch((String[])indexPatterns, (String)indexName) || currents.contains(indexName) || (creationDate = ((IndexMetaData)index.value).getCreationDate()) > expirationTimeMillis) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("detected expired index [name={}, created={}, expired={}]", (Object)indexName, (Object)new DateTime(creationDate, DateTimeZone.UTC), (Object)expiration);
                    }
                    indices.add(indexName);
                }
                if (!indices.isEmpty()) {
                    logger.info("cleaning up [{}] old indices", (Object)indices.size());
                    this.deleteIndices(indices);
                } else {
                    logger.debug("no old indices found for clean up");
                }
            }
        }
    }

    private void deleteIndices(final Set<String> indices) {
        logger.trace("deleting {} indices: [{}]", (Object)indices.size(), (Object)Strings.collectionToCommaDelimitedString(indices));
        DeleteIndexRequest request = new DeleteIndexRequest(indices.toArray(new String[indices.size()]));
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"monitoring", (ActionRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                if (response.isAcknowledged()) {
                    logger.debug("{} indices deleted", (Object)indices.size());
                } else {
                    logger.warn("deletion of {} indices wasn't acknowledged", (Object)indices.size());
                }
            }

            public void onFailure(Exception e) {
                logger.error("failed to delete indices", (Throwable)e);
            }
        }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).delete(arg_0, arg_1));
    }

    private /* synthetic */ void lambda$setupIfElectedMaster$2(Map.Entry template, AtomicInteger pendingResponses) {
        this.putTemplate((String)template.getKey(), (String)template.getValue(), new ResponseActionListener<AcknowledgedResponse>("template", (String)template.getKey(), pendingResponses));
    }

    private class GetAndPutWatchResponseActionListener
    implements ActionListener<GetWatchResponse> {
        private final WatcherClient watcher;
        private final String watchId;
        private final String uniqueWatchId;
        private final AtomicInteger countDown;

        private GetAndPutWatchResponseActionListener(WatcherClient watcher, String watchId, String uniqueWatchId, AtomicInteger countDown) {
            this.watcher = Objects.requireNonNull(watcher);
            this.watchId = Objects.requireNonNull(watchId);
            this.uniqueWatchId = Objects.requireNonNull(uniqueWatchId);
            this.countDown = Objects.requireNonNull(countDown);
        }

        public void onResponse(GetWatchResponse response) {
            if (response.isFound() && LocalExporter.this.hasValidVersion(response.getSource().getValue("metadata.xpack.version_created"), ClusterAlertsUtil.LAST_UPDATED_VERSION)) {
                logger.trace("found monitoring watch [{}]", (Object)this.uniqueWatchId);
                LocalExporter.this.responseReceived(this.countDown, true, LocalExporter.this.watcherSetup);
            } else {
                LocalExporter.this.putWatch(this.watcher, this.watchId, this.uniqueWatchId, this.countDown);
            }
        }

        public void onFailure(Exception e) {
            LocalExporter.this.responseReceived(this.countDown, false, LocalExporter.this.watcherSetup);
            if (!(e instanceof IndexNotFoundException)) {
                logger.error(() -> new ParameterizedMessage("failed to get monitoring watch [{}]", (Object)this.uniqueWatchId), (Throwable)e);
            }
        }
    }

    private class ResponseActionListener<Response>
    implements ActionListener<Response> {
        private final String type;
        private final String name;
        private final AtomicInteger countDown;
        private final AtomicBoolean setup;

        private ResponseActionListener(String type, String name, AtomicInteger countDown) {
            this(type, name, countDown, (AtomicBoolean)null);
        }

        private ResponseActionListener(String type, String name, @Nullable AtomicInteger countDown, AtomicBoolean setup) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.countDown = Objects.requireNonNull(countDown);
            this.setup = setup;
        }

        public void onResponse(Response response) {
            LocalExporter.this.responseReceived(this.countDown, true, this.setup);
            if (response instanceof AcknowledgedResponse) {
                if (((AcknowledgedResponse)response).isAcknowledged()) {
                    logger.trace("successfully set monitoring {} [{}]", (Object)this.type, (Object)this.name);
                } else {
                    logger.error("failed to set monitoring {} [{}]", (Object)this.type, (Object)this.name);
                }
            } else {
                logger.trace("successfully handled monitoring {} [{}]", (Object)this.type, (Object)this.name);
            }
        }

        public void onFailure(Exception e) {
            LocalExporter.this.responseReceived(this.countDown, false, this.setup);
            logger.error(() -> new ParameterizedMessage("failed to set monitoring {} [{}]", (Object)this.type, (Object)this.name), (Throwable)e);
        }
    }

    static enum State {
        INITIALIZED,
        RUNNING,
        TERMINATED;

    }
}

