/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.transport.TransportAddress;

public class BoundTransportAddress
implements Streamable {
    private TransportAddress[] boundAddresses;
    private TransportAddress publishAddress;

    BoundTransportAddress() {
    }

    public BoundTransportAddress(TransportAddress[] boundAddresses, TransportAddress publishAddress) {
        if (boundAddresses == null || boundAddresses.length < 1) {
            throw new IllegalArgumentException("at least one bound address must be provided");
        }
        this.boundAddresses = boundAddresses;
        this.publishAddress = publishAddress;
    }

    public TransportAddress[] boundAddresses() {
        return this.boundAddresses;
    }

    public TransportAddress publishAddress() {
        return this.publishAddress;
    }

    public static BoundTransportAddress readBoundTransportAddress(StreamInput in) throws IOException {
        BoundTransportAddress addr = new BoundTransportAddress();
        addr.readFrom(in);
        return addr;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int boundAddressLength = in.readInt();
        this.boundAddresses = new TransportAddress[boundAddressLength];
        for (int i = 0; i < boundAddressLength; ++i) {
            this.boundAddresses[i] = new TransportAddress(in);
        }
        this.publishAddress = new TransportAddress(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.boundAddresses.length);
        for (TransportAddress address : this.boundAddresses) {
            address.writeTo(out);
        }
        this.publishAddress.writeTo(out);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("publish_address {");
        builder.append(this.publishAddress);
        builder.append("}, bound_addresses ");
        boolean firstAdded = false;
        for (TransportAddress address : this.boundAddresses) {
            if (firstAdded) {
                builder.append(", ");
            } else {
                firstAdded = true;
            }
            builder.append("{").append(address).append("}");
        }
        return builder.toString();
    }
}

