/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.hipchat;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.hipchat.ExecutableHipChatAction;
import org.elasticsearch.xpack.watcher.actions.hipchat.HipChatAction;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.hipchat.HipChatAccount;
import org.elasticsearch.xpack.watcher.notification.hipchat.HipChatService;

public class HipChatActionFactory
extends ActionFactory {
    private final TextTemplateEngine templateEngine;
    private final HipChatService hipchatService;

    public HipChatActionFactory(TextTemplateEngine templateEngine, HipChatService hipchatService) {
        super(LogManager.getLogger(ExecutableHipChatAction.class));
        this.templateEngine = templateEngine;
        this.hipchatService = hipchatService;
    }

    public ExecutableHipChatAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        HipChatAction action = HipChatAction.parse(watchId, actionId, parser);
        HipChatAccount account = (HipChatAccount)this.hipchatService.getAccount(action.account);
        account.validateParsedTemplate(watchId, actionId, action.message);
        return new ExecutableHipChatAction(action, this.actionLogger, this.hipchatService, this.templateEngine);
    }
}

