/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.logging;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.watcher.actions.Action;
import org.elasticsearch.xpack.core.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.actions.logging.LoggingAction;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.support.Variables;

public class ExecutableLoggingAction
extends ExecutableAction<LoggingAction> {
    private final Logger textLogger;
    private final TextTemplateEngine templateEngine;

    ExecutableLoggingAction(LoggingAction action, Logger logger, TextTemplateEngine templateEngine) {
        super((Action)action, logger);
        this.textLogger = action.category != null ? LogManager.getLogger((String)action.category) : logger;
        this.templateEngine = templateEngine;
    }

    ExecutableLoggingAction(LoggingAction action, Logger logger, Logger textLogger, TextTemplateEngine templateEngine) {
        super((Action)action, logger);
        this.textLogger = textLogger;
        this.templateEngine = templateEngine;
    }

    Logger textLogger() {
        return this.textLogger;
    }

    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxParamsMap(ctx, payload);
        String loggedText = this.templateEngine.render(((LoggingAction)this.action).text, model);
        if (ctx.simulateAction(actionId)) {
            return new LoggingAction.Result.Simulated(loggedText);
        }
        ((LoggingAction)this.action).level.log(this.textLogger, loggedText);
        return new LoggingAction.Result.Success(loggedText);
    }
}

