/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.common.text;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;

public class TextTemplateEngine
extends AbstractComponent {
    private final ScriptService service;

    public TextTemplateEngine(Settings settings, ScriptService service) {
        super(settings);
        this.service = service;
    }

    public String render(TextTemplate textTemplate, Map<String, Object> model) {
        if (textTemplate == null) {
            return null;
        }
        String template = textTemplate.getTemplate();
        String mediaType = this.compileParams(this.detectContentType(template));
        template = this.trimContentType(textTemplate);
        int indexStartMustacheExpression = template.indexOf("{{");
        if (indexStartMustacheExpression == -1) {
            return template;
        }
        HashMap<String, Object> mergedModel = new HashMap<String, Object>();
        if (textTemplate.getParams() != null) {
            mergedModel.putAll(textTemplate.getParams());
        }
        mergedModel.putAll(model);
        HashMap<String, String> options = null;
        if (textTemplate.getType() == ScriptType.INLINE) {
            options = new HashMap<String, String>();
            if (textTemplate.getScript() != null && textTemplate.getScript().getOptions() != null) {
                options.putAll(textTemplate.getScript().getOptions());
            }
            options.put("content_type", mediaType);
        }
        Script script = new Script(textTemplate.getType(), textTemplate.getType() == ScriptType.STORED ? null : "mustache", template, options, mergedModel);
        TemplateScript.Factory compiledTemplate = (TemplateScript.Factory)this.service.compile(script, Watcher.SCRIPT_TEMPLATE_CONTEXT);
        return compiledTemplate.newInstance(model).execute();
    }

    private String trimContentType(TextTemplate textTemplate) {
        String template = textTemplate.getTemplate();
        if (!template.startsWith("__")) {
            return template;
        }
        int index = template.indexOf("__::", 3);
        if (index >= 0 && index < 12) {
            template = template.length() == 6 ? "" : template.substring(index + 4);
        }
        return template;
    }

    private XContentType detectContentType(String content) {
        int endOfContentName;
        if (content.startsWith("__") && (endOfContentName = content.indexOf("__::", 3)) != -1) {
            return XContentType.fromMediaTypeOrFormat((String)content.substring(2, endOfContentName));
        }
        return null;
    }

    private String compileParams(XContentType contentType) {
        if (contentType == XContentType.JSON) {
            return "application/json";
        }
        return "text/plain";
    }
}

