/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.history;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.watcher.history.HistoryStoreField;
import org.elasticsearch.xpack.core.watcher.history.WatchRecord;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HistoryStore
extends AbstractComponent {
    public static final String DOC_TYPE = "doc";
    private final BulkProcessor bulkProcessor;

    public HistoryStore(Settings settings, BulkProcessor bulkProcessor) {
        super(settings);
        this.bulkProcessor = bulkProcessor;
    }

    public void put(WatchRecord watchRecord) throws Exception {
        String index = HistoryStoreField.getHistoryIndexNameForTime((DateTime)watchRecord.triggerEvent().triggeredTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder);
            request.opType(DocWriteRequest.OpType.CREATE);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            throw Exceptions.ioException((String)"failed to persist watch record [{}]", (Throwable)ioe, (Object[])new Object[]{watchRecord});
        }
    }

    public void forcePut(WatchRecord watchRecord) {
        String index = HistoryStoreField.getHistoryIndexNameForTime((DateTime)watchRecord.triggerEvent().triggeredTime());
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            watchRecord.toXContent(builder, (ToXContent.Params)WatcherParams.HIDE_SECRETS);
            IndexRequest request = new IndexRequest(index, DOC_TYPE, watchRecord.id().value()).source(builder);
            this.bulkProcessor.add(request);
        }
        catch (IOException ioe) {
            WatchRecord wr = watchRecord;
            this.logger.error(() -> new ParameterizedMessage("failed to persist watch record [{}]", (Object)wr), (Throwable)ioe);
        }
    }

    public static boolean validate(ClusterState state) {
        String currentIndex = HistoryStoreField.getHistoryIndexNameForTime((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
        IndexMetaData indexMetaData = WatchStoreUtils.getConcreteIndex(currentIndex, state.metaData());
        return indexMetaData == null || indexMetaData.getState() == IndexMetaData.State.OPEN && state.routingTable().index(indexMetaData.getIndex()).allPrimaryShardsActive();
    }
}

