/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.watch.WatchField;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestAckWatchAction
extends WatcherRestHandler {
    public RestAckWatchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_ack", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/{id}/_ack", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_ack", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_ack/{actions}", (RestHandler)this, RestRequest.Method.POST, "/_watcher/watch/{id}/_ack/{actions}", this.deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_ack/{actions}", (RestHandler)this, RestRequest.Method.PUT, "/_watcher/watch/{id}/_ack/{actions}", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_watcher/watch/{id}/{actions}/_ack", (RestHandler)this, "[POST /_watcher/watch/{id}/{actions}/_ack] is deprecated! Use [POST /_xpack/watcher/watch/{id}/_ack/{actions}] instead.", this.deprecationLogger);
        controller.registerAsDeprecatedHandler(RestRequest.Method.PUT, "/_watcher/watch/{id}/{actions}/_ack", (RestHandler)this, "[PUT /_watcher/watch/{id}/{actions}/_ack] is deprecated! Use [PUT /_xpack/watcher/watch/{id}/_ack/{actions}] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_watcher_ack_watch_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, WatcherClient client) throws IOException {
        AckWatchRequest ackWatchRequest = new AckWatchRequest(request.param("id"), new String[0]);
        String[] actions = request.paramAsStringArray("actions", null);
        if (actions != null) {
            ackWatchRequest.setActionIds(actions);
        }
        ackWatchRequest.masterNodeTimeout(request.paramAsTime("master_timeout", ackWatchRequest.masterNodeTimeout()));
        return channel -> client.ackWatch(ackWatchRequest, (ActionListener)new RestBuilderListener<AckWatchResponse>(channel){

            public RestResponse buildResponse(AckWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(WatchField.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }
}

