/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.time.Clock;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class ScheduleTriggerEvent
extends TriggerEvent {
    private final DateTime scheduledTime;

    public ScheduleTriggerEvent(DateTime triggeredTime, DateTime scheduledTime) {
        this(null, triggeredTime, scheduledTime);
    }

    public ScheduleTriggerEvent(String jobName, DateTime triggeredTime, DateTime scheduledTime) {
        super(jobName, triggeredTime);
        this.scheduledTime = scheduledTime;
        this.data.put(Field.SCHEDULED_TIME.getPreferredName(), scheduledTime);
    }

    public String type() {
        return "schedule";
    }

    public DateTime scheduledTime() {
        return this.scheduledTime;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        WatcherDateTimeUtils.writeDate((String)Field.TRIGGERED_TIME.getPreferredName(), (XContentBuilder)builder, (DateTime)this.triggeredTime);
        WatcherDateTimeUtils.writeDate((String)Field.SCHEDULED_TIME.getPreferredName(), (XContentBuilder)builder, (DateTime)this.scheduledTime);
        return builder.endObject();
    }

    public void recordDataXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("schedule");
        WatcherDateTimeUtils.writeDate((String)Field.SCHEDULED_TIME.getPreferredName(), (XContentBuilder)builder, (DateTime)this.scheduledTime);
        builder.endObject();
    }

    public static ScheduleTriggerEvent parse(XContentParser parser, String watchId, String context, Clock clock) throws IOException {
        XContentParser.Token token;
        DateTime triggeredTime = null;
        DateTime scheduledTime = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Field.TRIGGERED_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    triggeredTime = WatcherDateTimeUtils.parseDateMath((String)currentFieldName, (XContentParser)parser, (DateTimeZone)DateTimeZone.UTC, (Clock)clock);
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] trigger event for [{}] for watch [{}]. failed to parse date field [{}]", (Throwable)pe, new Object[]{"schedule", context, watchId, currentFieldName});
                }
            }
            if (Field.SCHEDULED_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                try {
                    scheduledTime = WatcherDateTimeUtils.parseDateMath((String)currentFieldName, (XContentParser)parser, (DateTimeZone)DateTimeZone.UTC, (Clock)clock);
                    continue;
                }
                catch (ElasticsearchParseException pe) {
                    throw new ElasticsearchParseException("could not parse [{}] trigger event for [{}] for watch [{}]. failed to parse date field [{}]", (Throwable)pe, new Object[]{"schedule", context, watchId, currentFieldName});
                }
            }
            throw new ElasticsearchParseException("could not parse trigger event for [{}] for watch [{}]. unexpected token [{}]", new Object[]{context, watchId, token});
        }
        assert (triggeredTime != null && scheduledTime != null);
        return new ScheduleTriggerEvent(triggeredTime, scheduledTime);
    }

    static interface Field
    extends TriggerEvent.Field {
        public static final ParseField SCHEDULED_TIME = new ParseField("scheduled_time", new String[0]);
    }
}

