/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureUtils;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;

public final class GrokPatternCreator {
    private static final Map<Character, Boolean> PUNCTUATION_OR_SPACE_NEEDS_ESCAPING;
    private static final String PREFACE = "preface";
    private static final String VALUE = "value";
    private static final String EPILOGUE = "epilogue";
    private static final List<FullMatchGrokPatternCandidate> FULL_MATCH_GROK_PATTERNS;
    private static final List<GrokPatternCandidate> ORDERED_CANDIDATE_GROK_PATTERNS;
    private final List<String> explanation;
    private final Collection<String> sampleMessages;
    private final Map<String, Object> mappings;
    private final Map<String, FieldStats> fieldStats;
    private final Map<String, Integer> fieldNameCountStore = new HashMap<String, Integer>();
    private final StringBuilder overallGrokPatternBuilder = new StringBuilder();
    private final TimeoutChecker timeoutChecker;

    public GrokPatternCreator(List<String> explanation, Collection<String> sampleMessages, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker) {
        this.explanation = explanation;
        this.sampleMessages = Collections.unmodifiableCollection(sampleMessages);
        this.mappings = mappings;
        this.fieldStats = fieldStats;
        this.timeoutChecker = timeoutChecker;
    }

    public Tuple<String, String> findFullLineGrokPattern(String timestampField) {
        for (FullMatchGrokPatternCandidate candidate : FULL_MATCH_GROK_PATTERNS) {
            if (timestampField != null && !timestampField.equals(candidate.getTimeField()) || !candidate.matchesAll(this.sampleMessages, this.timeoutChecker)) continue;
            return candidate.processMatch(this.explanation, this.sampleMessages, this.mappings, this.fieldStats, this.timeoutChecker);
        }
        return null;
    }

    public void validateFullLineGrokPattern(String grokPattern, String timestampField) {
        FullMatchGrokPatternCandidate candidate = FullMatchGrokPatternCandidate.fromGrokPattern(grokPattern, timestampField);
        if (!candidate.matchesAll(this.sampleMessages, this.timeoutChecker)) {
            throw new IllegalArgumentException("Supplied Grok pattern [" + grokPattern + "] does not match sample messages");
        }
        candidate.processMatch(this.explanation, this.sampleMessages, this.mappings, this.fieldStats, this.timeoutChecker);
    }

    public String createGrokPatternFromExamples(String seedPatternName, String seedFieldName) {
        this.overallGrokPatternBuilder.setLength(0);
        NoMappingGrokPatternCandidate seedCandidate = new NoMappingGrokPatternCandidate(seedPatternName, seedFieldName);
        this.processCandidateAndSplit(seedCandidate, true, this.sampleMessages, false, 0, false, 0);
        return this.overallGrokPatternBuilder.toString().replace("\t", "\\t").replace("\n", "\\n");
    }

    StringBuilder getOverallGrokPatternBuilder() {
        return this.overallGrokPatternBuilder;
    }

    private void processCandidateAndSplit(GrokPatternCandidate chosenPattern, boolean isLast, Collection<String> snippets, boolean ignoreKeyValueCandidateLeft, int ignoreValueOnlyCandidatesLeft, boolean ignoreKeyValueCandidateRight, int ignoreValueOnlyCandidatesRight) {
        ArrayList<String> prefaces = new ArrayList<String>();
        ArrayList<String> epilogues = new ArrayList<String>();
        String patternBuilderContent = chosenPattern.processCaptures(this.fieldNameCountStore, snippets, prefaces, epilogues, this.mappings, this.fieldStats, this.timeoutChecker);
        this.appendBestGrokMatchForStrings(false, prefaces, ignoreKeyValueCandidateLeft, ignoreValueOnlyCandidatesLeft);
        this.overallGrokPatternBuilder.append(patternBuilderContent);
        this.appendBestGrokMatchForStrings(isLast, epilogues, ignoreKeyValueCandidateRight, ignoreValueOnlyCandidatesRight);
    }

    void appendBestGrokMatchForStrings(boolean isLast, Collection<String> snippets, boolean ignoreKeyValueCandidate, int ignoreValueOnlyCandidates) {
        snippets = this.adjustForPunctuation(snippets);
        GrokPatternCandidate bestCandidate = null;
        if (!snippets.isEmpty()) {
            KeyValueGrokPatternCandidate kvCandidate = new KeyValueGrokPatternCandidate(this.explanation);
            if (!ignoreKeyValueCandidate && kvCandidate.matchesAll(snippets)) {
                bestCandidate = kvCandidate;
            } else {
                ignoreKeyValueCandidate = true;
                for (GrokPatternCandidate candidate : ORDERED_CANDIDATE_GROK_PATTERNS.subList(ignoreValueOnlyCandidates, ORDERED_CANDIDATE_GROK_PATTERNS.size())) {
                    if (candidate.matchesAll(snippets)) {
                        bestCandidate = candidate;
                        break;
                    }
                    ++ignoreValueOnlyCandidates;
                }
            }
        }
        if (bestCandidate == null) {
            if (isLast) {
                this.finalizeGrokPattern(snippets);
            } else {
                this.addIntermediateRegex(snippets);
            }
        } else {
            this.processCandidateAndSplit(bestCandidate, isLast, snippets, true, ignoreValueOnlyCandidates + (ignoreKeyValueCandidate ? 1 : 0), ignoreKeyValueCandidate, ignoreValueOnlyCandidates);
        }
    }

    Collection<String> adjustForPunctuation(Collection<String> snippets) {
        assert (!snippets.isEmpty());
        StringBuilder commonInitialPunctuation = new StringBuilder();
        for (String snippet2 : snippets) {
            char ch;
            int index;
            if (commonInitialPunctuation.length() == 0) {
                for (index = 0; index < snippet2.length() && PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch = snippet2.charAt(index))) != null; ++index) {
                    commonInitialPunctuation.append(ch);
                }
            } else {
                if (commonInitialPunctuation.length() > snippet2.length()) {
                    commonInitialPunctuation.delete(snippet2.length(), commonInitialPunctuation.length());
                }
                for (index = 0; index < commonInitialPunctuation.length(); ++index) {
                    ch = snippet2.charAt(index);
                    if (ch == commonInitialPunctuation.charAt(index)) continue;
                    commonInitialPunctuation.delete(index, commonInitialPunctuation.length());
                    break;
                }
            }
            if (commonInitialPunctuation.length() > 1) continue;
            return snippets;
        }
        int numLiteralCharacters = commonInitialPunctuation.length() - 1;
        for (int index = 0; index < numLiteralCharacters; ++index) {
            char ch = commonInitialPunctuation.charAt(index);
            if (PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.getOrDefault(Character.valueOf(ch), false).booleanValue()) {
                this.overallGrokPatternBuilder.append('\\');
            }
            this.overallGrokPatternBuilder.append(ch);
        }
        return snippets.stream().map(snippet -> snippet.substring(numLiteralCharacters)).collect(Collectors.toList());
    }

    static String buildFieldName(Map<String, Integer> fieldNameCountStore, String fieldName) {
        Integer numberSeen = fieldNameCountStore.compute(fieldName, (k, v) -> 1 + (v == null ? 0 : v));
        return numberSeen > 1 ? fieldName + numberSeen : fieldName;
    }

    private void addIntermediateRegex(Collection<String> snippets) {
        GrokPatternCreator.addIntermediateRegex(this.overallGrokPatternBuilder, snippets);
    }

    public static void addIntermediateRegex(StringBuilder patternBuilder, Collection<String> snippets) {
        if (snippets.isEmpty()) {
            return;
        }
        List<String> others = new ArrayList<String>(snippets);
        String driver = (String)others.remove(others.size() - 1);
        boolean wildcardRequiredIfNonMatchFound = true;
        for (int i = 0; i < driver.length(); ++i) {
            char ch = driver.charAt(i);
            Boolean punctuationOrSpaceNeedsEscaping = PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch));
            if (punctuationOrSpaceNeedsEscaping != null && others.stream().allMatch(other -> other.indexOf(ch) >= 0)) {
                if (wildcardRequiredIfNonMatchFound && others.stream().anyMatch(other -> other.indexOf(ch) > 0)) {
                    patternBuilder.append(".*?");
                }
                if (punctuationOrSpaceNeedsEscaping.booleanValue()) {
                    patternBuilder.append('\\');
                }
                patternBuilder.append(ch);
                wildcardRequiredIfNonMatchFound = true;
                others = others.stream().map(other -> other.substring(other.indexOf(ch) + 1)).collect(Collectors.toList());
                continue;
            }
            if (!wildcardRequiredIfNonMatchFound) continue;
            patternBuilder.append(".*?");
            wildcardRequiredIfNonMatchFound = false;
        }
        if (wildcardRequiredIfNonMatchFound && others.stream().anyMatch(s -> !s.isEmpty())) {
            patternBuilder.append(".*?");
        }
    }

    private void finalizeGrokPattern(Collection<String> snippets) {
        if (snippets.stream().allMatch(String::isEmpty)) {
            return;
        }
        ArrayList<String> others = new ArrayList<String>(snippets);
        String driver = (String)others.remove(others.size() - 1);
        for (int i = 0; i < driver.length(); ++i) {
            char ch = driver.charAt(i);
            int driverIndex = i;
            Boolean punctuationOrSpaceNeedsEscaping = PUNCTUATION_OR_SPACE_NEEDS_ESCAPING.get(Character.valueOf(ch));
            if (punctuationOrSpaceNeedsEscaping == null || !others.stream().allMatch(other -> other.length() > driverIndex && other.charAt(driverIndex) == ch)) break;
            if (punctuationOrSpaceNeedsEscaping.booleanValue()) {
                this.overallGrokPatternBuilder.append('\\');
            }
            this.overallGrokPatternBuilder.append(ch);
            if (i != driver.length() - 1) continue;
            if (!others.stream().allMatch(driver::equals)) continue;
            return;
        }
        this.overallGrokPatternBuilder.append(".*");
    }

    static {
        HashMap punctuationOrSpaceNeedsEscaping = new HashMap();
        String punctuationAndSpaceCharacters = "\"'`\u2018\u2019\u201c\u201d#@%=\\/|~:;,<>()[]{}\u00ab\u00bb^$*\u00bf?\u00a1!\u00a7\u00b6 \t\n";
        String punctuationThatNeedsEscaping = "\\|()[]{}^$*?";
        punctuationAndSpaceCharacters.chars().forEach(c -> punctuationOrSpaceNeedsEscaping.put(Character.valueOf((char)c), punctuationThatNeedsEscaping.indexOf(c) >= 0));
        PUNCTUATION_OR_SPACE_NEEDS_ESCAPING = Collections.unmodifiableMap(punctuationOrSpaceNeedsEscaping);
        FULL_MATCH_GROK_PATTERNS = Arrays.asList(FullMatchGrokPatternCandidate.fromGrokPatternName("BACULA_LOGLINE", "bts"), FullMatchGrokPatternCandidate.fromGrokPatternName("CATALINALOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("COMBINEDAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("COMMONAPACHELOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("ELB_ACCESS_LOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("HAPROXYHTTP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("HAPROXYTCP", "syslog_timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("HTTPD20_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("HTTPD24_ERRORLOG", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("NAGIOSLOGLINE", "nagios_epoch"), FullMatchGrokPatternCandidate.fromGrokPatternName("NETSCREENSESSIONLOG", "date"), FullMatchGrokPatternCandidate.fromGrokPatternName("RAILS3", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("RUBY_LOGGER", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("SHOREWALL", "timestamp"), FullMatchGrokPatternCandidate.fromGrokPatternName("TOMCATLOG", "timestamp"));
        ORDERED_CANDIDATE_GROK_PATTERNS = Arrays.asList(new ValueOnlyGrokPatternCandidate("TOMCAT_DATESTAMP", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("TIMESTAMP_ISO8601", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC822", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("DATESTAMP_RFC2822", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("DATESTAMP_OTHER", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("DATESTAMP_EVENTLOG", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("SYSLOGTIMESTAMP", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("HTTPDATE", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("CATALINA_DATESTAMP", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("CISCOTIMESTAMP", "date", "extra_timestamp"), new ValueOnlyGrokPatternCandidate("LOGLEVEL", "keyword", "loglevel"), new ValueOnlyGrokPatternCandidate("URI", "keyword", "uri"), new ValueOnlyGrokPatternCandidate("UUID", "keyword", "uuid"), new ValueOnlyGrokPatternCandidate("MAC", "keyword", "macaddress"), new ValueOnlyGrokPatternCandidate("PATH", "keyword", "path", "(?<!\\w)", "(?!\\w)"), new ValueOnlyGrokPatternCandidate("EMAILADDRESS", "keyword", "email"), new ValueOnlyGrokPatternCandidate("IP", "ip", "ipaddress"), new ValueOnlyGrokPatternCandidate("DATE", "date", "date"), new ValueOnlyGrokPatternCandidate("TIME", "date", "time"), new ValueOnlyGrokPatternCandidate("QUOTEDSTRING", "keyword", "field", "", ""), new ValueOnlyGrokPatternCandidate("INT", "long", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)"), new ValueOnlyGrokPatternCandidate("NUMBER", "double", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\d)"), new ValueOnlyGrokPatternCandidate("BASE16NUM", "keyword", "field", "(?<![\\w.+-])", "(?![\\w+-]|\\.\\w)"));
    }

    static class FullMatchGrokPatternCandidate {
        private final String grokPattern;
        private final String timeField;
        private final Grok grok;

        static FullMatchGrokPatternCandidate fromGrokPatternName(String grokPatternName, String timeField) {
            return new FullMatchGrokPatternCandidate("%{" + grokPatternName + "}", timeField);
        }

        static FullMatchGrokPatternCandidate fromGrokPattern(String grokPattern, String timeField) {
            return new FullMatchGrokPatternCandidate(grokPattern, timeField);
        }

        private FullMatchGrokPatternCandidate(String grokPattern, String timeField) {
            this.grokPattern = grokPattern;
            this.timeField = timeField;
            this.grok = new Grok(Grok.getBuiltinPatterns(), grokPattern);
        }

        public String getTimeField() {
            return this.timeField;
        }

        public boolean matchesAll(Collection<String> sampleMessages, TimeoutChecker timeoutChecker) {
            for (String sampleMessage : sampleMessages) {
                if (!this.grok.match(sampleMessage)) {
                    return false;
                }
                timeoutChecker.check("full message Grok pattern matching");
            }
            return true;
        }

        public Tuple<String, String> processMatch(List<String> explanation, Collection<String> sampleMessages, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker) {
            explanation.add("A full message Grok pattern [" + this.grokPattern.substring(2, this.grokPattern.length() - 1) + "] looks appropriate");
            if (mappings != null || fieldStats != null) {
                HashMap<String, Collection> valuesPerField = new HashMap<String, Collection>();
                for (String string : sampleMessages) {
                    Map captures = this.grok.captures(string);
                    if (captures == null) {
                        throw new IllegalStateException("[" + this.grokPattern + "] does not match snippet [" + string + "]");
                    }
                    for (Map.Entry capture : captures.entrySet()) {
                        String fieldName = (String)capture.getKey();
                        String fieldValue = capture.getValue().toString();
                        valuesPerField.compute(fieldName, (k, v) -> {
                            if (v == null) {
                                return new ArrayList<String>(Collections.singletonList(fieldValue));
                            }
                            v.add(fieldValue);
                            return v;
                        });
                    }
                    timeoutChecker.check("full message Grok pattern field extraction");
                }
                for (Map.Entry entry : valuesPerField.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    if (mappings != null && !fieldName.equals(this.timeField)) {
                        mappings.put(fieldName, FileStructureUtils.guessScalarMapping(explanation, fieldName, (Collection)entry.getValue()));
                        timeoutChecker.check("mapping determination");
                    }
                    if (fieldStats == null) continue;
                    fieldStats.put(fieldName, FileStructureUtils.calculateFieldStats((Collection)entry.getValue(), timeoutChecker));
                }
            }
            return new Tuple((Object)this.timeField, (Object)this.grokPattern);
        }
    }

    static class NoMappingGrokPatternCandidate
    extends ValueOnlyGrokPatternCandidate {
        NoMappingGrokPatternCandidate(String grokPatternName, String fieldName) {
            super(grokPatternName, null, fieldName);
        }

        @Override
        public String processCaptures(Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker) {
            return super.processCaptures(fieldNameCountStore, snippets, prefaces, epilogues, null, fieldStats, timeoutChecker);
        }
    }

    static class KeyValueGrokPatternCandidate
    implements GrokPatternCandidate {
        private static final Pattern kvFinder = Pattern.compile("\\b(\\w+)=[\\w.-]+");
        private final List<String> explanation;
        private String fieldName;

        KeyValueGrokPatternCandidate(List<String> explanation) {
            this.explanation = explanation;
        }

        @Override
        public boolean matchesAll(Collection<String> snippets) {
            LinkedHashSet<String> candidateNames = new LinkedHashSet<String>();
            boolean isFirst = true;
            for (String snippet : snippets) {
                if (isFirst) {
                    Matcher matcher = kvFinder.matcher(snippet);
                    while (matcher.find()) {
                        candidateNames.add(matcher.group(1));
                    }
                    isFirst = false;
                } else {
                    candidateNames.removeIf(candidateName -> !Pattern.compile("\\b" + candidateName + "=[\\w.-]+").matcher(snippet).find());
                }
                if (!candidateNames.isEmpty()) continue;
                break;
            }
            return (this.fieldName = (String)candidateNames.stream().findFirst().orElse(null)) != null;
        }

        @Override
        public String processCaptures(Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker) {
            if (this.fieldName == null) {
                throw new IllegalStateException("Cannot process KV matches until a field name has been determined");
            }
            Grok grok = new Grok(Grok.getBuiltinPatterns(), "(?m)%{DATA:preface}\\b" + this.fieldName + "=%{USER:" + GrokPatternCreator.VALUE + "}%{GREEDYDATA:" + GrokPatternCreator.EPILOGUE + "}");
            ArrayList<String> values = new ArrayList<String>();
            for (String snippet : snippets) {
                Map captures = grok.captures(snippet);
                if (captures == null) {
                    throw new IllegalStateException("[\\b" + this.fieldName + "=%{USER}] does not match snippet [" + snippet + "]");
                }
                prefaces.add(captures.getOrDefault(GrokPatternCreator.PREFACE, "").toString());
                values.add(captures.getOrDefault(GrokPatternCreator.VALUE, "").toString());
                epilogues.add(captures.getOrDefault(GrokPatternCreator.EPILOGUE, "").toString());
                timeoutChecker.check("full message Grok pattern field extraction");
            }
            String adjustedFieldName = GrokPatternCreator.buildFieldName(fieldNameCountStore, this.fieldName);
            if (mappings != null) {
                mappings.put(adjustedFieldName, FileStructureUtils.guessScalarMapping(this.explanation, adjustedFieldName, values));
                timeoutChecker.check("mapping determination");
            }
            if (fieldStats != null) {
                fieldStats.put(adjustedFieldName, FileStructureUtils.calculateFieldStats(values, timeoutChecker));
            }
            return "\\b" + this.fieldName + "=%{USER:" + adjustedFieldName + "}";
        }
    }

    static class ValueOnlyGrokPatternCandidate
    implements GrokPatternCandidate {
        private final String grokPatternName;
        private final String mappingType;
        private final String fieldName;
        private final Grok grok;

        ValueOnlyGrokPatternCandidate(String grokPatternName, String mappingType, String fieldName) {
            this(grokPatternName, mappingType, fieldName, "\\b", "\\b");
        }

        ValueOnlyGrokPatternCandidate(String grokPatternName, String mappingType, String fieldName, String preBreak, String postBreak) {
            this.grokPatternName = grokPatternName;
            this.mappingType = mappingType;
            this.fieldName = fieldName;
            this.grok = new Grok(Grok.getBuiltinPatterns(), "(?m)%{DATA:preface}" + preBreak + "%{" + grokPatternName + ":" + GrokPatternCreator.VALUE + "}" + postBreak + "%{GREEDYDATA:" + GrokPatternCreator.EPILOGUE + "}");
        }

        @Override
        public boolean matchesAll(Collection<String> snippets) {
            return snippets.stream().allMatch(arg_0 -> ((Grok)this.grok).match(arg_0));
        }

        @Override
        public String processCaptures(Map<String, Integer> fieldNameCountStore, Collection<String> snippets, Collection<String> prefaces, Collection<String> epilogues, Map<String, Object> mappings, Map<String, FieldStats> fieldStats, TimeoutChecker timeoutChecker) {
            ArrayList<String> values = new ArrayList<String>();
            for (String snippet : snippets) {
                Map captures = this.grok.captures(snippet);
                if (captures == null) {
                    throw new IllegalStateException("[%{" + this.grokPatternName + "}] does not match snippet [" + snippet + "]");
                }
                prefaces.add(captures.getOrDefault(GrokPatternCreator.PREFACE, "").toString());
                values.add(captures.getOrDefault(GrokPatternCreator.VALUE, "").toString());
                epilogues.add(captures.getOrDefault(GrokPatternCreator.EPILOGUE, "").toString());
                timeoutChecker.check("full message Grok pattern field extraction");
            }
            String adjustedFieldName = GrokPatternCreator.buildFieldName(fieldNameCountStore, this.fieldName);
            if (mappings != null) {
                Map<String, String> fullMappingType = Collections.singletonMap("type", this.mappingType);
                if ("date".equals(this.mappingType)) {
                    assert (!values.isEmpty());
                    TimestampFormatFinder.TimestampMatch timestampMatch = TimestampFormatFinder.findFirstFullMatch((String)values.iterator().next());
                    if (timestampMatch != null) {
                        fullMappingType = timestampMatch.getEsDateMappingTypeWithFormat();
                    }
                    timeoutChecker.check("mapping determination");
                }
                mappings.put(adjustedFieldName, fullMappingType);
            }
            if (fieldStats != null) {
                fieldStats.put(adjustedFieldName, FileStructureUtils.calculateFieldStats(values, timeoutChecker));
            }
            return "%{" + this.grokPatternName + ":" + adjustedFieldName + "}";
        }
    }

    static interface GrokPatternCandidate {
        public boolean matchesAll(Collection<String> var1);

        public String processCaptures(Map<String, Integer> var1, Collection<String> var2, Collection<String> var3, Collection<String> var4, Map<String, Object> var5, Map<String, FieldStats> var6, TimeoutChecker var7);
    }
}

