/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FieldStats;
import org.elasticsearch.xpack.core.ml.filestructurefinder.FileStructure;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureUtils;
import org.elasticsearch.xpack.ml.filestructurefinder.GrokPatternCreator;
import org.elasticsearch.xpack.ml.filestructurefinder.TimeoutChecker;
import org.elasticsearch.xpack.ml.filestructurefinder.TimestampFormatFinder;

public class TextLogFileStructureFinder
implements FileStructureFinder {
    private final List<String> sampleMessages;
    private final FileStructure structure;

    static TextLogFileStructureFinder makeTextLogFileStructureFinder(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        String[] sampleLines = sample.split("\n");
        Tuple<TimestampFormatFinder.TimestampMatch, Set<String>> bestTimestamp = TextLogFileStructureFinder.mostLikelyTimestamp(sampleLines, overrides, timeoutChecker);
        if (bestTimestamp == null) {
            throw new IllegalArgumentException("Could not find " + (overrides.getTimestampFormat() == null ? "a timestamp" : "the specified timestamp format") + " in the sample provided");
        }
        explanation.add((overrides.getTimestampFormat() == null ? "Most likely timestamp" : "Timestamp") + " format is [" + bestTimestamp.v1() + "]");
        ArrayList<String> sampleMessages = new ArrayList<String>();
        StringBuilder preamble = new StringBuilder();
        int linesConsumed = 0;
        StringBuilder message = null;
        int linesInMessage = 0;
        String multiLineRegex = TextLogFileStructureFinder.createMultiLineMessageStartRegex((Collection)bestTimestamp.v2(), ((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).simplePattern.pattern());
        Pattern multiLinePattern = Pattern.compile(multiLineRegex);
        for (String sampleLine : sampleLines) {
            if (multiLinePattern.matcher(sampleLine).find()) {
                if (message != null) {
                    sampleMessages.add(message.toString());
                    linesConsumed += linesInMessage;
                }
                message = new StringBuilder(sampleLine);
                linesInMessage = 1;
            } else if (message == null) {
                ++linesConsumed;
            } else {
                message.append('\n').append(sampleLine);
                ++linesInMessage;
            }
            timeoutChecker.check("multi-line message determination");
            if (sampleMessages.size() >= 2) continue;
            preamble.append(sampleLine).append('\n');
        }
        FileStructure.Builder structureBuilder = new FileStructure.Builder(FileStructure.Format.SEMI_STRUCTURED_TEXT).setCharset(charsetName).setHasByteOrderMarker(hasByteOrderMarker).setSampleStart(preamble.toString()).setNumLinesAnalyzed(linesConsumed).setNumMessagesAnalyzed(sampleMessages.size()).setMultilineStartPattern(multiLineRegex);
        TreeMap<String, Object> mappings = new TreeMap<String, Object>();
        mappings.put("message", Collections.singletonMap("type", "text"));
        mappings.put("@timestamp", Collections.singletonMap("type", "date"));
        TreeMap<String, FieldStats> fieldStats = new TreeMap<String, FieldStats>();
        fieldStats.put("message", FileStructureUtils.calculateFieldStats(sampleMessages, timeoutChecker));
        GrokPatternCreator grokPatternCreator = new GrokPatternCreator(explanation, sampleMessages, mappings, fieldStats, timeoutChecker);
        String interimTimestampField = overrides.getTimestampField();
        String grokPattern = overrides.getGrokPattern();
        if (grokPattern != null) {
            if (interimTimestampField == null) {
                interimTimestampField = "timestamp";
            }
            grokPatternCreator.validateFullLineGrokPattern(grokPattern, interimTimestampField);
        } else {
            Tuple<String, String> timestampFieldAndFullMatchGrokPattern = grokPatternCreator.findFullLineGrokPattern(interimTimestampField);
            if (timestampFieldAndFullMatchGrokPattern != null) {
                interimTimestampField = (String)timestampFieldAndFullMatchGrokPattern.v1();
                grokPattern = (String)timestampFieldAndFullMatchGrokPattern.v2();
            } else {
                if (interimTimestampField == null) {
                    interimTimestampField = "timestamp";
                }
                grokPattern = grokPatternCreator.createGrokPatternFromExamples(((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).grokPatternName, interimTimestampField);
            }
        }
        boolean needClientTimeZone = ((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).hasTimezoneDependentParsing();
        FileStructure structure = structureBuilder.setTimestampField(interimTimestampField).setJodaTimestampFormats(((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).jodaTimestampFormats).setJavaTimestampFormats(((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).javaTimestampFormats).setNeedClientTimezone(needClientTimeZone).setGrokPattern(grokPattern).setIngestPipeline(FileStructureUtils.makeIngestPipelineDefinition(grokPattern, interimTimestampField, ((TimestampFormatFinder.TimestampMatch)bestTimestamp.v1()).jodaTimestampFormats, needClientTimeZone)).setMappings(mappings).setFieldStats(fieldStats).setExplanation(explanation).build();
        return new TextLogFileStructureFinder(sampleMessages, structure);
    }

    private TextLogFileStructureFinder(List<String> sampleMessages, FileStructure structure) {
        this.sampleMessages = Collections.unmodifiableList(sampleMessages);
        this.structure = structure;
    }

    @Override
    public List<String> getSampleMessages() {
        return this.sampleMessages;
    }

    @Override
    public FileStructure getStructure() {
        return this.structure;
    }

    static Tuple<TimestampFormatFinder.TimestampMatch, Set<String>> mostLikelyTimestamp(String[] sampleLines, FileStructureOverrides overrides, TimeoutChecker timeoutChecker) {
        LinkedHashMap<TimestampFormatFinder.TimestampMatch, Tuple> timestampMatches = new LinkedHashMap<TimestampFormatFinder.TimestampMatch, Tuple>();
        int remainingLines = sampleLines.length;
        double differenceBetweenTwoHighestWeights = 0.0;
        for (String sampleLine : sampleLines) {
            TimestampFormatFinder.TimestampMatch match = TimestampFormatFinder.findFirstMatch(sampleLine, overrides.getTimestampFormat());
            if (match != null) {
                TimestampFormatFinder.TimestampMatch pureMatch = new TimestampFormatFinder.TimestampMatch(match.candidateIndex, "", match.jodaTimestampFormats, match.javaTimestampFormats, match.simplePattern, match.grokPatternName, "");
                timestampMatches.compute(pureMatch, (k, v) -> {
                    if (v == null) {
                        return new Tuple((Object)TextLogFileStructureFinder.weightForMatch(match.preface), new HashSet<String>(Collections.singletonList(match.preface)));
                    }
                    ((Set)v.v2()).add(match.preface);
                    return new Tuple((Object)((Double)v.v1() + TextLogFileStructureFinder.weightForMatch(match.preface)), (Object)((Set)v.v2()));
                });
                differenceBetweenTwoHighestWeights = TextLogFileStructureFinder.findDifferenceBetweenTwoHighestWeights(timestampMatches.values());
            }
            timeoutChecker.check("timestamp format determination");
            if (differenceBetweenTwoHighestWeights > (double)(--remainingLines)) break;
        }
        double highestWeight = 0.0;
        Tuple highestWeightMatch = null;
        for (Map.Entry entry : timestampMatches.entrySet()) {
            double weight = (Double)((Tuple)entry.getValue()).v1();
            if (!(weight > highestWeight)) continue;
            highestWeight = weight;
            highestWeightMatch = new Tuple((Object)((TimestampFormatFinder.TimestampMatch)entry.getKey()), (Object)((Set)((Tuple)entry.getValue()).v2()));
        }
        return highestWeightMatch;
    }

    private static double weightForMatch(String preface) {
        return Math.pow(1.0 + (double)preface.length() / 15.0, -1.1);
    }

    private static double findDifferenceBetweenTwoHighestWeights(Collection<Tuple<Double, Set<String>>> timestampMatches) {
        double highestWeight = 0.0;
        double secondHighestWeight = 0.0;
        for (Tuple<Double, Set<String>> timestampMatch : timestampMatches) {
            double weight = (Double)timestampMatch.v1();
            if (weight > highestWeight) {
                secondHighestWeight = highestWeight;
                highestWeight = weight;
                continue;
            }
            if (!(weight > secondHighestWeight)) continue;
            secondHighestWeight = weight;
        }
        return highestWeight - secondHighestWeight;
    }

    static String createMultiLineMessageStartRegex(Collection<String> prefaces, String timestampRegex) {
        StringBuilder builder = new StringBuilder("^");
        GrokPatternCreator.addIntermediateRegex(builder, prefaces);
        builder.append(timestampRegex);
        if (builder.substring(0, 3).equals("^\\b")) {
            builder.delete(1, 3);
        }
        return builder.toString();
    }
}

