/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.filestructurefinder;

import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public class TimeoutChecker
implements Closeable {
    private final String operation;
    private final ScheduledFuture<?> future;
    private final TimeValue timeout;
    private volatile boolean timeoutExceeded;

    public TimeoutChecker(String operation, TimeValue timeout, ScheduledExecutorService scheduler) {
        this.operation = operation;
        this.timeout = timeout;
        this.future = timeout != null ? scheduler.schedule(this::setTimeoutExceeded, timeout.nanos(), TimeUnit.NANOSECONDS) : null;
    }

    @Override
    public void close() {
        FutureUtils.cancel(this.future);
    }

    public void check(String where) {
        if (this.timeoutExceeded) {
            throw new ElasticsearchTimeoutException("Aborting " + this.operation + " during [" + where + "] as it has taken longer than the timeout of [" + this.timeout + "]", new Object[0]);
        }
    }

    private void setTimeoutExceeded() {
        this.timeoutExceeded = true;
    }
}

