/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.matrix.stats.MatrixStats;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;
import org.elasticsearch.search.aggregations.metrics.stats.InternalStats;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;

public class MetricAggExtractor
implements BucketExtractor {
    static final String NAME = "m";
    private final String name;
    private final String property;
    private final String innerKey;

    public MetricAggExtractor(String name, String property, String innerKey) {
        this.name = name;
        this.property = property;
        this.innerKey = innerKey;
    }

    MetricAggExtractor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.property = in.readString();
        this.innerKey = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.property);
        out.writeOptionalString(this.innerKey);
    }

    String name() {
        return this.name;
    }

    String property() {
        return this.property;
    }

    String innerKey() {
        return this.innerKey;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        InternalAggregation agg = (InternalAggregation)bucket.getAggregations().get(this.name);
        if (agg == null) {
            throw new SqlIllegalArgumentException("Cannot find an aggregation named {}", this.name);
        }
        if (!MetricAggExtractor.containsValues(agg)) {
            return null;
        }
        if (agg instanceof InternalNumericMetricsAggregation.MultiValue) {
            return ((InternalNumericMetricsAggregation.MultiValue)agg).value(this.property);
        }
        Object v = agg.getProperty(this.property);
        return this.innerKey != null && v instanceof Map ? ((Map)v).get(this.innerKey) : v;
    }

    private static boolean containsValues(InternalAggregation agg) {
        if (agg instanceof InternalStats) {
            return ((InternalStats)agg).getCount() != 0L;
        }
        if (agg instanceof MatrixStats) {
            return ((MatrixStats)agg).getDocCount() != 0L;
        }
        if (agg instanceof InternalNumericMetricsAggregation.SingleValue) {
            return Double.isFinite(((InternalNumericMetricsAggregation.SingleValue)agg).value());
        }
        if (agg instanceof PercentileRanks) {
            return Double.isFinite(((PercentileRanks)agg).percent(0.0));
        }
        if (agg instanceof Percentiles) {
            return Double.isFinite(((Percentiles)agg).percentile(0.0));
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.property, this.innerKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetricAggExtractor other = (MetricAggExtractor)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.property, other.property) && Objects.equals(this.innerKey, other.innerKey);
    }

    public String toString() {
        String i = this.innerKey != null ? "[" + this.innerKey + "]" : "";
        return "groupby>" + this.name + "." + this.property + i;
    }
}

