/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class Order
extends Expression {
    private final Expression child;
    private final OrderDirection direction;
    private final NullsPosition nulls;

    public Order(Location location, Expression child, OrderDirection direction, NullsPosition nulls) {
        super(location, Collections.singletonList(child));
        this.child = child;
        this.direction = direction;
        this.nulls = nulls == null ? (direction == OrderDirection.DESC ? NullsPosition.FIRST : NullsPosition.LAST) : nulls;
    }

    @Override
    protected NodeInfo<Order> info() {
        return NodeInfo.create(this, Order::new, this.child, this.direction, this.nulls);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Order replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new Order(this.location(), newChildren.get(0), this.direction, this.nulls);
    }

    public Expression child() {
        return this.child;
    }

    public OrderDirection direction() {
        return this.direction;
    }

    public NullsPosition nullsPosition() {
        return this.nulls;
    }

    @Override
    public boolean foldable() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.child, this.direction, this.nulls});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals((Object)this.nulls, (Object)other.nulls) && Objects.equals(this.child, other.child);
    }

    public static enum NullsPosition {
        FIRST,
        LAST;

    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }
}

