/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.UnresolvedException;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.UnresolvedNamedExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class UnresolvedAlias
extends UnresolvedNamedExpression {
    private final Expression child;

    public UnresolvedAlias(Location location, Expression child) {
        super(location, Collections.singletonList(child));
        this.child = child;
    }

    @Override
    protected NodeInfo<UnresolvedAlias> info() {
        return NodeInfo.create(this, UnresolvedAlias::new, this.child);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new UnresolvedAlias(this.location(), newChildren.get(0));
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public String unresolvedMessage() {
        return "Unknown alias [" + this.name() + "]";
    }

    @Override
    public boolean nullable() {
        throw new UnresolvedException("nullable", (Object)this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(this.child, ((UnresolvedAlias)obj).child);
    }

    @Override
    public String toString() {
        return this.child + " AS ?";
    }
}

