/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.DataType;

public class PercentileRank
extends AggregateFunction
implements EnclosedAgg {
    private final Expression value;

    public PercentileRank(Location location, Expression field, Expression value) {
        super(location, field, Collections.singletonList(value));
        this.value = value;
    }

    @Override
    protected NodeInfo<PercentileRank> info() {
        return NodeInfo.create(this, PercentileRank::new, this.field(), this.value);
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new PercentileRank(this.location(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.unresolved()) {
            return resolution;
        }
        return Expressions.typeMustBeNumeric(this.value, this.functionName(), Expressions.ParamOrdinal.DEFAULT);
    }

    public Expression value() {
        return this.value;
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    public String innerName() {
        return Double.toString(Foldables.doubleValueOf(this.value));
    }
}

