/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class Percentiles
extends CompoundNumericAggregate {
    private final List<Expression> percents;

    public Percentiles(Location location, Expression field, List<Expression> percents) {
        super(location, field, percents);
        this.percents = percents;
    }

    @Override
    protected NodeInfo<Percentiles> info() {
        return NodeInfo.create(this, Percentiles::new, this.field(), this.percents);
    }

    @Override
    public Percentiles replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() < 2) {
            throw new IllegalArgumentException("expected more than one child but received [" + newChildren.size() + "]");
        }
        return new Percentiles(this.location(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    public List<Expression> percents() {
        return this.percents;
    }
}

