/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.LocateFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class LocateFunctionPipe
extends Pipe {
    private final Pipe pattern;
    private final Pipe source;
    private final Pipe start;

    public LocateFunctionPipe(Location location, Expression expression, Pipe pattern, Pipe source, Pipe start) {
        super(location, expression, start == null ? Arrays.asList(pattern, source) : Arrays.asList(pattern, source, start));
        this.pattern = pattern;
        this.source = source;
        this.start = start;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        int childrenSize = newChildren.size();
        if (childrenSize > 3 || childrenSize < 2) {
            throw new IllegalArgumentException("expected [2 or 3] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), childrenSize == 2 ? null : newChildren.get(2));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newStart;
        Pipe newPattern = this.pattern.resolveAttributes(resolver);
        Pipe newSource = this.source.resolveAttributes(resolver);
        Pipe pipe = newStart = this.start == null ? this.start : this.start.resolveAttributes(resolver);
        if (newPattern == this.pattern && newSource == this.source && newStart == this.start) {
            return this;
        }
        return this.replaceChildren(newPattern, newSource, newStart);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.pattern.supportedByAggsOnlyQuery() && this.source.supportedByAggsOnlyQuery() && (this.start == null || this.start.supportedByAggsOnlyQuery());
    }

    @Override
    public boolean resolved() {
        return this.pattern.resolved() && this.source.resolved() && (this.start == null || this.start.resolved());
    }

    protected Pipe replaceChildren(Pipe newPattern, Pipe newSource, Pipe newStart) {
        return new LocateFunctionPipe(this.location(), this.expression(), newPattern, newSource, newStart);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.pattern.collectFields(sourceBuilder);
        this.source.collectFields(sourceBuilder);
        if (this.start != null) {
            this.start.collectFields(sourceBuilder);
        }
    }

    @Override
    protected NodeInfo<LocateFunctionPipe> info() {
        return NodeInfo.create(this, LocateFunctionPipe::new, this.expression(), this.pattern, this.source, this.start);
    }

    @Override
    public LocateFunctionProcessor asProcessor() {
        return new LocateFunctionProcessor(this.pattern.asProcessor(), this.source.asProcessor(), this.start == null ? null : this.start.asProcessor());
    }

    public Pipe source() {
        return this.source;
    }

    public Pipe start() {
        return this.start;
    }

    public Pipe pattern() {
        return this.pattern;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern, this.source, this.start);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocateFunctionPipe other = (LocateFunctionPipe)obj;
        return Objects.equals(this.pattern, other.pattern) && Objects.equals(this.source, other.source) && Objects.equals(this.start, other.start);
    }
}

