/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command.sys;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class SysTables
extends Command {
    private final String index;
    private final LikePattern pattern;
    private final LikePattern clusterPattern;
    private final EnumSet<IndexResolver.IndexType> types;
    private final boolean legacyTableTypes;

    public SysTables(Location location, LikePattern clusterPattern, String index, LikePattern pattern, EnumSet<IndexResolver.IndexType> types, boolean legacyTableTypes) {
        super(location);
        this.clusterPattern = clusterPattern;
        this.index = index;
        this.pattern = pattern;
        this.types = types;
        this.legacyTableTypes = legacyTableTypes;
    }

    @Override
    protected NodeInfo<SysTables> info() {
        return NodeInfo.create(this, SysTables::new, this.clusterPattern, this.index, this.pattern, this.types, this.legacyTableTypes);
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("TABLE_CAT"), this.keyword("TABLE_SCHEM"), this.keyword("TABLE_NAME"), this.keyword("TABLE_TYPE"), this.keyword("REMARKS"), this.keyword("TYPE_CAT"), this.keyword("TYPE_SCHEM"), this.keyword("TYPE_NAME"), this.keyword("SELF_REFERENCING_COL_NAME"), this.keyword("REF_GENERATION"));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        String cRegex;
        String cluster = session.indexResolver().clusterName();
        if (this.clusterPattern != null && this.clusterPattern.pattern().equals("%") && (this.pattern == null || this.pattern.pattern().isEmpty()) && CollectionUtils.isEmpty(this.types)) {
            Object[] enumeration = new Object[10];
            enumeration[0] = cluster;
            listener.onResponse((Object)Rows.singleton(this.output(), enumeration));
            return;
        }
        if (IndexResolver.IndexType.VALID.equals(this.types) && (this.clusterPattern == null || this.clusterPattern.pattern().isEmpty()) && (this.pattern == null || this.pattern.pattern().isEmpty())) {
            ArrayList values = new ArrayList();
            for (IndexResolver.IndexType type : IndexResolver.IndexType.VALID) {
                Object[] enumeration = new Object[10];
                enumeration[3] = type.toSql();
                values.add(Arrays.asList(enumeration));
            }
            values.sort(Comparator.comparing(l -> l.get(3).toString()));
            listener.onResponse((Object)Rows.of(this.output(), values));
            return;
        }
        String string = cRegex = this.clusterPattern != null ? this.clusterPattern.asJavaRegex() : null;
        if (cRegex != null && !Pattern.matches(cRegex, cluster)) {
            listener.onResponse((Object)Rows.empty(this.output()));
            return;
        }
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        session.indexResolver().resolveNames(idx, regex, this.types, (ActionListener<Set<IndexResolver.IndexInfo>>)ActionListener.wrap(result -> listener.onResponse((Object)Rows.of(this.output(), result.stream().sorted(Comparator.comparing(i -> this.legacyName(i.type())).thenComparing(Comparator.comparing(i -> i.name()))).map(t -> Arrays.asList(cluster, "", t.name(), this.legacyName(t.type()), "", null, null, null, null, null)).collect(Collectors.toList()))), arg_0 -> listener.onFailure(arg_0)));
    }

    private String legacyName(IndexResolver.IndexType indexType) {
        return this.legacyTableTypes && indexType == IndexResolver.IndexType.INDEX ? "TABLE" : indexType.toSql();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterPattern, this.index, this.pattern, this.types);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SysTables other = (SysTables)obj;
        return Objects.equals(this.clusterPattern, other.clusterPattern) && Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.types, other.types);
    }
}

