/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;

public class GroupByScriptKey
extends GroupByKey {
    private final ScriptTemplate script;

    public GroupByScriptKey(String id, String fieldName, ScriptTemplate script) {
        this(id, fieldName, null, script);
    }

    public GroupByScriptKey(String id, String fieldName, Sort.Direction direction, ScriptTemplate script) {
        super(id, fieldName, direction);
        this.script = script;
    }

    public ScriptTemplate script() {
        return this.script;
    }

    public TermsValuesSourceBuilder asValueSource() {
        TermsValuesSourceBuilder builder = (TermsValuesSourceBuilder)((TermsValuesSourceBuilder)((TermsValuesSourceBuilder)new TermsValuesSourceBuilder(this.id()).script(this.script.toPainless())).order(this.direction().asOrder())).missingBucket(true);
        if (this.script.outputType().isInteger) {
            builder.valueType(ValueType.LONG);
        } else if (this.script.outputType().isRational) {
            builder.valueType(ValueType.DOUBLE);
        } else if (this.script.outputType().isString()) {
            builder.valueType(ValueType.STRING);
        }
        return builder;
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, Sort.Direction direction) {
        return new GroupByScriptKey(id, fieldName, direction, this.script);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.script);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.script, ((GroupByScriptKey)obj).script);
    }
}

